/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.pdx.PdxSerializer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.CacheServerApplication;
import org.springframework.data.gemfire.config.annotation.ClientCacheApplication;
import org.springframework.data.gemfire.config.annotation.EnablePdx;
import org.springframework.data.gemfire.config.annotation.PeerCacheApplication;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractCacheConfiguration
implements BeanFactoryAware,
BeanClassLoaderAware,
ImportAware {
    protected static final boolean DEFAULT_CLOSE = true;
    protected static final boolean DEFAULT_COPY_ON_READ = false;
    protected static final boolean DEFAULT_USE_BEAN_FACTORY_LOCATOR = false;
    protected static final String DEFAULT_LOG_LEVEL = "config";
    protected static final String DEFAULT_NAME = "SpringDataGemFireApplication";
    private boolean close = true;
    private boolean copyOnRead = false;
    private boolean useBeanFactoryLocator = false;
    private BeanFactory beanFactory;
    private Boolean pdxIgnoreUnreadFields;
    private Boolean pdxPersistent;
    private Boolean pdxReadSerialized;
    private ClassLoader beanClassLoader;
    private CacheFactoryBean.DynamicRegionSupport dynamicRegionSupport;
    private Float criticalHeapPercentage;
    private Float evictionHeapPercentage;
    private GatewayConflictResolver gatewayConflictResolver;
    private List<CacheFactoryBean.JndiDataSource> jndiDataSources;
    private List<TransactionListener> transactionListeners;
    private PdxSerializer pdxSerializer;
    private Resource cacheXml;
    private String locators = "";
    private String logLevel = "config";
    private String name;
    private String pdxDiskStoreName;
    private TransactionWriter transactionWriter;

    protected static <T> List<T> nullSafeList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    protected static <T> Set<T> nullSafeSet(Set<T> set) {
        return set != null ? set : Collections.emptySet();
    }

    protected static <T> T nullSafeValue(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    protected static boolean hasValue(Object value) {
        return value != null;
    }

    protected static boolean hasValue(Number value) {
        return value != null && value.doubleValue() != 0.0;
    }

    protected static boolean hasValue(String value) {
        return StringUtils.hasText((String)value);
    }

    @Bean
    protected Properties gemfireProperties() {
        Properties gemfireProperties = new Properties();
        gemfireProperties.setProperty("name", this.name());
        gemfireProperties.setProperty("mcast-port", "0");
        gemfireProperties.setProperty("log-level", this.logLevel());
        gemfireProperties.setProperty("locators", this.locators());
        return gemfireProperties;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    protected ClassLoader beanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory beanFactory() {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory was not properly initialized");
        return this.beanFactory;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.configureCache(importMetadata);
        this.configurePdx(importMetadata);
        this.configureOther(importMetadata);
    }

    protected void configureCache(AnnotationMetadata importMetadata) {
        if (this.isClientPeerOrServerCacheApplication(importMetadata)) {
            Float evictionHeapPercentage;
            Map cacheMetadataAttributes = importMetadata.getAnnotationAttributes(this.getAnnotationTypeName());
            this.setCopyOnRead(Boolean.TRUE.equals(cacheMetadataAttributes.get("copyOnRead")));
            Float criticalHeapPercentage = (Float)cacheMetadataAttributes.get("criticalHeapPercentage");
            if (AbstractCacheConfiguration.hasValue(criticalHeapPercentage)) {
                this.setCriticalHeapPercentage(criticalHeapPercentage);
            }
            if (AbstractCacheConfiguration.hasValue(evictionHeapPercentage = (Float)cacheMetadataAttributes.get("evictionHeapPercentage"))) {
                this.setEvictionHeapPercentage(evictionHeapPercentage);
            }
            this.setLogLevel((String)cacheMetadataAttributes.get("logLevel"));
            this.setName((String)cacheMetadataAttributes.get("name"));
        }
    }

    protected void configurePdx(AnnotationMetadata importMetadata) {
        if (importMetadata.hasAnnotation(EnablePdx.class.getName())) {
            Map enablePdxAttributes = importMetadata.getAnnotationAttributes(EnablePdx.class.getName());
            String pdxSerializerBeanName = (String)enablePdxAttributes.get("serializerBeanName");
            if (this.beanFactory().containsBean(pdxSerializerBeanName)) {
                PdxSerializer pdxSerializer = (PdxSerializer)this.beanFactory().getBean(pdxSerializerBeanName, PdxSerializer.class);
                this.setPdxDiskStoreName((String)enablePdxAttributes.get("diskStoreName"));
                this.setPdxIgnoreUnreadFields(Boolean.TRUE.equals(enablePdxAttributes.get("ignoreUnreadFields")));
                this.setPdxPersistent(Boolean.TRUE.equals(enablePdxAttributes.get("persistent")));
                this.setPdxReadSerialized(Boolean.TRUE.equals(enablePdxAttributes.get("readSerialized")));
                this.setPdxSerializer(pdxSerializer);
            }
        }
    }

    protected void configureOther(AnnotationMetadata importMetadata) {
    }

    protected abstract Class getAnnotationType();

    protected String getAnnotationTypeName() {
        return this.getAnnotationType().getName();
    }

    protected String getAnnotationTypeSimpleName() {
        return this.getAnnotationType().getSimpleName();
    }

    protected boolean isCacheServerApplication(AnnotationMetadata importMetadata) {
        return CacheServerApplication.class.equals((Object)this.getAnnotationType()) && importMetadata.hasAnnotation(this.getAnnotationTypeName());
    }

    protected boolean isClientCacheApplication(AnnotationMetadata importMetadata) {
        return ClientCacheApplication.class.equals((Object)this.getAnnotationType()) && importMetadata.hasAnnotation(this.getAnnotationTypeName());
    }

    protected boolean isPeerCacheApplication(AnnotationMetadata importMetadata) {
        return PeerCacheApplication.class.equals((Object)this.getAnnotationType()) && importMetadata.hasAnnotation(this.getAnnotationTypeName());
    }

    protected boolean isClientPeerOrServerCacheApplication(AnnotationMetadata importMetadata) {
        return this.isCacheServerApplication(importMetadata) || this.isClientCacheApplication(importMetadata) || this.isPeerCacheApplication(importMetadata);
    }

    protected <T extends CacheFactoryBean> T constructCacheFactoryBean() {
        return this.setCommonCacheConfiguration(this.newCacheFactoryBean());
    }

    protected abstract <T extends CacheFactoryBean> T newCacheFactoryBean();

    protected <T extends CacheFactoryBean> T setCommonCacheConfiguration(T gemfireCache) {
        gemfireCache.setBeanClassLoader(this.beanClassLoader());
        gemfireCache.setBeanFactory(this.beanFactory());
        gemfireCache.setCacheXml(this.cacheXml());
        gemfireCache.setClose(this.close());
        gemfireCache.setCopyOnRead(this.copyOnRead());
        gemfireCache.setCriticalHeapPercentage(this.criticalHeapPercentage());
        gemfireCache.setDynamicRegionSupport(this.dynamicRegionSupport());
        gemfireCache.setEvictionHeapPercentage(this.evictionHeapPercentage());
        gemfireCache.setGatewayConflictResolver(this.gatewayConflictResolver());
        gemfireCache.setJndiDataSources(this.jndiDataSources());
        gemfireCache.setProperties(this.gemfireProperties());
        gemfireCache.setPdxDiskStoreName(this.pdxDiskStoreName());
        gemfireCache.setPdxIgnoreUnreadFields(this.pdxIgnoreUnreadFields());
        gemfireCache.setPdxPersistent(this.pdxPersistent());
        gemfireCache.setPdxReadSerialized(this.pdxReadSerialized());
        gemfireCache.setPdxSerializer(this.pdxSerializer());
        gemfireCache.setTransactionListeners(this.transactionListeners());
        gemfireCache.setTransactionWriter(this.transactionWriter());
        return gemfireCache;
    }

    void setCacheXml(Resource cacheXml) {
        this.cacheXml = cacheXml;
    }

    protected Resource cacheXml() {
        return this.cacheXml;
    }

    void setClose(boolean close) {
        this.close = close;
    }

    protected boolean close() {
        return this.close;
    }

    void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    protected boolean copyOnRead() {
        return this.copyOnRead;
    }

    void setCriticalHeapPercentage(Float criticalHeapPercentage) {
        this.criticalHeapPercentage = criticalHeapPercentage;
    }

    protected Float criticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    void setDynamicRegionSupport(CacheFactoryBean.DynamicRegionSupport dynamicRegionSupport) {
        this.dynamicRegionSupport = dynamicRegionSupport;
    }

    protected CacheFactoryBean.DynamicRegionSupport dynamicRegionSupport() {
        return this.dynamicRegionSupport;
    }

    void setEvictionHeapPercentage(Float evictionHeapPercentage) {
        this.evictionHeapPercentage = evictionHeapPercentage;
    }

    protected Float evictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    void setGatewayConflictResolver(GatewayConflictResolver gatewayConflictResolver) {
        this.gatewayConflictResolver = gatewayConflictResolver;
    }

    protected GatewayConflictResolver gatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    void setJndiDataSources(List<CacheFactoryBean.JndiDataSource> jndiDataSources) {
        this.jndiDataSources = jndiDataSources;
    }

    protected List<CacheFactoryBean.JndiDataSource> jndiDataSources() {
        return AbstractCacheConfiguration.nullSafeList(this.jndiDataSources);
    }

    void setLocators(String locators) {
        this.locators = locators;
    }

    protected String locators() {
        return this.locators;
    }

    void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    protected String logLevel() {
        return AbstractCacheConfiguration.nullSafeValue(this.logLevel, DEFAULT_LOG_LEVEL);
    }

    void setName(String name) {
        this.name = name;
    }

    protected String name() {
        return StringUtils.hasText((String)this.name) ? this.name : this.toString();
    }

    void setPdxDiskStoreName(String pdxDiskStoreName) {
        this.pdxDiskStoreName = pdxDiskStoreName;
    }

    protected String pdxDiskStoreName() {
        return this.pdxDiskStoreName;
    }

    void setPdxIgnoreUnreadFields(Boolean pdxIgnoreUnreadFields) {
        this.pdxIgnoreUnreadFields = pdxIgnoreUnreadFields;
    }

    protected Boolean pdxIgnoreUnreadFields() {
        return this.pdxIgnoreUnreadFields;
    }

    void setPdxPersistent(Boolean pdxPersistent) {
        this.pdxPersistent = pdxPersistent;
    }

    protected Boolean pdxPersistent() {
        return this.pdxPersistent;
    }

    void setPdxReadSerialized(Boolean pdxReadSerialized) {
        this.pdxReadSerialized = pdxReadSerialized;
    }

    protected Boolean pdxReadSerialized() {
        return this.pdxReadSerialized;
    }

    void setPdxSerializer(PdxSerializer pdxSerializer) {
        this.pdxSerializer = pdxSerializer;
    }

    protected PdxSerializer pdxSerializer() {
        return this.pdxSerializer;
    }

    void setTransactionListeners(List<TransactionListener> transactionListeners) {
        this.transactionListeners = transactionListeners;
    }

    protected List<TransactionListener> transactionListeners() {
        return AbstractCacheConfiguration.nullSafeList(this.transactionListeners);
    }

    void setTransactionWriter(TransactionWriter transactionWriter) {
        this.transactionWriter = transactionWriter;
    }

    protected TransactionWriter transactionWriter() {
        return this.transactionWriter;
    }

    void setUseBeanFactoryLocator(boolean useBeanFactoryLocator) {
        this.useBeanFactoryLocator = useBeanFactoryLocator;
    }

    protected boolean useBeanFactoryLocator() {
        return this.useBeanFactoryLocator;
    }

    public String toString() {
        return DEFAULT_NAME;
    }
}

