/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.client.PoolFactoryBean;

public class ClientRegionAndPoolBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    protected static final String POOL_NAME_PROPERTY = "poolName";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashSet<String> clientRegionBeanNames = new HashSet<String>();
        HashSet<String> poolBeanNames = new HashSet<String>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (this.isClientRegionBean(beanDefinition)) {
                clientRegionBeanNames.add(beanName);
                continue;
            }
            if (!this.isPoolBean(beanDefinition)) continue;
            poolBeanNames.add(beanName);
        }
        for (String clientRegionBeanName : clientRegionBeanNames) {
            BeanDefinition clientRegionBean = beanFactory.getBeanDefinition(clientRegionBeanName);
            String poolName = this.getPoolName(clientRegionBean);
            if (!poolBeanNames.contains(poolName)) continue;
            this.addDependsOn(clientRegionBean, poolName);
        }
    }

    boolean isClientRegionBean(BeanDefinition beanDefinition) {
        return ClientRegionFactoryBean.class.getName().equals(beanDefinition.getBeanClassName());
    }

    boolean isPoolBean(BeanDefinition beanDefinition) {
        return PoolFactoryBean.class.getName().equals(beanDefinition.getBeanClassName());
    }

    String getPoolName(BeanDefinition clientRegionBean) {
        PropertyValue poolNameProperty = clientRegionBean.getPropertyValues().getPropertyValue(POOL_NAME_PROPERTY);
        return poolNameProperty != null ? String.valueOf(poolNameProperty.getValue()) : null;
    }

    BeanDefinition addDependsOn(BeanDefinition bean, String beanName) {
        String[] dependsOn = bean.getDependsOn();
        ArrayList<String> dependsOnList = new ArrayList<String>();
        if (dependsOn != null) {
            Collections.addAll(dependsOnList, dependsOn);
        }
        dependsOnList.add(beanName);
        bean.setDependsOn(dependsOnList.toArray(new String[dependsOnList.size()]));
        return bean;
    }
}

