/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.util.TypeInformation;

public interface PersistentEntity<T, P extends PersistentProperty<P>> {
    public String getName();

    public Optional<PreferredConstructor<T, P>> getPersistenceConstructor();

    public boolean isConstructorArgument(PersistentProperty<?> var1);

    public boolean isIdProperty(PersistentProperty<?> var1);

    public boolean isVersionProperty(PersistentProperty<?> var1);

    public Optional<P> getIdProperty();

    default public P getRequiredIdProperty() {
        return (P)((PersistentProperty)this.getIdProperty().orElseThrow(() -> new IllegalStateException(String.format("Required identifier property not found for %s!", this.getType()))));
    }

    public Optional<P> getVersionProperty();

    public Optional<P> getPersistentProperty(String var1);

    default public P getRequiredPersistentProperty(String name) {
        return (P)((PersistentProperty)this.getPersistentProperty(name).orElseThrow(() -> new IllegalArgumentException(String.format("No property %s found for type %s!", name, this.getType()))));
    }

    public Optional<P> getPersistentProperty(Class<? extends Annotation> var1);

    public boolean hasIdProperty();

    public boolean hasVersionProperty();

    public Class<T> getType();

    public Alias getTypeAlias();

    public TypeInformation<T> getTypeInformation();

    public void doWithProperties(PropertyHandler<P> var1);

    public void doWithProperties(SimplePropertyHandler var1);

    public Stream<P> getPersistentProperties();

    public void doWithAssociations(AssociationHandler<P> var1);

    public void doWithAssociations(SimpleAssociationHandler var1);

    public Stream<Association<P>> getAssociations();

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> var1);

    public PersistentPropertyAccessor getPropertyAccessor(Object var1);

    public IdentifierAccessor getIdentifierAccessor(Object var1);
}

