/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.beans.ConstructorProperties;
import java.util.Optional;

public final class Alias {
    public static Alias NONE = new Alias(Optional.empty());
    private final Optional<? extends Object> value;

    public static Alias of(Object alias) {
        return Alias.ofOptional(Optional.of(alias));
    }

    public static Alias ofOptional(Optional<? extends Object> optional) {
        return optional.isPresent() ? new Alias(optional) : NONE;
    }

    public boolean isPresentButDifferent(Alias other) {
        return this.isPresent() && !this.hasValue(other.value);
    }

    public boolean hasValue(Object that) {
        return this.value.filter(it -> it.equals(that)).isPresent();
    }

    public boolean hasSamePresentValueAs(Alias other) {
        return this.isPresent() && this.hasValue(other.value);
    }

    public boolean isPresent() {
        return this.value.isPresent();
    }

    public <T> Optional<T> mapTyped(Class<T> type) {
        return this.value.filter(type::isInstance).map(type::cast);
    }

    public String toString() {
        return this.value.map(Object::toString).orElse("NONE");
    }

    public Optional<? extends Object> getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alias)) {
            return false;
        }
        Alias other = (Alias)o;
        Optional<? extends Object> this$value = this.getValue();
        Optional<? extends Object> other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<? extends Object> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @ConstructorProperties(value={"value"})
    private Alias(Optional<? extends Object> value) {
        this.value = value;
    }
}

