/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.util.Assert;
import org.springframework.web.bind.WebDataBinder;

class MapDataBinder
extends WebDataBinder {
    private final Class<?> type;
    private final ConversionService conversionService;

    public MapDataBinder(Class<?> type, ConversionService conversionService) {
        super(new HashMap());
        this.type = type;
        this.conversionService = conversionService;
    }

    public Map<String, Object> getTarget() {
        return (Map)super.getTarget();
    }

    protected ConfigurablePropertyAccessor getPropertyAccessor() {
        return new MapPropertyAccessor(this.type, (Map<String, Object>)this.getTarget(), this.conversionService);
    }

    private static class MapPropertyAccessor
    extends AbstractPropertyAccessor {
        private static final SpelExpressionParser PARSER = new SpelExpressionParser(new SpelParserConfiguration(false, true));
        private final Class<?> type;
        private final Map<String, Object> map;
        private final ConversionService conversionService;

        public MapPropertyAccessor(Class<?> type, Map<String, Object> map, ConversionService conversionService) {
            Assert.notNull(type, (String)"Type must not be null!");
            Assert.notNull(map, (String)"Map must not be null!");
            Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
            this.type = type;
            this.map = map;
            this.conversionService = conversionService;
        }

        public boolean isReadableProperty(String propertyName) {
            throw new UnsupportedOperationException();
        }

        public boolean isWritableProperty(String propertyName) {
            try {
                return this.getPropertyPath(propertyName) != null;
            }
            catch (PropertyReferenceException o_O) {
                return false;
            }
        }

        public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
            throw new UnsupportedOperationException();
        }

        public Object getPropertyValue(String propertyName) throws BeansException {
            throw new UnsupportedOperationException();
        }

        public void setPropertyValue(String propertyName, Object value) throws BeansException {
            if (!this.isWritableProperty(propertyName)) {
                throw new NotWritablePropertyException(this.type, propertyName);
            }
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.addPropertyAccessor((PropertyAccessor)new PropertyTraversingMapAccessor(this.type, (ConversionService)new DefaultConversionService()));
            context.setTypeConverter((TypeConverter)new StandardTypeConverter(this.conversionService));
            context.setRootObject(this.map);
            Expression expression = PARSER.parseExpression(propertyName);
            PropertyPath leafProperty = this.getPropertyPath(propertyName).getLeafProperty();
            TypeInformation<?> owningType = leafProperty.getOwningType();
            TypeInformation<?> propertyType = leafProperty.getTypeInformation();
            TypeInformation<?> typeInformation = propertyType = propertyName.endsWith("]") ? propertyType.getActualType() : propertyType;
            if (this.conversionRequired(value, propertyType.getType())) {
                PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(owningType.getType(), (String)leafProperty.getSegment());
                MethodParameter methodParameter = new MethodParameter(descriptor.getReadMethod(), -1);
                TypeDescriptor typeDescriptor = TypeDescriptor.nested((MethodParameter)methodParameter, (int)0);
                value = this.conversionService.convert(value, TypeDescriptor.forObject((Object)value), typeDescriptor);
            }
            expression.setValue((EvaluationContext)context, value);
        }

        private boolean conversionRequired(Object source, Class<?> targetType) {
            if (targetType.isInstance(source)) {
                return false;
            }
            return this.conversionService.canConvert(source.getClass(), targetType);
        }

        private PropertyPath getPropertyPath(String propertyName) {
            String plainPropertyPath = propertyName.replaceAll("\\[.*?\\]", "");
            return PropertyPath.from(plainPropertyPath, this.type);
        }

        private static final class PropertyTraversingMapAccessor
        extends MapAccessor {
            private final ConversionService conversionService;
            private Class<?> type;

            public PropertyTraversingMapAccessor(Class<?> type, ConversionService conversionService) {
                Assert.notNull(type, (String)"Type must not be null!");
                Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
                this.type = type;
                this.conversionService = conversionService;
            }

            public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
                PropertyPath path = PropertyPath.from(name, this.type);
                try {
                    TypedValue typedValue = super.read(context, target, name);
                    return typedValue;
                }
                catch (AccessException o_O) {
                    Object emptyResult = path.isCollection() ? CollectionFactory.createCollection(List.class, (int)0) : CollectionFactory.createMap(Map.class, (int)0);
                    ((Map)target).put(name, emptyResult);
                    TypedValue typedValue = new TypedValue(emptyResult, this.getDescriptor(path, emptyResult));
                    return typedValue;
                }
                finally {
                    this.type = path.getType();
                }
            }

            private TypeDescriptor getDescriptor(PropertyPath path, Object emptyValue) {
                Class<?> actualPropertyType = path.getType();
                TypeDescriptor valueDescriptor = this.conversionService.canConvert(String.class, actualPropertyType) ? TypeDescriptor.valueOf(String.class) : TypeDescriptor.valueOf(HashMap.class);
                return path.isCollection() ? TypeDescriptor.collection(emptyValue.getClass(), (TypeDescriptor)valueDescriptor) : TypeDescriptor.map(emptyValue.getClass(), (TypeDescriptor)TypeDescriptor.valueOf(String.class), (TypeDescriptor)valueDescriptor);
            }
        }
    }
}

