/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.util.Assert;

public class Lazy<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private Optional<T> value;

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    @Override
    public T get() {
        if (this.value == null) {
            this.value = Optional.ofNullable(this.supplier.get());
        }
        return this.value.orElse(null);
    }

    public <S> Lazy<S> map(Function<T, S> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return Lazy.of(() -> function.apply(this.get()));
    }

    public <S> Lazy<S> flatMap(Function<T, Lazy<S>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return Lazy.of(() -> ((Lazy)function.apply(this.get())).get());
    }

    @ConstructorProperties(value={"supplier"})
    public Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Lazy)) {
            return false;
        }
        Lazy other = (Lazy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<T> this$supplier = this.supplier;
        Supplier<T> other$supplier = other.supplier;
        if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
            return false;
        }
        Optional<T> this$value = this.value;
        Optional<T> other$value = other.value;
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Lazy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<T> $supplier = this.supplier;
        result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
        Optional<T> $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

