/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AnnotationDetectionFieldCallback
implements ReflectionUtils.FieldCallback {
    private final Class<? extends Annotation> annotationType;
    private Optional<Field> field = Optional.empty();

    public AnnotationDetectionFieldCallback(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, (String)"AnnotationType must not be null!");
        this.annotationType = annotationType;
    }

    public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
        if (this.field.isPresent()) {
            return;
        }
        if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, this.annotationType) != null) {
            ReflectionUtils.makeAccessible((Field)field);
            this.field = Optional.of(field);
        }
    }

    public Optional<Class<?>> getType() {
        return this.field.map(Field::getType);
    }

    public Class<?> getRequiredType() {
        return this.getType().orElseThrow(() -> new IllegalStateException(String.format("Unable to obtain type! Didn't find field with annotation %s!", this.annotationType)));
    }

    public <T> Optional<T> getValue(Object source) {
        Assert.notNull((Object)source, (String)"Source object must not be null!");
        return this.field.map(it -> ReflectionUtils.getField((Field)it, (Object)source));
    }
}

