/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.projection.DefaultMethodInvokingMethodInterceptor;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryInformation;
import org.springframework.data.repository.core.support.PropertiesBasedNamedQueries;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.QueryExecutionResultHandler;
import org.springframework.data.repository.core.support.ReactiveRepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.data.repository.core.support.SurroundingTransactionDetectorMethodInterceptor;
import org.springframework.data.repository.query.DefaultEvaluationContextProvider;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.util.ClassUtils;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.data.util.Pair;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.transaction.interceptor.TransactionalProxy;
import org.springframework.util.Assert;

public abstract class RepositoryFactorySupport
implements BeanClassLoaderAware,
BeanFactoryAware {
    private final Map<RepositoryInformationCacheKey, RepositoryInformation> repositoryInformationCache;
    private final List<RepositoryProxyPostProcessor> postProcessors;
    private Optional<Class<?>> repositoryBaseClass;
    private QueryLookupStrategy.Key queryLookupStrategyKey;
    private List<QueryCreationListener<?>> queryPostProcessors;
    private NamedQueries namedQueries;
    private ClassLoader classLoader;
    private EvaluationContextProvider evaluationContextProvider;
    private BeanFactory beanFactory;
    private QueryCollectingQueryCreationListener collectingListener = new QueryCollectingQueryCreationListener();

    public RepositoryFactorySupport() {
        this.repositoryInformationCache = new HashMap<RepositoryInformationCacheKey, RepositoryInformation>();
        this.postProcessors = new ArrayList<RepositoryProxyPostProcessor>();
        this.repositoryBaseClass = Optional.empty();
        this.namedQueries = PropertiesBasedNamedQueries.EMPTY;
        this.classLoader = org.springframework.util.ClassUtils.getDefaultClassLoader();
        this.evaluationContextProvider = DefaultEvaluationContextProvider.INSTANCE;
        this.queryPostProcessors = new ArrayList();
        this.queryPostProcessors.add(this.collectingListener);
    }

    public void setQueryLookupStrategyKey(QueryLookupStrategy.Key key) {
        this.queryLookupStrategyKey = key;
    }

    public void setNamedQueries(NamedQueries namedQueries) {
        this.namedQueries = namedQueries == null ? PropertiesBasedNamedQueries.EMPTY : namedQueries;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? org.springframework.util.ClassUtils.getDefaultClassLoader() : classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEvaluationContextProvider(EvaluationContextProvider evaluationContextProvider) {
        this.evaluationContextProvider = evaluationContextProvider == null ? DefaultEvaluationContextProvider.INSTANCE : evaluationContextProvider;
    }

    public void setRepositoryBaseClass(Class<?> repositoryBaseClass) {
        this.repositoryBaseClass = Optional.ofNullable(repositoryBaseClass);
    }

    public void addQueryCreationListener(QueryCreationListener<?> listener) {
        Assert.notNull(listener, (String)"Listener must not be null!");
        this.queryPostProcessors.add(listener);
    }

    public void addRepositoryProxyPostProcessor(RepositoryProxyPostProcessor processor) {
        Assert.notNull((Object)processor, (String)"RepositoryProxyPostProcessor must not be null!");
        this.postProcessors.add(processor);
    }

    public <T> T getRepository(Class<T> repositoryInterface) {
        return this.getRepository(repositoryInterface, Optional.empty());
    }

    public <T> T getRepository(Class<T> repositoryInterface, Object customImplementation) {
        return this.getRepository(repositoryInterface, Optional.of(customImplementation));
    }

    protected <T> T getRepository(Class<T> repositoryInterface, Optional<Object> customImplementation) {
        RepositoryMetadata metadata = this.getRepositoryMetadata(repositoryInterface);
        RepositoryInformation information = this.getRepositoryInformation(metadata, customImplementation.map(Object::getClass));
        this.validate(information, customImplementation);
        Object target = this.getTargetRepository(information);
        ProxyFactory result = new ProxyFactory();
        result.setTarget(target);
        result.setInterfaces(new Class[]{repositoryInterface, Repository.class, TransactionalProxy.class});
        result.addAdvice((Advice)SurroundingTransactionDetectorMethodInterceptor.INSTANCE);
        result.addAdvisor(ExposeInvocationInterceptor.ADVISOR);
        this.postProcessors.forEach(processor -> processor.postProcess(result, information));
        result.addAdvice((Advice)new DefaultMethodInvokingMethodInterceptor());
        result.addAdvice((Advice)new QueryExecutorMethodInterceptor(information));
        result.addAdvice((Advice)(information.isReactiveRepository() ? new ConvertingImplementationMethodExecutionInterceptor(information, customImplementation, target) : new ImplementationMethodExecutionInterceptor(information, customImplementation, target)));
        return (T)result.getProxy(this.classLoader);
    }

    protected RepositoryMetadata getRepositoryMetadata(Class<?> repositoryInterface) {
        return AbstractRepositoryMetadata.getMetadata(repositoryInterface);
    }

    protected RepositoryInformation getRepositoryInformation(RepositoryMetadata metadata, Optional<Class<?>> customImplementationClass) {
        RepositoryInformationCacheKey cacheKey = new RepositoryInformationCacheKey(metadata, customImplementationClass);
        return this.repositoryInformationCache.computeIfAbsent(cacheKey, key -> {
            Class<?> baseClass = this.repositoryBaseClass.orElse(this.getRepositoryBaseClass(metadata));
            return metadata.isReactiveRepository() ? new ReactiveRepositoryInformation(metadata, baseClass, customImplementationClass) : new DefaultRepositoryInformation(metadata, baseClass, customImplementationClass);
        });
    }

    protected List<QueryMethod> getQueryMethods() {
        return this.collectingListener.getQueryMethods();
    }

    public abstract <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> var1);

    protected abstract Object getTargetRepository(RepositoryInformation var1);

    protected abstract Class<?> getRepositoryBaseClass(RepositoryMetadata var1);

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return Optional.empty();
    }

    private void validate(RepositoryInformation repositoryInformation, Optional<Object> customImplementation) {
        customImplementation.orElseGet(() -> {
            if (!repositoryInformation.hasCustomMethod()) {
                return null;
            }
            throw new IllegalArgumentException(String.format("You have custom methods in %s but not provided a custom implementation!", repositoryInformation.getRepositoryInterface()));
        });
        this.validate(repositoryInformation);
    }

    protected void validate(RepositoryMetadata repositoryMetadata) {
    }

    protected final <R> R getTargetRepositoryViaReflection(RepositoryInformation information, Object ... constructorArguments) {
        Class<?> baseClass = information.getRepositoryBaseClass();
        Optional<Constructor<?>> constructor = ReflectionUtils.findConstructor(baseClass, constructorArguments);
        return (R)constructor.map(it -> BeanUtils.instantiateClass((Constructor)it, (Object[])constructorArguments)).orElseThrow(() -> new IllegalStateException(String.format("No suitable constructor found on %s to match the given arguments: %s. Make sure you implement a constructor taking these", baseClass, Arrays.stream(constructorArguments).map(Object::getClass).collect(Collectors.toList()))));
    }

    private static class RepositoryInformationCacheKey {
        private final String repositoryInterfaceName;
        private final String customImplementationClassName;

        public RepositoryInformationCacheKey(RepositoryMetadata metadata, Optional<Class<?>> customImplementationType) {
            this.repositoryInterfaceName = metadata.getRepositoryInterface().getName();
            this.customImplementationClassName = customImplementationType.map(Class::getName).orElse(null);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepositoryInformationCacheKey)) {
                return false;
            }
            RepositoryInformationCacheKey other = (RepositoryInformationCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$repositoryInterfaceName = this.repositoryInterfaceName;
            String other$repositoryInterfaceName = other.repositoryInterfaceName;
            if (this$repositoryInterfaceName == null ? other$repositoryInterfaceName != null : !this$repositoryInterfaceName.equals(other$repositoryInterfaceName)) {
                return false;
            }
            String this$customImplementationClassName = this.customImplementationClassName;
            String other$customImplementationClassName = other.customImplementationClassName;
            return !(this$customImplementationClassName == null ? other$customImplementationClassName != null : !this$customImplementationClassName.equals(other$customImplementationClassName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RepositoryInformationCacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $repositoryInterfaceName = this.repositoryInterfaceName;
            result = result * 59 + ($repositoryInterfaceName == null ? 43 : $repositoryInterfaceName.hashCode());
            String $customImplementationClassName = this.customImplementationClassName;
            result = result * 59 + ($customImplementationClassName == null ? 43 : $customImplementationClassName.hashCode());
            return result;
        }
    }

    private static class QueryCollectingQueryCreationListener
    implements QueryCreationListener<RepositoryQuery> {
        private List<QueryMethod> queryMethods = new ArrayList<QueryMethod>();

        private QueryCollectingQueryCreationListener() {
        }

        @Override
        public void onCreation(RepositoryQuery query) {
            this.queryMethods.add(query.getQueryMethod());
        }

        public List<QueryMethod> getQueryMethods() {
            return this.queryMethods;
        }
    }

    public class ConvertingImplementationMethodExecutionInterceptor
    extends ImplementationMethodExecutionInterceptor {
        public ConvertingImplementationMethodExecutionInterceptor(RepositoryInformation repositoryInformation, Optional<Object> customImplementation, Object target) {
            super(repositoryInformation, customImplementation, target);
        }

        @Override
        protected Object executeMethodOn(Object target, Method method, Object[] parameters) throws Throwable {
            return super.executeMethodOn(target, method, this.convertParameters(method.getParameterTypes(), parameters));
        }

        private Object[] convertParameters(Class<?>[] parameterTypes, Object[] parameters) {
            if (parameters.length == 0) {
                return parameters;
            }
            Object[] result = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] == null) continue;
                result[i] = !parameterTypes[i].isAssignableFrom(parameters[i].getClass()) && ReactiveWrappers.isAvailable() && ReactiveWrapperConverters.canConvert(parameters[i].getClass(), parameterTypes[i]) ? ReactiveWrapperConverters.toWrapper(parameters[i], parameterTypes[i]) : parameters[i];
            }
            return result;
        }
    }

    public class ImplementationMethodExecutionInterceptor
    implements MethodInterceptor {
        private final RepositoryInformation repositoryInformation;
        private final Optional<Object> customImplementation;
        private final Object target;

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object[] arguments = invocation.getArguments();
            if (this.isCustomMethodInvocation(invocation)) {
                Method actualMethod = this.repositoryInformation.getTargetClassMethod(method);
                return this.executeMethodOn(this.customImplementation.get(), actualMethod, arguments);
            }
            Method actualMethod = this.repositoryInformation.getTargetClassMethod(method);
            return this.executeMethodOn(this.target, actualMethod, arguments);
        }

        protected Object executeMethodOn(Object target, Method method, Object[] parameters) throws Throwable {
            try {
                return method.invoke(target, parameters);
            }
            catch (Exception e) {
                ClassUtils.unwrapReflectionException(e);
                throw new IllegalStateException("Should not occur!");
            }
        }

        private boolean isCustomMethodInvocation(MethodInvocation invocation) {
            return this.customImplementation.map(it -> this.repositoryInformation.isCustomMethod(invocation.getMethod())).orElse(false);
        }

        @ConstructorProperties(value={"repositoryInformation", "customImplementation", "target"})
        public ImplementationMethodExecutionInterceptor(RepositoryInformation repositoryInformation, Optional<Object> customImplementation, Object target) {
            this.repositoryInformation = repositoryInformation;
            this.customImplementation = customImplementation;
            this.target = target;
        }
    }

    public class QueryExecutorMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, RepositoryQuery> queries;
        private final QueryExecutionResultHandler resultHandler = new QueryExecutionResultHandler();

        public QueryExecutorMethodInterceptor(RepositoryInformation repositoryInformation) {
            Optional<QueryLookupStrategy> lookupStrategy = RepositoryFactorySupport.this.getQueryLookupStrategy(RepositoryFactorySupport.this.queryLookupStrategyKey, RepositoryFactorySupport.this.evaluationContextProvider);
            if (!lookupStrategy.isPresent() && repositoryInformation.hasQueryMethods()) {
                throw new IllegalStateException("You have defined query method in the repository but you don't have any query lookup strategy defined. The infrastructure apparently does not support query methods!");
            }
            this.queries = lookupStrategy.map(it -> {
                SpelAwareProxyProjectionFactory factory = new SpelAwareProxyProjectionFactory();
                factory.setBeanClassLoader(RepositoryFactorySupport.this.classLoader);
                factory.setBeanFactory(RepositoryFactorySupport.this.beanFactory);
                return repositoryInformation.getQueryMethods().stream().map(method -> Pair.of(method, it.resolveQuery((Method)method, repositoryInformation, factory, RepositoryFactorySupport.this.namedQueries))).peek(pair -> this.invokeListeners((RepositoryQuery)pair.getSecond())).collect(Pair.toMap());
            }).orElse(Collections.emptyMap());
        }

        private void invokeListeners(RepositoryQuery query) {
            for (QueryCreationListener listener : RepositoryFactorySupport.this.queryPostProcessors) {
                ResolvableType typeArgument = ResolvableType.forClass(QueryCreationListener.class, listener.getClass()).getGeneric(new int[]{0});
                if (typeArgument == null || !typeArgument.isAssignableFrom(ResolvableType.forClass(query.getClass()))) continue;
                listener.onCreation(query);
            }
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object result = this.doInvoke(invocation);
            Method method = invocation.getMethod();
            MethodParameter parameter = new MethodParameter(method, -1);
            TypeDescriptor methodReturnTypeDescriptor = TypeDescriptor.nested((MethodParameter)parameter, (int)0);
            return this.resultHandler.postProcessInvocationResult(result, methodReturnTypeDescriptor);
        }

        private Object doInvoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object[] arguments = invocation.getArguments();
            if (this.hasQueryFor(method)) {
                return this.queries.get(method).execute(arguments);
            }
            return invocation.proceed();
        }

        private boolean hasQueryFor(Method method) {
            return this.queries.containsKey(method);
        }
    }
}

