/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryInformation;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReactiveRepositoryInformation
extends DefaultRepositoryInformation {
    public ReactiveRepositoryInformation(RepositoryMetadata metadata, Class<?> repositoryBaseClass, Optional<Class<?>> customImplementationClass) {
        super(metadata, repositoryBaseClass, customImplementationClass);
    }

    @Override
    Method getTargetClassMethod(Method method, Optional<Class<?>> baseClass) {
        Supplier<Optional> directMatch = () -> baseClass.map(it -> ReflectionUtils.findMethod((Class)it, (String)method.getName(), (Class[])method.getParameterTypes()));
        Supplier<Optional> detailedComparison = () -> baseClass.flatMap(it -> {
            ArrayList<Supplier<Optional>> suppliers = new ArrayList<Supplier<Optional>>();
            if (ReactiveRepositoryInformation.usesParametersWithReactiveWrappers(method)) {
                suppliers.add(() -> ReactiveRepositoryInformation.getMethodCandidate(method, it, ReactiveRepositoryInformation.assignableWrapperMatch()));
                suppliers.add(() -> ReactiveRepositoryInformation.getMethodCandidate(method, it, ReactiveRepositoryInformation.wrapperConversionMatch()));
            }
            suppliers.add(() -> ReactiveRepositoryInformation.getMethodCandidate(method, it, this.matchParameterOrComponentType(this.getRepositoryInterface())));
            return Optionals.firstNonEmpty(Streamable.of(suppliers));
        });
        return Optionals.firstNonEmpty(directMatch, detailedComparison).orElse(method);
    }

    private Predicate<ParameterOverrideCriteria> matchParameterOrComponentType(Class<?> repositoryInterface) {
        return parameterCriteria -> {
            Class parameterType = GenericTypeResolver.resolveParameterType((MethodParameter)parameterCriteria.getDeclared(), (Class)repositoryInterface);
            Type genericType = parameterCriteria.getGenericBaseType();
            if (genericType instanceof TypeVariable && !this.matchesGenericType((TypeVariable)genericType, ResolvableType.forMethodParameter((MethodParameter)parameterCriteria.getDeclared()))) {
                return false;
            }
            return parameterCriteria.getBaseType().isAssignableFrom(parameterType) && parameterCriteria.isAssignableFromDeclared();
        };
    }

    private static boolean isNonUnwrappingWrapper(Class<?> parameterType) {
        Assert.notNull(parameterType, (String)"Parameter type must not be null!");
        return QueryExecutionConverters.supports(parameterType) && !QueryExecutionConverters.supportsUnwrapping(parameterType);
    }

    private static boolean usesParametersWithReactiveWrappers(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return Arrays.stream(method.getParameterTypes()).anyMatch(ReactiveRepositoryInformation::isNonUnwrappingWrapper);
    }

    private static Optional<Method> getMethodCandidate(Method method, Class<?> baseClass, Predicate<ParameterOverrideCriteria> predicate) {
        return Arrays.stream(baseClass.getMethods()).filter(it -> method.getName().equals(it.getName())).filter(it -> method.getParameterCount() == it.getParameterCount()).filter(it -> ReactiveRepositoryInformation.parametersMatch(it, method, predicate)).findFirst();
    }

    private static boolean parametersMatch(Method baseClassMethod, Method declaredMethod, Predicate<ParameterOverrideCriteria> predicate) {
        return ReactiveRepositoryInformation.methodParameters(baseClassMethod, declaredMethod).allMatch(predicate);
    }

    private static Predicate<ParameterOverrideCriteria> wrapperConversionMatch() {
        return parameterCriteria -> ReactiveRepositoryInformation.isNonUnwrappingWrapper(parameterCriteria.getBaseType()) && ReactiveRepositoryInformation.isNonUnwrappingWrapper(parameterCriteria.getDeclaredType()) && ReactiveWrapperConverters.canConvert(parameterCriteria.getDeclaredType(), parameterCriteria.getBaseType());
    }

    private static Predicate<ParameterOverrideCriteria> assignableWrapperMatch() {
        return parameterCriteria -> ReactiveRepositoryInformation.isNonUnwrappingWrapper(parameterCriteria.getBaseType()) && ReactiveRepositoryInformation.isNonUnwrappingWrapper(parameterCriteria.getDeclaredType()) && parameterCriteria.getBaseType().isAssignableFrom(parameterCriteria.getDeclaredType());
    }

    private static Stream<ParameterOverrideCriteria> methodParameters(Method first, Method second) {
        Assert.isTrue((first.getParameterCount() == second.getParameterCount() ? 1 : 0) != 0, (String)"Method parameter count must be equal!");
        return IntStream.range(0, first.getParameterCount()).mapToObj(index -> ParameterOverrideCriteria.of(new MethodParameter(first, index), new MethodParameter(second, index)));
    }

    private static final class ParameterOverrideCriteria {
        private final MethodParameter base;
        private final MethodParameter declared;

        public Class<?> getBaseType() {
            return this.base.getParameterType();
        }

        public Type getGenericBaseType() {
            return this.base.getGenericParameterType();
        }

        public Class<?> getDeclaredType() {
            return this.declared.getParameterType();
        }

        public boolean isAssignableFromDeclared() {
            return this.getBaseType().isAssignableFrom(this.getDeclaredType());
        }

        @ConstructorProperties(value={"base", "declared"})
        private ParameterOverrideCriteria(MethodParameter base, MethodParameter declared) {
            this.base = base;
            this.declared = declared;
        }

        public static ParameterOverrideCriteria of(MethodParameter base, MethodParameter declared) {
            return new ParameterOverrideCriteria(base, declared);
        }

        public MethodParameter getBase() {
            return this.base;
        }

        public MethodParameter getDeclared() {
            return this.declared;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterOverrideCriteria)) {
                return false;
            }
            ParameterOverrideCriteria other = (ParameterOverrideCriteria)o;
            MethodParameter this$base = this.getBase();
            MethodParameter other$base = other.getBase();
            if (this$base == null ? other$base != null : !this$base.equals(other$base)) {
                return false;
            }
            MethodParameter this$declared = this.getDeclared();
            MethodParameter other$declared = other.getDeclared();
            return !(this$declared == null ? other$declared != null : !this$declared.equals(other$declared));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MethodParameter $base = this.getBase();
            result = result * 59 + ($base == null ? 43 : $base.hashCode());
            MethodParameter $declared = this.getDeclared();
            result = result * 59 + ($declared == null ? 43 : $declared.hashCode());
            return result;
        }

        public String toString() {
            return "ReactiveRepositoryInformation.ParameterOverrideCriteria(base=" + this.getBase() + ", declared=" + this.getDeclared() + ")";
        }
    }
}

