/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.util.Map;
import java.util.Optional;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.repository.util.NullableWrapper;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;

class QueryExecutionResultHandler {
    private static final TypeDescriptor WRAPPER_TYPE = TypeDescriptor.valueOf(NullableWrapper.class);
    private final GenericConversionService conversionService;

    public QueryExecutionResultHandler() {
        DefaultConversionService conversionService = new DefaultConversionService();
        QueryExecutionConverters.registerConvertersIn((ConfigurableConversionService)conversionService);
        this.conversionService = conversionService;
    }

    public Object postProcessInvocationResult(Object result, TypeDescriptor returnTypeDescriptor) {
        if (returnTypeDescriptor == null) {
            return result;
        }
        Class expectedReturnType = returnTypeDescriptor.getType();
        if (result != null && expectedReturnType.isInstance(result)) {
            return result;
        }
        result = QueryExecutionResultHandler.unwrapOptional(result);
        if (QueryExecutionConverters.supports(expectedReturnType)) {
            TypeDescriptor targetType = TypeDescriptor.valueOf((Class)expectedReturnType);
            if (this.conversionService.canConvert(WRAPPER_TYPE, returnTypeDescriptor) && !this.conversionService.canBypassConvert(WRAPPER_TYPE, targetType)) {
                return this.conversionService.convert((Object)new NullableWrapper(result), expectedReturnType);
            }
            if (result != null && this.conversionService.canConvert(TypeDescriptor.valueOf(result.getClass()), returnTypeDescriptor) && !this.conversionService.canBypassConvert(TypeDescriptor.valueOf(result.getClass()), targetType)) {
                return this.conversionService.convert(result, expectedReturnType);
            }
        }
        if (result != null) {
            if (ReactiveWrapperConverters.supports(expectedReturnType)) {
                return ReactiveWrapperConverters.toWrapper(result, expectedReturnType);
            }
            return this.conversionService.canConvert(result.getClass(), expectedReturnType) ? this.conversionService.convert(result, expectedReturnType) : result;
        }
        if (Map.class.equals((Object)expectedReturnType)) {
            return CollectionFactory.createMap((Class)expectedReturnType, (int)0);
        }
        return null;
    }

    private static Object unwrapOptional(Object source) {
        if (source == null) {
            return null;
        }
        return Optional.class.isInstance(source) ? ((Optional)Optional.class.cast(source)).orElse(null) : source;
    }
}

