/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.data.repository.core.EntityInformation;

public class DelegatingEntityInformation<T, ID>
implements EntityInformation<T, ID> {
    @NonNull
    private final EntityInformation<T, ID> delegate;

    @Override
    public Class<T> getJavaType() {
        return this.delegate.getJavaType();
    }

    @Override
    public boolean isNew(T entity) {
        return this.delegate.isNew(entity);
    }

    @Override
    public Optional<ID> getId(T entity) {
        return this.delegate.getId(entity);
    }

    @Override
    public Class<ID> getIdType() {
        return this.delegate.getIdType();
    }

    @ConstructorProperties(value={"delegate"})
    public DelegatingEntityInformation(@NonNull EntityInformation<T, ID> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is null");
        }
        this.delegate = delegate;
    }
}

