/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.data.repository.core.EntityInformation;

public abstract class AbstractEntityInformation<T, ID>
implements EntityInformation<T, ID> {
    @NonNull
    private final Class<T> domainClass;

    @Override
    public boolean isNew(T entity) {
        Optional id = this.getId(entity);
        Class idType = this.getIdType();
        if (!idType.isPrimitive()) {
            return !id.isPresent();
        }
        return id.map(it -> {
            if (it instanceof Number) {
                return ((Number)it).longValue() == 0L;
            }
            return null;
        }).orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported primitive id type %s!", idType)));
    }

    @Override
    public Class<T> getJavaType() {
        return this.domainClass;
    }

    @ConstructorProperties(value={"domainClass"})
    public AbstractEntityInformation(@NonNull Class<T> domainClass) {
        if (domainClass == null) {
            throw new IllegalArgumentException("domainClass is null");
        }
        this.domainClass = domainClass;
    }
}

