/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.annotation.TypeAlias;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.TargetAwareIdentifierAccessor;
import org.springframework.data.mapping.model.BeanWrapperPropertyAccessorFactory;
import org.springframework.data.mapping.model.IdPropertyIdentifierAccessor;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.PersistentPropertyAccessorFactory;
import org.springframework.data.mapping.model.PreferredConstructorDiscoverer;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicPersistentEntity<T, P extends PersistentProperty<P>>
implements MutablePersistentEntity<T, P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicPersistentEntity.class);
    private static final String TYPE_MISMATCH = "Target bean of type %s is not of type of the persistent entity (%s)!";
    private static final String NULL_ASSOCIATION = "%s.addAssociation(\u2026) was called with a null association! Usually indicates a problem in a Spring Data MappingContext implementation. Be sure to file a bug at https://jira.spring.io!";
    private final Optional<PreferredConstructor<T, P>> constructor;
    private final TypeInformation<T> information;
    private final List<P> properties;
    private final Optional<Comparator<P>> comparator;
    private final Set<Association<P>> associations;
    private final Map<String, P> propertyCache;
    private final Map<Class<? extends Annotation>, Optional<Annotation>> annotationCache;
    private Optional<P> idProperty = Optional.empty();
    private Optional<P> versionProperty = Optional.empty();
    private PersistentPropertyAccessorFactory propertyAccessorFactory;
    private final Lazy<Alias> typeAlias;

    public BasicPersistentEntity(TypeInformation<T> information) {
        this(information, Optional.empty());
    }

    public BasicPersistentEntity(TypeInformation<T> information, Optional<Comparator<P>> comparator) {
        Assert.notNull(information, (String)"Information must not be null!");
        this.information = information;
        this.properties = new ArrayList<P>();
        this.comparator = comparator;
        this.constructor = new PreferredConstructorDiscoverer(this).getConstructor();
        this.associations = comparator.map(it -> new TreeSet(new AssociationComparator(it))).orElseGet(HashSet::new);
        this.propertyCache = new HashMap<String, P>();
        this.annotationCache = new HashMap<Class<? extends Annotation>, Optional<Annotation>>();
        this.propertyAccessorFactory = BeanWrapperPropertyAccessorFactory.INSTANCE;
        this.typeAlias = Lazy.of(() -> Alias.ofOptional(Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation(this.getType(), TypeAlias.class)).map(TypeAlias::value).filter(StringUtils::hasText)));
    }

    @Override
    public Optional<PreferredConstructor<T, P>> getPersistenceConstructor() {
        return this.constructor;
    }

    @Override
    public boolean isConstructorArgument(PersistentProperty<?> property) {
        return this.constructor.map(it -> it.isConstructorParameter(property)).orElse(false);
    }

    @Override
    public boolean isIdProperty(PersistentProperty<?> property) {
        return this.idProperty.map(it -> it.equals(property)).orElse(false);
    }

    @Override
    public boolean isVersionProperty(PersistentProperty<?> property) {
        return this.versionProperty.map(it -> it.equals(property)).orElse(false);
    }

    @Override
    public String getName() {
        return this.getType().getName();
    }

    @Override
    public Optional<P> getIdProperty() {
        return this.idProperty;
    }

    @Override
    public Optional<P> getVersionProperty() {
        return this.versionProperty;
    }

    @Override
    public boolean hasIdProperty() {
        return this.idProperty.isPresent();
    }

    @Override
    public boolean hasVersionProperty() {
        return this.versionProperty.isPresent();
    }

    @Override
    public void addPersistentProperty(P property) {
        P candidate;
        Assert.notNull(property, (String)"Property must not be null!");
        if (this.properties.contains(property)) {
            return;
        }
        this.properties.add(property);
        if (!this.propertyCache.containsKey(property.getName())) {
            this.propertyCache.put(property.getName(), property);
        }
        if ((candidate = this.returnPropertyIfBetterIdPropertyCandidateOrNull(property)) != null) {
            this.idProperty = Optional.of(candidate);
        }
        if (property.isVersionProperty()) {
            this.versionProperty.ifPresent(it -> {
                throw new MappingException(String.format("Attempt to add version property %s but already have property %s registered as version. Check your mapping configuration!", property.getField(), it.getField()));
            });
            this.versionProperty = Optional.of(property);
        }
    }

    protected P returnPropertyIfBetterIdPropertyCandidateOrNull(P property) {
        if (!property.isIdProperty()) {
            return null;
        }
        this.idProperty.ifPresent(it -> {
            throw new MappingException(String.format("Attempt to add id property %s but already have property %s registered as id. Check your mapping configuration!", property.getField(), it.getField()));
        });
        return property;
    }

    @Override
    public void addAssociation(Association<P> association) {
        Assert.notNull(association, (String)"Association must not be null!");
        if (!this.associations.contains(association)) {
            this.associations.add(association);
        }
    }

    @Override
    public Optional<P> getPersistentProperty(String name) {
        return Optional.ofNullable(this.propertyCache.get(name));
    }

    @Override
    public Optional<P> getPersistentProperty(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null!");
        Optional<PersistentProperty> property = this.properties.stream().filter(it -> it.isAnnotationPresent(annotationType)).findAny();
        if (property.isPresent()) {
            return property;
        }
        return this.associations.stream().map(Association::getInverse).filter(it -> it.isAnnotationPresent(annotationType)).findAny();
    }

    @Override
    public Class<T> getType() {
        return this.information.getType();
    }

    @Override
    public Alias getTypeAlias() {
        return this.typeAlias.get();
    }

    @Override
    public TypeInformation<T> getTypeInformation() {
        return this.information;
    }

    @Override
    public void doWithProperties(PropertyHandler<P> handler) {
        Assert.notNull(handler, (String)"PropertyHandler must not be null!");
        this.getPersistentProperties().forEach(handler::doWithPersistentProperty);
    }

    @Override
    public void doWithProperties(SimplePropertyHandler handler) {
        Assert.notNull((Object)handler, (String)"Handler must not be null!");
        this.getPersistentProperties().forEach(handler::doWithPersistentProperty);
    }

    @Override
    public Stream<P> getPersistentProperties() {
        return this.properties.stream().filter(it -> !it.isTransient() && !it.isAssociation());
    }

    @Override
    public void doWithAssociations(AssociationHandler<P> handler) {
        Assert.notNull(handler, (String)"Handler must not be null!");
        for (Association<P> association : this.associations) {
            handler.doWithAssociation(association);
        }
    }

    @Override
    public void doWithAssociations(SimpleAssociationHandler handler) {
        Assert.notNull((Object)handler, (String)"Handler must not be null!");
        for (Association<P> association : this.associations) {
            handler.doWithAssociation(association);
        }
    }

    @Override
    public Stream<Association<P>> getAssociations() {
        return this.associations.stream();
    }

    @Override
    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        return this.annotationCache.computeIfAbsent(annotationType, it -> Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation(this.getType(), (Class)it)));
    }

    @Override
    public void verify() {
        this.comparator.ifPresent(it -> this.properties.sort((Comparator<P>)it));
    }

    @Override
    public void setPersistentPropertyAccessorFactory(PersistentPropertyAccessorFactory factory) {
        this.propertyAccessorFactory = factory;
    }

    @Override
    public PersistentPropertyAccessor getPropertyAccessor(Object bean) {
        Assert.notNull((Object)bean, (String)"Target bean must not be null!");
        Assert.isTrue((boolean)this.getType().isInstance(bean), () -> String.format(TYPE_MISMATCH, bean.getClass().getName(), this.getType().getName()));
        return this.propertyAccessorFactory.getPropertyAccessor(this, bean);
    }

    @Override
    public IdentifierAccessor getIdentifierAccessor(Object bean) {
        Assert.notNull((Object)bean, (String)"Target bean must not be null!");
        Assert.isTrue((boolean)this.getType().isInstance(bean), () -> String.format(TYPE_MISMATCH, bean.getClass().getName(), this.getType().getName()));
        return this.hasIdProperty() ? new IdPropertyIdentifierAccessor(this, bean) : new AbsentIdentifierAccessor(bean);
    }

    private static final class AssociationComparator<P extends PersistentProperty<P>>
    implements Comparator<Association<P>>,
    Serializable {
        private static final long serialVersionUID = 4508054194886854513L;
        @NonNull
        private final Comparator<P> delegate;

        @Override
        public int compare(Association<P> left, Association<P> right) {
            return this.delegate.compare(left.getInverse(), right.getInverse());
        }

        @ConstructorProperties(value={"delegate"})
        public AssociationComparator(@NonNull Comparator<P> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("delegate is null");
            }
            this.delegate = delegate;
        }
    }

    private static class AbsentIdentifierAccessor
    extends TargetAwareIdentifierAccessor {
        public AbsentIdentifierAccessor(Object target) {
            super(() -> target);
        }

        @Override
        public Optional<Object> getIdentifier() {
            return Optional.empty();
        }
    }
}

