/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.support.IsNewStrategyFactorySupport;
import org.springframework.util.Assert;

public class MappingContextIsNewStrategyFactory
extends IsNewStrategyFactorySupport {
    private final PersistentEntities context;

    @Deprecated
    public MappingContextIsNewStrategyFactory(MappingContext<? extends PersistentEntity<?, ?>, ?> context) {
        this(new PersistentEntities(Collections.singletonList(context)));
    }

    public MappingContextIsNewStrategyFactory(PersistentEntities entities) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        this.context = entities;
    }

    @Override
    protected IsNewStrategy doGetIsNewStrategy(Class<?> type) {
        return (IsNewStrategy)this.context.getPersistentEntity(type).flatMap(MappingContextIsNewStrategyFactory::foo).orElseThrow(() -> new MappingException(String.format("Cannot determine IsNewStrategy for type %s!", type)));
    }

    private static Optional<IsNewStrategy> foo(PersistentEntity<?, ?> entity) {
        if (entity.hasVersionProperty()) {
            return entity.getVersionProperty().map(it -> PersistentPropertyInspectingIsNewStrategy.of(it, MappingContextIsNewStrategyFactory::propertyIsNullOrZeroNumber));
        }
        if (entity.hasIdProperty()) {
            return entity.getIdProperty().map(it -> PersistentPropertyInspectingIsNewStrategy.of(it, MappingContextIsNewStrategyFactory::propertyIsNull));
        }
        return Optional.empty();
    }

    private static boolean propertyIsNull(Optional<Object> it) {
        return !it.isPresent();
    }

    private static boolean propertyIsNullOrZeroNumber(Optional<Object> it) {
        return it.map(value -> {
            if (!(value instanceof Number)) {
                return false;
            }
            return ((Number)value).longValue() == 0L;
        }).orElse(true);
    }

    static class PersistentPropertyInspectingIsNewStrategy
    implements IsNewStrategy {
        @NonNull
        private final PersistentProperty<?> property;
        @NonNull
        private final Function<Optional<Object>, Boolean> isNew;

        @Override
        public boolean isNew(Object entity) {
            Assert.notNull((Object)entity, (String)"Entity must not be null!");
            return this.isNew.apply(this.property.getOwner().getPropertyAccessor(entity).getProperty(this.property));
        }

        @ConstructorProperties(value={"property", "isNew"})
        private PersistentPropertyInspectingIsNewStrategy(@NonNull PersistentProperty<?> property, @NonNull Function<Optional<Object>, Boolean> isNew) {
            if (property == null) {
                throw new IllegalArgumentException("property is null");
            }
            if (isNew == null) {
                throw new IllegalArgumentException("isNew is null");
            }
            this.property = property;
            this.isNew = isNew;
        }

        public static PersistentPropertyInspectingIsNewStrategy of(@NonNull PersistentProperty<?> property, @NonNull Function<Optional<Object>, Boolean> isNew) {
            return new PersistentPropertyInspectingIsNewStrategy(property, isNew);
        }
    }
}

