/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Completable;
import rx.Observable;

public final class ReactiveWrappers {
    private static final boolean PROJECT_REACTOR_PRESENT = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", (ClassLoader)ReactiveWrappers.class.getClassLoader());
    private static final boolean RXJAVA1_PRESENT = ClassUtils.isPresent((String)"rx.Completable", (ClassLoader)ReactiveWrappers.class.getClassLoader());
    private static final boolean RXJAVA2_PRESENT = ClassUtils.isPresent((String)"io.reactivex.Flowable", (ClassLoader)ReactiveWrappers.class.getClassLoader());
    private static final Map<Class<?>, Descriptor> REACTIVE_WRAPPERS;

    public static boolean isAvailable() {
        return Arrays.stream(ReactiveLibrary.values()).anyMatch(ReactiveWrappers::isAvailable);
    }

    public static boolean isAvailable(ReactiveLibrary reactiveLibrary) {
        Assert.notNull((Object)((Object)reactiveLibrary), (String)"Reactive library must not be null!");
        switch (reactiveLibrary) {
            case PROJECT_REACTOR: {
                return PROJECT_REACTOR_PRESENT;
            }
            case RXJAVA1: {
                return RXJAVA1_PRESENT;
            }
            case RXJAVA2: {
                return RXJAVA2_PRESENT;
            }
        }
        throw new IllegalArgumentException(String.format("Reactive library %s not supported", new Object[]{reactiveLibrary}));
    }

    public static boolean supports(Class<?> type) {
        return ReactiveWrappers.isWrapper(ClassUtils.getUserClass(type));
    }

    public static boolean usesReactiveType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return Arrays.stream(type.getMethods()).flatMap(ReflectionUtils::returnTypeAndParameters).anyMatch(ReactiveWrappers::supports);
    }

    public static boolean isNoValueType(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.findDescriptor(type).map(Descriptor::isNoValue).orElse(false);
    }

    public static boolean isSingleValueType(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.findDescriptor(type).map(it -> !it.isMultiValue() && !it.isNoValue()).orElse(false);
    }

    public static boolean isMultiValueType(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.isSingleValueType(type) ? false : ReactiveWrappers.findDescriptor(type).map(Descriptor::isMultiValue).orElse(false);
    }

    public static Collection<Class<?>> getNoValueTypes() {
        return REACTIVE_WRAPPERS.entrySet().stream().filter(entry -> ((Descriptor)entry.getValue()).isNoValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static Collection<Class<?>> getSingleValueTypes() {
        return REACTIVE_WRAPPERS.entrySet().stream().filter(entry -> !((Descriptor)entry.getValue()).isMultiValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static Collection<Class<?>> getMultiValueTypes() {
        return REACTIVE_WRAPPERS.entrySet().stream().filter(entry -> ((Descriptor)entry.getValue()).isMultiValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static boolean isWrapper(Class<?> type) {
        Assert.notNull(type, (String)"Candidate type must not be null!");
        return ReactiveWrappers.isNoValueType(type) || ReactiveWrappers.isSingleValueType(type) || ReactiveWrappers.isMultiValueType(type);
    }

    private static Optional<Descriptor> findDescriptor(Class<?> type) {
        Assert.notNull(type, (String)"Wrapper type must not be null!");
        return REACTIVE_WRAPPERS.entrySet().stream().filter(it -> ClassUtils.isAssignable((Class)((Class)it.getKey()), (Class)type)).findFirst().map(it -> (Descriptor)it.getValue());
    }

    private ReactiveWrappers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        LinkedHashMap<Class<Publisher>, Descriptor> reactiveWrappers = new LinkedHashMap<Class<Publisher>, Descriptor>(5);
        if (RXJAVA1_PRESENT) {
            reactiveWrappers.put(rx.Single.class, Descriptor.forSingleValue().forValue());
            reactiveWrappers.put(Completable.class, Descriptor.forSingleValue().forNoValue());
            reactiveWrappers.put(Observable.class, Descriptor.forMultiValue().forValue());
        }
        if (RXJAVA2_PRESENT) {
            reactiveWrappers.put(Single.class, Descriptor.forSingleValue().forValue());
            reactiveWrappers.put(Maybe.class, Descriptor.forSingleValue().forValue());
            reactiveWrappers.put(io.reactivex.Completable.class, Descriptor.forSingleValue().forNoValue());
            reactiveWrappers.put(Flowable.class, Descriptor.forMultiValue().forValue());
            reactiveWrappers.put(io.reactivex.Observable.class, Descriptor.forMultiValue().forValue());
        }
        if (PROJECT_REACTOR_PRESENT) {
            reactiveWrappers.put(Mono.class, Descriptor.forSingleValue().forValue());
            reactiveWrappers.put(Flux.class, Descriptor.forMultiValue().forNoValue());
            reactiveWrappers.put(Publisher.class, Descriptor.forMultiValue().forNoValue());
        }
        REACTIVE_WRAPPERS = Collections.unmodifiableMap(reactiveWrappers);
    }

    private static final class Descriptor {
        private final boolean multiValue;
        private final boolean noValue;

        public static DescriptorBuilder forSingleValue() {
            return new DescriptorBuilder(false);
        }

        public static DescriptorBuilder forMultiValue() {
            return new DescriptorBuilder(true);
        }

        public boolean isMultiValue() {
            return this.multiValue;
        }

        public boolean isNoValue() {
            return this.noValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Descriptor)) {
                return false;
            }
            Descriptor other = (Descriptor)o;
            if (this.isMultiValue() != other.isMultiValue()) {
                return false;
            }
            return this.isNoValue() == other.isNoValue();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMultiValue() ? 79 : 97);
            result = result * 59 + (this.isNoValue() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ReactiveWrappers.Descriptor(multiValue=" + this.isMultiValue() + ", noValue=" + this.isNoValue() + ")";
        }

        private Descriptor(boolean multiValue, boolean noValue) {
            this.multiValue = multiValue;
            this.noValue = noValue;
        }

        static class DescriptorBuilder {
            private final boolean multi;

            public Descriptor forValue() {
                return new Descriptor(this.multi, false);
            }

            public Descriptor forNoValue() {
                return new Descriptor(this.multi, true);
            }

            @ConstructorProperties(value={"multi"})
            public DescriptorBuilder(boolean multi) {
                this.multi = multi;
            }
        }
    }

    static enum ReactiveLibrary {
        PROJECT_REACTOR,
        RXJAVA1,
        RXJAVA2;

    }
}

