/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.repository.query.AbstractCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.util.ClassUtils;

public class StringBasedCassandraQuery
extends AbstractCassandraQuery {
    private static final Set<Class<?>> STRING_LIKE_PARAMETER_TYPES = new HashSet<Class>(Arrays.asList(CharSequence.class, Character.TYPE, Character.class, char[].class));
    private static final Pattern PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    protected final String query;

    public StringBasedCassandraQuery(String query, CassandraQueryMethod queryMethod, CassandraOperations operations) {
        super(queryMethod, operations);
        this.query = query;
    }

    public StringBasedCassandraQuery(CassandraQueryMethod queryMethod, CassandraOperations operations) {
        this(queryMethod.getAnnotatedQuery(), queryMethod, operations);
    }

    @Override
    public String createQuery(CassandraParameterAccessor accessor) {
        return this.replacePlaceholders(this.query, accessor);
    }

    private String replacePlaceholders(String input, CassandraParameterAccessor accessor) {
        Matcher matcher = PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String group = matcher.group();
            int index = Integer.parseInt(matcher.group(1));
            Object value = this.getParameterWithIndex(accessor, index);
            String stringValue = this.isStringLike(value) ? String.format("'%s'", CqlStringUtils.escapeSingle((Object)value)) : (this.isTimestampParameter(value) ? String.format("%d", ((Date)value).getTime()) : (this.isDateParameter(value) ? String.format("'%s'", value) : value.toString()));
            result = result.replace(group, stringValue);
        }
        return result;
    }

    private boolean isTimestampParameter(Object value) {
        return value instanceof Date;
    }

    private boolean isDateParameter(Object value) {
        return value instanceof LocalDate;
    }

    private boolean isStringLike(Object value) {
        if (value != null) {
            for (Class<?> type : STRING_LIKE_PARAMETER_TYPES) {
                if (!ClassUtils.isAssignableValue(type, (Object)value)) continue;
                return true;
            }
        }
        return false;
    }

    private Object getParameterWithIndex(CassandraParameterAccessor accessor, int index) {
        return accessor.getBindableValue(index);
    }
}

