/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.querybuilder.Select;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.repository.query.AbstractCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryCreator;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeCassandraQuery
extends AbstractCassandraQuery {
    private final CassandraMappingContext mappingContext;
    private final PartTree tree;

    public PartTreeCassandraQuery(CassandraQueryMethod queryMethod, CassandraOperations operations) {
        super(queryMethod, operations);
        this.tree = new PartTree(queryMethod.getName(), queryMethod.getEntityInformation().getJavaType());
        this.mappingContext = operations.getConverter().getMappingContext();
    }

    public PartTree getTree() {
        return this.tree;
    }

    @Override
    protected String createQuery(CassandraParameterAccessor parameterAccessor) {
        CassandraQueryCreator queryCreator = new CassandraQueryCreator(this.tree, parameterAccessor, this.mappingContext, this.getQueryMethod().getEntityInformation());
        return ((Select)queryCreator.createQuery()).toString();
    }
}

