/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.ResultSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.query.CassandraEntityMetadata;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.SimpleCassandraEntityMetadata;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CassandraQueryMethod
extends QueryMethod {
    private CassandraEntityMetadata<?> entityMetadata;
    private final CassandraMappingContext mappingContext;
    private final Method method;

    public CassandraQueryMethod(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, CassandraMappingContext mappingContext) {
        super(method, repositoryMetadata, projectionFactory);
        Assert.notNull((Object)mappingContext, (String)"MappingContext must not be null");
        this.verify(method, repositoryMetadata);
        this.method = method;
        this.mappingContext = mappingContext;
    }

    public void verify(Method method, RepositoryMetadata metadata) {
        if (this.isSliceQuery() || this.isPageQuery()) {
            throw new InvalidDataAccessApiUsageException("Slice and Page queries are not supported");
        }
    }

    public CassandraEntityMetadata<?> getEntityInformation() {
        if (this.entityMetadata == null) {
            Class returnedObjectType = this.getReturnedObjectType();
            Class domainClass = this.getDomainClass();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedObjectType)) {
                this.entityMetadata = new SimpleCassandraEntityMetadata(domainClass, (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(domainClass));
            } else {
                CassandraPersistentEntity returnedEntity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(returnedObjectType);
                CassandraPersistentEntity managedEntity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
                returnedEntity = returnedEntity == null || returnedEntity.getType().isInterface() ? managedEntity : returnedEntity;
                CassandraPersistentEntity collectionEntity = domainClass.isAssignableFrom(returnedObjectType) ? returnedEntity : managedEntity;
                this.entityMetadata = new SimpleCassandraEntityMetadata(returnedEntity.getType(), collectionEntity);
            }
        }
        return this.entityMetadata;
    }

    protected CassandraParameters createParameters(Method method) {
        return new CassandraParameters(method);
    }

    public boolean hasAnnotatedQuery() {
        return this.getAnnotatedQuery() != null;
    }

    public String getAnnotatedQuery() {
        String query = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation());
        return StringUtils.hasText((String)query) ? query : null;
    }

    Query getQueryAnnotation() {
        return (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Query.class);
    }

    public TypeInformation<?> getReturnType() {
        return ClassTypeInformation.fromReturnTypeOf((Method)this.method);
    }

    public boolean isResultSetQuery() {
        return ResultSet.class.isAssignableFrom(this.getReturnType().getActualType().getType());
    }
}

