/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.beans.ConstructorProperties;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.ClassUtils;

interface CassandraQueryExecution {
    public Object execute(String var1, Class<?> var2);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ResultProcessor processor;

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            return this.processor.processResult(source);
        }

        @ConstructorProperties(value={"processor"})
        public ResultProcessingConverter(@NonNull ResultProcessor processor) {
            if (processor == null) {
                throw new NullPointerException("processor");
            }
            this.processor = processor;
        }
    }

    public static final class ResultProcessingExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraQueryExecution delegate;
        @NonNull
        private final Converter<Object, Object> converter;

        @Override
        public Object execute(String query, Class<?> type) {
            return this.converter.convert(this.delegate.execute(query, type));
        }

        @ConstructorProperties(value={"delegate", "converter"})
        public ResultProcessingExecution(@NonNull CassandraQueryExecution delegate, @NonNull Converter<Object, Object> converter) {
            if (delegate == null) {
                throw new NullPointerException("delegate");
            }
            if (converter == null) {
                throw new NullPointerException("converter");
            }
            this.delegate = delegate;
            this.converter = converter;
        }
    }

    public static final class ResultSetQuery
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;

        @Override
        public Object execute(String query, Class<?> type) {
            return this.operations.query(query);
        }

        @ConstructorProperties(value={"operations"})
        public ResultSetQuery(@NonNull CassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            this.operations = operations;
        }
    }

    public static final class SingleEntityExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;

        @Override
        public Object execute(String query, Class<?> type) {
            return this.operations.selectOne(query, type);
        }

        @ConstructorProperties(value={"operations"})
        public SingleEntityExecution(@NonNull CassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            this.operations = operations;
        }
    }

    public static final class CollectionExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;

        @Override
        public Object execute(String query, Class<?> type) {
            return this.operations.select(query, type);
        }

        @ConstructorProperties(value={"operations"})
        public CollectionExecution(@NonNull CassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            this.operations = operations;
        }
    }

    public static final class StreamExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;
        @NonNull
        private final Converter<Object, Object> resultProcessing;

        @Override
        public Object execute(String query, Class<?> type) {
            return StreamUtils.createStreamFromIterator(this.operations.stream(query, type)).map(new Function<Object, Object>(){

                @Override
                public Object apply(Object t) {
                    return StreamExecution.this.resultProcessing.convert(t);
                }
            });
        }

        @ConstructorProperties(value={"operations", "resultProcessing"})
        public StreamExecution(@NonNull CassandraOperations operations, @NonNull Converter<Object, Object> resultProcessing) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            if (resultProcessing == null) {
                throw new NullPointerException("resultProcessing");
            }
            this.operations = operations;
            this.resultProcessing = resultProcessing;
        }
    }
}

