/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.ConvertingParameterAccessor;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

class CassandraQueryCreator
extends AbstractQueryCreator<Select, Clause> {
    private static final Pattern PUNCTUATION_PATTERN = Pattern.compile("\\p{Punct}");
    private static final Logger LOG = LoggerFactory.getLogger(CassandraQueryCreator.class);
    private final CassandraMappingContext mappingContext;
    private final CassandraPersistentEntity<?> entity;
    private final WhereBuilder whereBuilder = new WhereBuilder();

    public CassandraQueryCreator(PartTree tree, CassandraParameterAccessor accessor, CassandraMappingContext mappingContext, EntityMetadata<?> entityMetadata) {
        super(tree, (ParameterAccessor)accessor);
        Assert.notNull((Object)mappingContext, (String)"CassandraMappingContext must not be null");
        Assert.notNull(entityMetadata, (String)"EntityMetaData must not be null");
        this.mappingContext = mappingContext;
        this.entity = (CassandraPersistentEntity)mappingContext.getPersistentEntity(entityMetadata.getJavaType());
    }

    protected Clause create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.mappingContext.getPersistentPropertyPath(part.getProperty());
        CassandraPersistentProperty property = (CassandraPersistentProperty)path.getLeafProperty();
        return this.from(part, property, (ConvertingParameterAccessor.PotentiallyConvertingIterator)iterator);
    }

    protected Clause and(Part part, Clause base, Iterator<Object> iterator) {
        if (base == null) {
            return this.whereBuilder.and(this.create(part, iterator));
        }
        this.whereBuilder.and(base);
        return this.create(part, iterator);
    }

    protected Clause or(Clause base, Clause criteria) {
        throw new InvalidDataAccessApiUsageException("Cassandra does not support an OR operator");
    }

    protected Select complete(Clause criteria, Sort sort) {
        if (criteria != null) {
            this.whereBuilder.and(criteria);
        }
        Select select = StatementBuilder.select(this.entity, this.whereBuilder, sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created query {}", (Object)select);
        }
        return select;
    }

    private Clause from(Part part, CassandraPersistentProperty property, ConvertingParameterAccessor.PotentiallyConvertingIterator parameters) {
        Part.Type type = part.getType();
        switch (type) {
            case AFTER: 
            case GREATER_THAN: {
                return QueryBuilder.gt((String)CassandraQueryCreator.columnName(property), (Object)parameters.nextConverted(property));
            }
            case GREATER_THAN_EQUAL: {
                return QueryBuilder.gte((String)CassandraQueryCreator.columnName(property), (Object)parameters.nextConverted(property));
            }
            case BEFORE: 
            case LESS_THAN: {
                return QueryBuilder.lt((String)CassandraQueryCreator.columnName(property), (Object)parameters.nextConverted(property));
            }
            case LESS_THAN_EQUAL: {
                return QueryBuilder.lte((String)CassandraQueryCreator.columnName(property), (Object)parameters.nextConverted(property));
            }
            case IN: {
                return QueryBuilder.in((String)CassandraQueryCreator.columnName(property), (Object[])this.nextAsArray(property, parameters));
            }
            case LIKE: 
            case STARTING_WITH: 
            case ENDING_WITH: {
                return QueryBuilder.like((String)CassandraQueryCreator.columnName(property), (Object)this.like(type, parameters.nextConverted(property)));
            }
            case CONTAINING: {
                return this.containing(property, parameters.nextConverted(property));
            }
            case TRUE: {
                return QueryBuilder.eq((String)CassandraQueryCreator.columnName(property), (Object)true);
            }
            case FALSE: {
                return QueryBuilder.eq((String)CassandraQueryCreator.columnName(property), (Object)false);
            }
            case SIMPLE_PROPERTY: {
                return QueryBuilder.eq((String)CassandraQueryCreator.columnName(property), (Object)parameters.nextConverted(property));
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Unsupported keyword [%s] in part [%s]", type, part));
    }

    private static String columnName(CassandraPersistentProperty property) {
        return property.getColumnName().toCql();
    }

    private Clause containing(CassandraPersistentProperty property, Object bindableValue) {
        if (property.isCollectionLike() || property.isMapLike()) {
            return QueryBuilder.contains((String)CassandraQueryCreator.columnName(property), (Object)bindableValue);
        }
        return QueryBuilder.like((String)CassandraQueryCreator.columnName(property), (Object)this.like(Part.Type.CONTAINING, bindableValue));
    }

    private Object like(Part.Type type, Object value) {
        if (value != null) {
            switch (type) {
                case LIKE: {
                    return value;
                }
                case CONTAINING: {
                    return "%" + value + "%";
                }
                case STARTING_WITH: {
                    return value + "%";
                }
                case ENDING_WITH: {
                    return "%" + value;
                }
            }
            throw new IllegalArgumentException(String.format("Part Type [%s] not supported with like queries", type));
        }
        return null;
    }

    private Object[] nextAsArray(CassandraPersistentProperty property, ConvertingParameterAccessor.PotentiallyConvertingIterator iterator) {
        Object next = iterator.nextConverted(property);
        if (next instanceof Collection) {
            return ((Collection)next).toArray();
        }
        if (next.getClass().isArray()) {
            return (Object[])next;
        }
        return new Object[]{next};
    }

    static class StatementBuilder {
        StatementBuilder() {
        }

        static Select select(CassandraPersistentEntity<?> entity, WhereBuilder whereBuilder, Sort sort) {
            Select select = QueryBuilder.select().from(entity.getTableName().toCql());
            whereBuilder.build(select.where());
            if (sort != null) {
                for (Sort.Order order : sort) {
                    String dotPath = order.getProperty();
                    CassandraPersistentProperty property = StatementBuilder.getPersistentProperty(entity, dotPath);
                    if (order.isAscending()) {
                        select.orderBy(new Ordering[]{QueryBuilder.asc((String)CassandraQueryCreator.columnName(property))});
                        continue;
                    }
                    select.orderBy(new Ordering[]{QueryBuilder.desc((String)CassandraQueryCreator.columnName(property))});
                }
            }
            return select;
        }

        private static CassandraPersistentProperty getPersistentProperty(CassandraPersistentEntity<?> entity, String dotPath) {
            String[] segments = PUNCTUATION_PATTERN.split(dotPath);
            CassandraPersistentProperty property = null;
            CassandraPersistentEntity<?> currentEntity = entity;
            for (String segment : segments) {
                property = (CassandraPersistentProperty)currentEntity.getPersistentProperty(segment);
                if (property == null || !property.isCompositePrimaryKey()) continue;
                currentEntity = property.getCompositePrimaryKeyEntity();
            }
            if (property != null) {
                return property;
            }
            throw new IllegalArgumentException(String.format("Cannot resolve path [%s] to a property of [%s]", dotPath, entity.getName()));
        }
    }

    static class WhereBuilder {
        private List<Clause> clauses = new ArrayList<Clause>();

        WhereBuilder() {
        }

        Clause and(Clause clause) {
            this.clauses.add(clause);
            return clause;
        }

        Select.Where build(Select.Where where) {
            for (Clause clause : this.clauses) {
                where = where.and(clause);
            }
            return where;
        }
    }
}

