/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.cassandra.mapping.CassandraType;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

public class CassandraParameters
extends Parameters<CassandraParameters, CassandraParameter> {
    public CassandraParameters(Method method) {
        super(method);
    }

    private CassandraParameters(List<CassandraParameter> originals) {
        super(originals);
    }

    protected CassandraParameter createParameter(MethodParameter parameter) {
        return new CassandraParameter(parameter);
    }

    protected CassandraParameters createFrom(List<CassandraParameter> parameters) {
        return new CassandraParameters(parameters);
    }

    class CassandraParameter
    extends Parameter {
        private final CassandraType cassandraType;

        protected CassandraParameter(MethodParameter parameter) {
            super(parameter);
            if (parameter.hasParameterAnnotation(CassandraType.class)) {
                CassandraType cassandraType = (CassandraType)parameter.getParameterAnnotation(CassandraType.class);
                Assert.notNull((Object)cassandraType.type(), (String)String.format("You must specify the type() when annotating method parameters with @%s", CassandraType.class.getSimpleName()));
                this.cassandraType = cassandraType;
            } else {
                this.cassandraType = null;
            }
        }

        public CassandraType getCassandraType() {
            return this.cassandraType;
        }
    }
}

