/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.mapping.Table;
import org.springframework.data.cassandra.mapping.VerifierMappingExceptions;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.MappingException;

public class BasicCassandraPersistentEntityMetadataVerifier
implements CassandraPersistentEntityMetadataVerifier {
    private static final Logger log = LoggerFactory.getLogger(BasicCassandraPersistentEntityMetadataVerifier.class);
    protected boolean strict = false;

    @Override
    public void verify(CassandraPersistentEntity<?> entity) throws MappingException {
        if (entity.getType().isInterface()) {
            return;
        }
        VerifierMappingExceptions exceptions = new VerifierMappingExceptions(entity, String.format("Mapping Exceptions from BasicCassandraPersistentEntityMetadataVerifier for %s", entity.getName()));
        final ArrayList idProperties = new ArrayList();
        final ArrayList compositePrimaryKeys = new ArrayList();
        final ArrayList partitionKeyColumns = new ArrayList();
        final ArrayList clusterKeyColumns = new ArrayList();
        final ArrayList primaryKeyColumns = new ArrayList();
        Class entityType = entity.getType();
        boolean isTable = entityType.isAnnotationPresent(Table.class) || entityType.isAnnotationPresent(Persistent.class);
        boolean isPrimaryKeyClass = entityType.isAnnotationPresent(PrimaryKeyClass.class);
        if (isTable && isPrimaryKeyClass) {
            exceptions.add(new MappingException("Entity cannot be of type Table and PrimaryKey"));
            throw exceptions;
        }
        if (!isTable && !isPrimaryKeyClass) {
            exceptions.add(new MappingException("Cassandra entities must have the @Table, @Persistent or @PrimaryKeyClass Annotation"));
            throw exceptions;
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                if (property.isIdProperty()) {
                    idProperties.add(property);
                } else if (property.isClusterKeyColumn()) {
                    clusterKeyColumns.add(property);
                    primaryKeyColumns.add(property);
                } else if (property.isCompositePrimaryKey()) {
                    compositePrimaryKeys.add(property);
                } else if (property.isPartitionKeyColumn()) {
                    partitionKeyColumns.add(property);
                    primaryKeyColumns.add(property);
                }
            }
        });
        int idPropertyCount = idProperties.size();
        int partitionKeyColumnCount = partitionKeyColumns.size();
        int primaryKeyColumnCount = primaryKeyColumns.size();
        if (isPrimaryKeyClass) {
            if (primaryKeyColumnCount == 0) {
                exceptions.add(new MappingException(String.format("Composite primary key type [%s] has no fields annotated with @%s", entity.getType().getName(), PrimaryKeyColumn.class.getSimpleName())));
            }
            if (partitionKeyColumnCount == 0) {
                exceptions.add(new MappingException("At least one of the @PrimaryKeyColumn annotations must have a type of PARTITIONED"));
            }
            if (idPropertyCount > 0) {
                exceptions.add(new MappingException("Annotations @Id and @PrimaryKey are invalid for type annotated with @PrimaryKeyClass"));
            }
            for (CassandraPersistentProperty property : primaryKeyColumns) {
                if (CassandraSimpleTypeHolder.getDataTypeFor(property.getType()) != null) continue;
                exceptions.add(new MappingException("Fields annotated with @PrimaryKeyColumn must be simple CassandraTypes"));
            }
            if (!Serializable.class.isAssignableFrom(entityType)) {
                exceptions.add(new MappingException("@PrimaryKeyClass must be Serializable"));
            }
            if (!entityType.getSuperclass().equals(Object.class)) {
                exceptions.add(new MappingException("@PrimaryKeyClass must only extend Object"));
            }
            this.verifyMethodPresent(entityType, "equals", "boolean equals(Object)", exceptions);
            this.verifyMethodPresent(entityType, "hashCode", "int hashCode()", exceptions);
        }
        if (isTable) {
            if (primaryKeyColumnCount == 0) {
                if (idPropertyCount != 1) {
                    exceptions.add(new MappingException(String.format("@Table/@Persistent types must have only one @PrimaryKey attribute, if any; Found %s", idPropertyCount)));
                    throw exceptions;
                }
                Class idType = ((CassandraPersistentProperty)idProperties.get(0)).getType();
                if (!idType.isAnnotationPresent(PrimaryKeyClass.class) && CassandraSimpleTypeHolder.getDataTypeFor(idType) == null) {
                    exceptions.add(new MappingException("Fields annotated with @PrimaryKey must be simple CassandraTypes or @PrimaryKeyClass type"));
                }
            } else {
                if (idPropertyCount > 0) {
                    exceptions.add(new MappingException(String.format("@Table/@Persistent types must not define both @PrimaryKeyColumn field(s) (found %s) and @PrimaryKey field(s) (found %s)", primaryKeyColumnCount, idPropertyCount)));
                    throw exceptions;
                }
                if (partitionKeyColumnCount == 0) {
                    exceptions.add(new MappingException(String.format("@Table/@Persistent types must define at least one @PrimaryKeyColumn of type PARTITIONED", new Object[0])));
                }
            }
        }
        if (exceptions.getCount() > 0) {
            log.error("Exceptions while verifying PersistentEntity", (Throwable)((Object)exceptions));
            throw exceptions;
        }
    }

    boolean verifyMethodPresent(Class<?> type, String methodName, String methodDescription, VerifierMappingExceptions exceptions) {
        try {
            Method method = type.getDeclaredMethod(methodName, Object.class);
            if (method == null || !method.getDeclaringClass().equals(type)) {
                throw new NoSuchMethodException();
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            String message = String.format("@PrimaryKeyClass should override '%s' method and use all @PrimaryKeyColumn fields", methodDescription);
            if (this.strict) {
                exceptions.add(new MappingException(message, (Throwable)e));
            } else {
                log.warn(message);
            }
            return false;
        }
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

