/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.convert.AbstractCassandraConverter;
import org.springframework.data.cassandra.convert.BasicCassandraRowValueProvider;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.CassandraPersistentEntityParameterValueProvider;
import org.springframework.data.cassandra.convert.RowReaderPropertyAccessor;
import org.springframework.data.cassandra.mapping.BasicCassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.MapId;
import org.springframework.data.cassandra.repository.MapIdentifiable;
import org.springframework.data.cassandra.repository.support.BasicMapId;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MappingCassandraConverter
extends AbstractCassandraConverter
implements CassandraConverter,
ApplicationContextAware,
BeanClassLoaderAware {
    protected final CassandraMappingContext mappingContext;
    protected ApplicationContext applicationContext;
    protected ClassLoader beanClassLoader;
    protected SpELContext spELContext;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public MappingCassandraConverter() {
        this(new BasicCassandraMappingContext());
    }

    public MappingCassandraConverter(CassandraMappingContext mappingContext) {
        super((ConversionService)new DefaultConversionService());
        Assert.notNull((Object)mappingContext, (String)"CassandraMappingContext must not be null");
        this.mappingContext = mappingContext;
        this.spELContext = new SpELContext((PropertyAccessor)RowReaderPropertyAccessor.INSTANCE);
    }

    public <R> R readRow(Class<R> type, Row row) {
        Class<R> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(type);
        ClassTypeInformation typeInfo = ClassTypeInformation.from(beanClassLoaderClass);
        Class rawType = typeInfo.getType();
        if (Row.class.isAssignableFrom(rawType)) {
            return (R)row;
        }
        if (this.conversions.hasCustomReadTarget(Row.class, rawType) || this.conversionService.canConvert(Row.class, rawType)) {
            return (R)this.conversionService.convert((Object)row, rawType);
        }
        if (typeInfo.isCollectionLike() || typeInfo.isMap()) {
            return (R)this.conversionService.convert((Object)row, type);
        }
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity((TypeInformation)typeInfo);
        if (persistentEntity == null) {
            throw new MappingException("No mapping metadata found for " + rawType.getName());
        }
        return (R)this.readEntityFromRow(persistentEntity, row);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    protected <S> S readEntityFromRow(CassandraPersistentEntity<S> entity, Row row) {
        DefaultSpELExpressionEvaluator expressionEvaluator = new DefaultSpELExpressionEvaluator((Object)row, this.spELContext);
        BasicCassandraRowValueProvider rowValueProvider = new BasicCassandraRowValueProvider(row, expressionEvaluator);
        CassandraPersistentEntityParameterValueProvider parameterProvider = new CassandraPersistentEntityParameterValueProvider((PersistentEntity<?, CassandraPersistentProperty>)entity, rowValueProvider, null);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)parameterProvider);
        this.readPropertiesFromRow(entity, rowValueProvider, (PersistentPropertyAccessor)this.getConvertingAccessor(instance, entity));
        return (S)instance;
    }

    protected void readPropertiesFromRow(final CassandraPersistentEntity<?> entity, final BasicCassandraRowValueProvider row, final PersistentPropertyAccessor propertyAccessor) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                MappingCassandraConverter.this.readPropertyFromRow(entity, property, row, propertyAccessor);
            }
        });
    }

    protected void readPropertyFromRow(CassandraPersistentEntity<?> entity, CassandraPersistentProperty property, BasicCassandraRowValueProvider row, PersistentPropertyAccessor propertyAccessor) {
        if (entity.isConstructorArgument(property)) {
            return;
        }
        if (property.isCompositePrimaryKey()) {
            CassandraPersistentProperty keyProperty = (CassandraPersistentProperty)entity.getIdProperty();
            CassandraPersistentEntity<?> keyEntity = keyProperty.getCompositePrimaryKeyEntity();
            Object key = propertyAccessor.getProperty((PersistentProperty)keyProperty);
            if (key == null) {
                key = this.instantiatePrimaryKey(keyEntity, keyProperty, row);
            }
            this.readPropertiesFromRow(property.getCompositePrimaryKeyEntity(), row, (PersistentPropertyAccessor)this.getConvertingAccessor(key, keyEntity));
            propertyAccessor.setProperty((PersistentProperty)keyProperty, key);
            return;
        }
        if (!row.getRow().getColumnDefinitions().contains(property.getColumnName().toCql())) {
            return;
        }
        Object obj = this.getReadValue(property, row);
        propertyAccessor.setProperty((PersistentProperty)property, obj);
    }

    protected Object instantiatePrimaryKey(CassandraPersistentEntity<?> entity, CassandraPersistentProperty keyProperty, BasicCassandraRowValueProvider propertyProvider) {
        return this.instantiators.getInstantiatorFor(entity).createInstance(entity, (ParameterValueProvider)new CassandraPersistentEntityParameterValueProvider((PersistentEntity<?, CassandraPersistentProperty>)entity, propertyProvider, null));
    }

    public <R> R read(Class<R> type, Object row) {
        if (row instanceof Row) {
            return this.readRow(type, (Row)row);
        }
        throw new MappingException("Unknown row object " + ObjectUtils.nullSafeClassName((Object)row));
    }

    public void write(Object source, Object sink) {
        if (source != null) {
            Class<?> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(source.getClass());
            CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(beanClassLoaderClass);
            this.write(source, sink, entity);
        }
    }

    @Override
    public void write(Object source, Object sink, CassandraPersistentEntity<?> entity) {
        if (source == null) {
            return;
        }
        if (entity == null) {
            throw new MappingException("No mapping metadata found for " + source.getClass());
        }
        if (sink instanceof Insert) {
            this.writeInsertFromObject(source, (Insert)sink, entity);
        } else if (sink instanceof Update) {
            this.writeUpdateFromObject(source, (Update)sink, entity);
        } else if (sink instanceof Select.Where) {
            this.writeSelectWhereFromObject(source, (Select.Where)sink, entity);
        } else if (sink instanceof Delete.Where) {
            this.writeDeleteWhereFromObject(source, (Delete.Where)sink, entity);
        } else {
            throw new MappingException("Unknown write target " + sink.getClass().getName());
        }
    }

    protected void writeInsertFromObject(Object object, Insert insert, CassandraPersistentEntity<?> entity) {
        this.writeInsertFromWrapper(this.getConvertingAccessor(object, entity), insert, entity);
    }

    protected void writeInsertFromWrapper(final ConvertingPropertyAccessor accessor, final Insert insert, CassandraPersistentEntity<?> entity) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                Object value = MappingCassandraConverter.this.getWriteValue(property, accessor);
                if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                    MappingCassandraConverter.this.log.debug("doWithProperties Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
                }
                if (property.isCompositePrimaryKey()) {
                    if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                        MappingCassandraConverter.this.log.debug("Property is a compositeKey");
                    }
                    MappingCassandraConverter.this.writeInsertFromWrapper(MappingCassandraConverter.this.getConvertingAccessor(value, property.getCompositePrimaryKeyEntity()), insert, property.getCompositePrimaryKeyEntity());
                    return;
                }
                if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                    MappingCassandraConverter.this.log.debug("Adding insert.value [{}] - [{}]", (Object)property.getColumnName().toCql(), value);
                }
                insert.value(property.getColumnName().toCql(), value);
            }
        });
    }

    protected void writeUpdateFromObject(Object object, Update update, CassandraPersistentEntity<?> entity) {
        this.writeUpdateFromWrapper(this.getConvertingAccessor(object, entity), update, entity);
    }

    protected void writeUpdateFromWrapper(final ConvertingPropertyAccessor accessor, final Update update, CassandraPersistentEntity<?> entity) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                Object value = MappingCassandraConverter.this.getWriteValue(property, accessor);
                if (property.isCompositePrimaryKey()) {
                    CassandraPersistentEntity<?> keyEntity = property.getCompositePrimaryKeyEntity();
                    MappingCassandraConverter.this.writeUpdateFromWrapper(MappingCassandraConverter.this.getConvertingAccessor(value, keyEntity), update, keyEntity);
                    return;
                }
                if (MappingCassandraConverter.this.isPrimaryKeyPart(property)) {
                    update.where(QueryBuilder.eq((String)property.getColumnName().toCql(), (Object)value));
                } else {
                    update.with(QueryBuilder.set((String)property.getColumnName().toCql(), (Object)value));
                }
            }
        });
    }

    protected void writeSelectWhereFromObject(Object object, Select.Where where, CassandraPersistentEntity<?> entity) {
        Collection<Clause> clauses = this.getWhereClauses(object, entity);
        for (Clause clause : clauses) {
            where.and(clause);
        }
    }

    protected void writeDeleteWhereFromObject(Object object, Delete.Where where, CassandraPersistentEntity<?> entity) {
        Collection<Clause> clauses = this.getWhereClauses(object, entity);
        for (Clause clause : clauses) {
            where.and(clause);
        }
    }

    private Collection<Clause> getWhereClauses(Object source, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Id source must not be null");
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        Object id = this.extractId(source, entity);
        if (id == null) {
            String message = String.format("No Id value found in object %s", source);
            throw new IllegalArgumentException(message);
        }
        if (id instanceof MapId) {
            return this.getWhereClauses((MapId)id, idProperty != null && idProperty.isCompositePrimaryKey() ? idProperty.getCompositePrimaryKeyEntity() : entity);
        }
        if (idProperty == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot obtain where clauses for entity [%s] using [%s]", entity.getName(), source));
        }
        if (idProperty.isCompositePrimaryKey()) {
            if (ClassUtils.isAssignableValue((Class)idProperty.getType(), (Object)id)) {
                return this.getWhereClauses(this.getConvertingAccessor(id, idProperty.getCompositePrimaryKeyEntity()), idProperty.getCompositePrimaryKeyEntity());
            }
            throw new InvalidDataAccessApiUsageException(String.format("Cannot use [%s] as composite Id for [%s]", id, entity.getName()));
        }
        TypeCodec<Object> codec = this.getCodec(idProperty);
        if (this.conversionService.canConvert(id.getClass(), codec.getJavaType().getRawType())) {
            return Collections.singleton(QueryBuilder.eq((String)idProperty.getColumnName().toCql(), (Object)this.conversionService.convert(id, codec.getJavaType().getRawType())));
        }
        return Collections.singleton(QueryBuilder.eq((String)idProperty.getColumnName().toCql(), (Object)id));
    }

    private Object extractId(Object source, CassandraPersistentEntity<?> entity) {
        if (ClassUtils.isAssignableValue((Class)entity.getType(), (Object)source)) {
            return this.getId(source, entity);
        }
        if (source instanceof MapId) {
            return source;
        }
        if (source instanceof MapIdentifiable) {
            return ((MapIdentifiable)source).getMapId();
        }
        return source;
    }

    private Collection<Clause> getWhereClauses(final ConvertingPropertyAccessor accessor, CassandraPersistentEntity<?> entity) {
        Assert.isTrue((boolean)entity.isCompositePrimaryKey(), (String)String.format("Entity [%s] is not a composite primary key", entity.getName()));
        final ArrayList<Clause> clauses = new ArrayList<Clause>();
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                TypeCodec codec = MappingCassandraConverter.this.getCodec(property);
                Object value = accessor.getProperty((PersistentProperty)property, codec.getJavaType().getRawType());
                clauses.add(QueryBuilder.eq((String)property.getColumnName().toCql(), (Object)value));
            }
        });
        return clauses;
    }

    private Collection<Clause> getWhereClauses(MapId id, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)id, (String)"MapId must not be null");
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        for (Map.Entry entry : id.entrySet()) {
            CassandraPersistentProperty persistentProperty = (CassandraPersistentProperty)entity.getPersistentProperty((String)entry.getKey());
            if (persistentProperty == null) {
                throw new IllegalArgumentException(String.format("MapId contains references [%s] that is an unknown property of [%s]", entry.getKey(), entity.getName()));
            }
            clauses.add(QueryBuilder.eq((String)persistentProperty.getColumnName().toCql(), (Object)this.getWriteValue(persistentProperty, entry.getValue())));
        }
        return clauses;
    }

    @Override
    public Object getId(Object object, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)object, (String)"Object instance must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        final ConvertingPropertyAccessor accessor = this.getConvertingAccessor(object, entity);
        if (!entity.getType().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException(String.format("Given instance of type [%s] is not of compatible expected type [%s]", object.getClass().getName(), entity.getType().getName()));
        }
        if (object instanceof MapIdentifiable) {
            return ((MapIdentifiable)object).getMapId();
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            return accessor.getProperty((PersistentProperty)idProperty, idProperty.isCompositePrimaryKey() ? idProperty.getType() : this.getCodec(idProperty).getJavaType().getRawType());
        }
        final MapId id = BasicMapId.id();
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                if (property.isPrimaryKeyColumn()) {
                    id.with(property.getName(), (Serializable)MappingCassandraConverter.this.getWriteValue(property, accessor));
                }
            }
        });
        return id;
    }

    protected <T> Class<T> transformClassToBeanClassLoaderClass(Class<T> entity) {
        try {
            return ClassUtils.forName((String)entity.getName(), (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException e) {
            return entity;
        }
        catch (LinkageError e) {
            return entity;
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    private ConvertingPropertyAccessor getConvertingAccessor(Object source, CassandraPersistentEntity<?> entity) {
        PersistentPropertyAccessor propertyAccessor = source instanceof PersistentPropertyAccessor ? (PersistentPropertyAccessor)source : entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(propertyAccessor, this.conversionService);
    }

    private boolean isPrimaryKeyPart(CassandraPersistentProperty property) {
        return property.isCompositePrimaryKey() || property.isPrimaryKeyColumn() || property.isIdProperty();
    }

    private Class<?> getTargetType(CassandraPersistentProperty property) {
        return property.isCompositePrimaryKey() ? property.getType() : this.getCodec(property).getJavaType().getRawType();
    }

    private Object getWriteValue(CassandraPersistentProperty property, ConvertingPropertyAccessor accessor) {
        return this.getWriteValue(property, accessor.getProperty((PersistentProperty)property, this.getTargetType(property)));
    }

    private Object getWriteValue(CassandraPersistentProperty property, Object value) {
        if (value != null && this.conversions.hasCustomWriteTarget(property.getActualType()) && property.isCollectionLike()) {
            Class<?> customWriteTarget = this.conversions.getCustomWriteTarget(property.getActualType());
            if (Collection.class.isAssignableFrom(property.getType()) && value instanceof Collection) {
                Collection original = (Collection)value;
                Collection converted = CollectionFactory.createCollection((Class)property.getType(), (int)original.size());
                for (Object o : original) {
                    converted.add(this.getConversionService().convert(o, customWriteTarget));
                }
                value = converted;
            }
        }
        return value;
    }

    private Object getReadValue(CassandraPersistentProperty property, BasicCassandraRowValueProvider row) {
        Object obj = row.getPropertyValue(property);
        if (obj != null && this.conversions.hasCustomWriteTarget(property.getActualType()) && property.isCollectionLike() && Collection.class.isAssignableFrom(property.getType()) && obj instanceof Collection) {
            Collection original = (Collection)obj;
            Collection converted = CollectionFactory.createCollection((Class)property.getType(), (int)original.size());
            for (Object element : original) {
                converted.add(this.getConversionService().convert(element, property.getActualType()));
            }
            return converted;
        }
        return obj;
    }

    private TypeCodec<Object> getCodec(CassandraPersistentProperty property) {
        return CodecRegistry.DEFAULT_INSTANCE.codecFor(this.mappingContext.getDataType(property));
    }
}

