/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config.java;

import java.util.Collections;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.cassandra.config.java.AbstractClusterConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.config.CassandraEntityClassScanner;
import org.springframework.data.cassandra.config.CassandraSessionFactoryBean;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.CustomConversions;
import org.springframework.data.cassandra.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.mapping.BasicCassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;

@Configuration
public abstract class AbstractCassandraConfiguration
extends AbstractClusterConfiguration
implements BeanClassLoaderAware {
    protected ClassLoader beanClassLoader;

    @Bean
    public CassandraSessionFactoryBean session() throws Exception {
        CassandraSessionFactoryBean session = new CassandraSessionFactoryBean();
        session.setCluster(this.cluster().getObject());
        session.setConverter(this.cassandraConverter());
        session.setKeyspaceName(this.getKeyspaceName());
        session.setSchemaAction(this.getSchemaAction());
        session.setStartupScripts(this.getStartupScripts());
        session.setShutdownScripts(this.getShutdownScripts());
        return session;
    }

    @Bean
    public CassandraConverter cassandraConverter() throws Exception {
        MappingCassandraConverter mappingCassandraConverter = new MappingCassandraConverter(this.cassandraMapping());
        mappingCassandraConverter.setCustomConversions(this.customConversions());
        return mappingCassandraConverter;
    }

    @Bean
    public CustomConversions customConversions() {
        return new CustomConversions(Collections.emptyList());
    }

    @Bean
    public CassandraMappingContext cassandraMapping() throws ClassNotFoundException {
        BasicCassandraMappingContext mappingContext = new BasicCassandraMappingContext();
        mappingContext.setBeanClassLoader(this.beanClassLoader);
        mappingContext.setInitialEntitySet(CassandraEntityClassScanner.scan(this.getEntityBasePackages()));
        CustomConversions customConversions = this.customConversions();
        mappingContext.setCustomConversions(customConversions);
        mappingContext.setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        return mappingContext;
    }

    @Bean
    public CassandraAdminOperations cassandraTemplate() throws Exception {
        return new CassandraAdminTemplate(this.session().getObject(), this.cassandraConverter());
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public String[] getEntityBasePackages() {
        return new String[]{((Object)((Object)this)).getClass().getPackage().getName()};
    }

    protected abstract String getKeyspaceName();

    public SchemaAction getSchemaAction() {
        return SchemaAction.NONE;
    }
}

