/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.converter;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;

@ReadingConverter
public class RowToListConverter
implements Converter<Row, List<Object>> {
    public static final RowToListConverter INSTANCE = new RowToListConverter();

    public List<Object> convert(Row row) {
        if (row == null) {
            return null;
        }
        CodecRegistry codecRegistry = CodecRegistry.DEFAULT_INSTANCE;
        ColumnDefinitions cols = row.getColumnDefinitions();
        ArrayList<Object> list = new ArrayList<Object>(cols.size());
        for (ColumnDefinitions.Definition def : cols.asList()) {
            String name = def.getName();
            list.add(row.isNull(name) ? null : codecRegistry.codecFor(def.getType()).deserialize(row.getBytesUnsafe(name), ProtocolVersion.NEWEST_SUPPORTED));
        }
        return list;
    }
}

