/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Truncate;
import com.datastax.driver.core.querybuilder.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.cassandra.core.AsynchronousQueryListener;
import org.springframework.cassandra.core.CachedPreparedStatementCreator;
import org.springframework.cassandra.core.Cancellable;
import org.springframework.cassandra.core.CassandraUncategorizedDataAccessException;
import org.springframework.cassandra.core.ConsistencyLevelResolver;
import org.springframework.cassandra.core.CqlOperations;
import org.springframework.cassandra.core.HostMapper;
import org.springframework.cassandra.core.PreparedStatementBinder;
import org.springframework.cassandra.core.PreparedStatementCallback;
import org.springframework.cassandra.core.PreparedStatementCreator;
import org.springframework.cassandra.core.QueryForListListener;
import org.springframework.cassandra.core.QueryForMapListener;
import org.springframework.cassandra.core.QueryForObjectListener;
import org.springframework.cassandra.core.QueryOptions;
import org.springframework.cassandra.core.ResultSetExtractor;
import org.springframework.cassandra.core.ResultSetFutureCancellable;
import org.springframework.cassandra.core.ResultSetFutureExtractor;
import org.springframework.cassandra.core.RetryPolicyResolver;
import org.springframework.cassandra.core.RingMember;
import org.springframework.cassandra.core.RingMemberHostMapper;
import org.springframework.cassandra.core.RowCallbackHandler;
import org.springframework.cassandra.core.RowIterator;
import org.springframework.cassandra.core.RowMapper;
import org.springframework.cassandra.core.SessionCallback;
import org.springframework.cassandra.core.WriteOptions;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.cql.generator.AlterKeyspaceCqlGenerator;
import org.springframework.cassandra.core.cql.generator.AlterTableCqlGenerator;
import org.springframework.cassandra.core.cql.generator.CreateIndexCqlGenerator;
import org.springframework.cassandra.core.cql.generator.CreateKeyspaceCqlGenerator;
import org.springframework.cassandra.core.cql.generator.CreateTableCqlGenerator;
import org.springframework.cassandra.core.cql.generator.DropIndexCqlGenerator;
import org.springframework.cassandra.core.cql.generator.DropKeyspaceCqlGenerator;
import org.springframework.cassandra.core.cql.generator.DropTableCqlGenerator;
import org.springframework.cassandra.core.keyspace.AlterKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.AlterTableSpecification;
import org.springframework.cassandra.core.keyspace.CreateIndexSpecification;
import org.springframework.cassandra.core.keyspace.CreateKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.CreateTableSpecification;
import org.springframework.cassandra.core.keyspace.DropIndexSpecification;
import org.springframework.cassandra.core.keyspace.DropKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.DropTableSpecification;
import org.springframework.cassandra.support.CassandraAccessor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;

public class CqlTemplate
extends CassandraAccessor
implements CqlOperations {
    protected static final Executor RUN_RUNNABLE_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    protected static final ResultSetExtractor<ResultSet> RESULT_SET_RETURNING_EXTRACTOR = new ResultSetExtractor<ResultSet>(){

        @Override
        public ResultSet extractData(ResultSet resultSet) {
            return resultSet;
        }
    };

    protected String logCql(String cql) {
        return this.logCql("executing CQL [{}]", cql);
    }

    protected String logCql(String message, String cql) {
        this.logDebug(message, cql);
        return cql;
    }

    protected <T extends Statement> T logStatement(T statement) {
        this.logDebug("executing statement [{}]", statement);
        return statement;
    }

    public static PreparedStatement addPreparedStatementOptions(PreparedStatement preparedStatement, QueryOptions queryOptions) {
        if (queryOptions != null) {
            if (queryOptions.getConsistencyLevel() != null) {
                preparedStatement.setConsistencyLevel(ConsistencyLevelResolver.resolve(queryOptions.getConsistencyLevel()));
            }
            if (queryOptions.getRetryPolicy() != null) {
                preparedStatement.setRetryPolicy(RetryPolicyResolver.resolve(queryOptions.getRetryPolicy()));
            }
        }
        return preparedStatement;
    }

    public static <T extends Statement> T addQueryOptions(T statement, QueryOptions queryOptions) {
        if (queryOptions != null) {
            if (queryOptions.getConsistencyLevel() != null) {
                statement.setConsistencyLevel(ConsistencyLevelResolver.resolve(queryOptions.getConsistencyLevel()));
            }
            if (queryOptions.getRetryPolicy() != null) {
                statement.setRetryPolicy(RetryPolicyResolver.resolve(queryOptions.getRetryPolicy()));
            }
        }
        return statement;
    }

    public static Insert addWriteOptions(Insert insert, WriteOptions writeOptions) {
        if (writeOptions != null) {
            CqlTemplate.addQueryOptions(insert, writeOptions);
            if (writeOptions.getTtl() != null) {
                insert.using(QueryBuilder.ttl((int)writeOptions.getTtl()));
            }
        }
        return insert;
    }

    public static Update addWriteOptions(Update update, WriteOptions writeOptions) {
        if (writeOptions != null) {
            CqlTemplate.addQueryOptions(update, writeOptions);
            if (writeOptions.getTtl() != null) {
                update.using(QueryBuilder.ttl((int)writeOptions.getTtl()));
            }
        }
        return update;
    }

    public CqlTemplate() {
    }

    public CqlTemplate(Session session) {
        this.setSession(session);
    }

    protected <T> T doExecute(SessionCallback<T> callback) {
        Assert.notNull(callback, (String)"SessionCallback must not be null");
        try {
            return callback.doInSession(this.getSession());
        }
        catch (Throwable t) {
            throw this.translateExceptionIfPossible(t);
        }
    }

    protected ResultSet doExecuteQueryReturnResultSet(final String query) {
        return this.doExecute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) throws DataAccessException {
                return session.execute(CqlTemplate.this.logCql(query));
            }
        });
    }

    protected ResultSet doExecuteQueryReturnResultSet(final Select select) {
        return this.doExecute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) throws DataAccessException {
                return session.execute((Statement)CqlTemplate.this.logStatement(select));
            }
        });
    }

    @Override
    public <T> T execute(SessionCallback<T> sessionCallback) {
        return this.doExecute(sessionCallback);
    }

    @Override
    public void execute(String cql) {
        this.execute(cql, (QueryOptions)null);
    }

    @Override
    public void execute(String cql, QueryOptions options) {
        this.doExecute(cql, options);
    }

    @Override
    public void execute(Statement statement) {
        this.doExecute(statement);
    }

    @Override
    public ResultSetFuture queryAsynchronously(final String cql) {
        return this.execute(new SessionCallback<ResultSetFuture>(){

            @Override
            public ResultSetFuture doInSession(Session session) {
                return session.executeAsync(CqlTemplate.this.logCql("async execute CQL [{}]", cql));
            }
        });
    }

    @Override
    public <T> T queryAsynchronously(String cql, ResultSetExtractor<T> resultSetExtractor, Long timeout, TimeUnit timeUnit) {
        return this.queryAsynchronously(cql, resultSetExtractor, timeout, timeUnit, null);
    }

    @Override
    public <T> T queryAsynchronously(final String cql, ResultSetExtractor<T> resultSetExtractor, final Long timeout, final TimeUnit timeUnit, final QueryOptions options) {
        return resultSetExtractor.extractData(this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) {
                SimpleStatement statement = CqlTemplate.addQueryOptions(new SimpleStatement(CqlTemplate.this.logCql(cql)), options);
                ResultSetFuture resultSetFuture = session.executeAsync((Statement)statement);
                try {
                    return (ResultSet)resultSetFuture.get(timeout.longValue(), timeUnit);
                }
                catch (TimeoutException e) {
                    throw new QueryTimeoutException(String.format("timeout occurred in [%1$d %2$s] while asynchronously executing CQL [%3$s]", new Object[]{timeout, timeUnit, cql}), (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw CqlTemplate.this.translateExceptionIfPossible(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof Exception) {
                        throw CqlTemplate.this.translateExceptionIfPossible(e.getCause());
                    }
                    throw new CassandraUncategorizedDataAccessException("Unknown Throwable", e.getCause());
                }
            }
        }));
    }

    @Override
    public ResultSetFuture queryAsynchronously(final String cql, final QueryOptions queryOptions) {
        return this.execute(new SessionCallback<ResultSetFuture>(){

            @Override
            public ResultSetFuture doInSession(Session session) {
                return session.executeAsync((Statement)CqlTemplate.addQueryOptions(new SimpleStatement(CqlTemplate.this.logCql(cql)), queryOptions));
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(String cql, Runnable listener) {
        return this.queryAsynchronously(cql, listener, RUN_RUNNABLE_EXECUTOR);
    }

    @Override
    public Cancellable queryAsynchronously(String cql, AsynchronousQueryListener listener) {
        return this.queryAsynchronously(cql, listener, RUN_RUNNABLE_EXECUTOR);
    }

    @Override
    public Cancellable queryAsynchronously(String cql, Runnable listener, QueryOptions queryOptions) {
        return this.queryAsynchronously(cql, listener, queryOptions, RUN_RUNNABLE_EXECUTOR);
    }

    @Override
    public Cancellable queryAsynchronously(String cql, AsynchronousQueryListener listener, QueryOptions queryOptions) {
        return this.queryAsynchronously(cql, listener, queryOptions, RUN_RUNNABLE_EXECUTOR);
    }

    @Override
    public Cancellable queryAsynchronously(String cql, Runnable listener, Executor executor) {
        return this.queryAsynchronously(cql, listener, null, executor);
    }

    @Override
    public Cancellable queryAsynchronously(String cql, AsynchronousQueryListener listener, Executor executor) {
        return this.queryAsynchronously(cql, listener, null, executor);
    }

    @Override
    public Cancellable queryAsynchronously(final String cql, final Runnable listener, final QueryOptions queryOptions, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session session) {
                SimpleStatement statement = CqlTemplate.addQueryOptions(new SimpleStatement(CqlTemplate.this.logCql("async execute CQL [{}]", cql)), queryOptions);
                ResultSetFuture resultSetFuture = session.executeAsync((Statement)statement);
                resultSetFuture.addListener(listener, executor);
                return new ResultSetFutureCancellable(resultSetFuture);
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(final String cql, final AsynchronousQueryListener listener, final QueryOptions queryOptions, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session session) {
                SimpleStatement statement = CqlTemplate.addQueryOptions(new SimpleStatement(CqlTemplate.this.logCql("async execute CQL [{}]", cql)), queryOptions);
                final ResultSetFuture resultSetFuture = session.executeAsync((Statement)statement);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        listener.onQueryComplete(resultSetFuture);
                    }
                };
                resultSetFuture.addListener(runnable, executor);
                return new ResultSetFutureCancellable(resultSetFuture);
            }
        });
    }

    public <T> T queryAsynchronously(String cql, ResultSetFutureExtractor<T> resultSetFutureExtractor) {
        return this.queryAsynchronously(cql, resultSetFutureExtractor, null);
    }

    public <T> T queryAsynchronously(final String cql, ResultSetFutureExtractor<T> resultSetFutureExtractor, final QueryOptions queryOptions) {
        return resultSetFutureExtractor.extractData(this.execute(new SessionCallback<ResultSetFuture>(){

            @Override
            public ResultSetFuture doInSession(Session session) {
                return session.executeAsync((Statement)CqlTemplate.addQueryOptions(new SimpleStatement(CqlTemplate.this.logCql("async execute CQL [{}]", cql)), queryOptions));
            }
        }));
    }

    @Override
    public <T> T query(String cql, ResultSetExtractor<T> resultSetExtractor) {
        return this.query(cql, resultSetExtractor, null);
    }

    @Override
    public <T> T query(String cql, ResultSetExtractor<T> resultSetExtractor, QueryOptions queryOptions) {
        Assert.notNull((Object)cql, (String)"CQL must not be null");
        return resultSetExtractor.extractData(this.doExecute(cql, queryOptions));
    }

    @Override
    public void query(String cql, RowCallbackHandler rowCallbackHandler) {
        this.query(cql, rowCallbackHandler, null);
    }

    @Override
    public void query(String cql, RowCallbackHandler rowCallbackHandler, QueryOptions queryOptions) {
        this.process(this.doExecute(cql, queryOptions), rowCallbackHandler);
    }

    @Override
    public <T> List<T> query(String cql, RowMapper<T> rowMapper, QueryOptions queryOptions) {
        return this.process(this.doExecute(cql, queryOptions), rowMapper);
    }

    @Override
    public ResultSet query(String cql) {
        return this.query(cql, (QueryOptions)null);
    }

    @Override
    public ResultSet query(String cql, QueryOptions queryOptions) {
        return this.query(cql, RESULT_SET_RETURNING_EXTRACTOR, queryOptions);
    }

    @Override
    public <T> List<T> query(String cql, RowMapper<T> rowMapper) {
        return this.query(cql, rowMapper, null);
    }

    @Override
    public List<Map<String, Object>> queryForListOfMap(String cql) {
        return this.processListOfMap(this.doExecute(cql, null));
    }

    @Override
    public <T> List<T> queryForList(String cql, Class<T> elementType) {
        return this.processList(this.doExecute(cql, null), elementType);
    }

    @Override
    public Map<String, Object> queryForMap(String cql) {
        return this.processMap(this.doExecute(cql, null));
    }

    @Override
    public <T> T queryForObject(String cql, Class<T> requiredType) {
        return this.processOne(this.doExecute(cql, null), requiredType);
    }

    @Override
    public <T> T queryForObject(String cql, RowMapper<T> rowMapper) {
        return this.processOne(this.doExecute(cql, null), rowMapper);
    }

    protected ResultSet doExecute(String cql) {
        return this.doExecute(cql, null);
    }

    protected ResultSet doExecute(String cql, QueryOptions queryOptions) {
        return this.doExecute((Statement)CqlTemplate.addQueryOptions(new SimpleStatement(this.logCql(cql)), queryOptions));
    }

    protected ResultSet doExecute(final Statement statement) {
        return this.doExecute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) {
                CqlTemplate.this.logDebug("execute [{}]", new Object[]{statement});
                return session.execute(statement);
            }
        });
    }

    protected ResultSetFuture doExecuteAsync(final Statement statement) {
        return this.doExecute(new SessionCallback<ResultSetFuture>(){

            @Override
            public ResultSetFuture doInSession(Session session) {
                CqlTemplate.this.logDebug("async execute [{}]", new Object[]{statement});
                return session.executeAsync(statement);
            }
        });
    }

    protected Cancellable doExecuteAsync(Statement statement, AsynchronousQueryListener listener) {
        return this.doExecuteAsync(statement, listener, null);
    }

    protected Cancellable doExecuteAsync(final Statement statement, final AsynchronousQueryListener listener, final QueryOptions queryOptions) {
        return this.doExecute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session session) {
                CqlTemplate.this.logDebug("async execute [{}]", new Object[]{statement});
                final ResultSetFuture resultSetFuture = session.executeAsync(CqlTemplate.addQueryOptions(statement, queryOptions));
                if (listener != null) {
                    resultSetFuture.addListener(new Runnable(){

                        @Override
                        public void run() {
                            listener.onQueryComplete(resultSetFuture);
                        }
                    }, RUN_RUNNABLE_EXECUTOR);
                }
                return new ResultSetFutureCancellable(resultSetFuture);
            }
        });
    }

    protected Object firstColumnToObject(Row row) {
        Iterator columnDefinitions = row.getColumnDefinitions().iterator();
        return columnDefinitions.hasNext() ? this.columnToObject(row, (ColumnDefinitions.Definition)columnDefinitions.next()) : null;
    }

    <T> T columnToObject(Row row, ColumnDefinitions.Definition columnDefinition) {
        TypeCodec typeCodec = CodecRegistry.DEFAULT_INSTANCE.codecFor(columnDefinition.getType());
        return (T)typeCodec.deserialize(row.getBytesUnsafe(columnDefinition.getName()), ProtocolVersion.NEWEST_SUPPORTED);
    }

    protected Map<String, Object> toMap(Row row) {
        HashMap map = null;
        if (row != null) {
            ColumnDefinitions columns = row.getColumnDefinitions();
            map = new HashMap(columns.size());
            for (ColumnDefinitions.Definition columnDefinition : columns.asList()) {
                map.put(columnDefinition.getName(), this.columnToObject(row, columnDefinition));
            }
        }
        return map;
    }

    @Override
    public List<RingMember> describeRing() {
        return new ArrayList<RingMember>(this.describeRing(new RingMemberHostMapper()));
    }

    protected Set<Host> getHosts() {
        return this.doExecute(new SessionCallback<Set<Host>>(){

            @Override
            public Set<Host> doInSession(Session session) {
                return session.getCluster().getMetadata().getAllHosts();
            }
        });
    }

    @Override
    public <T> Collection<T> describeRing(HostMapper<T> hostMapper) {
        return hostMapper.mapHosts(this.getHosts());
    }

    @Override
    public ResultSetFuture executeAsynchronously(String cql) {
        return this.executeAsynchronously(cql, (QueryOptions)null);
    }

    @Override
    public ResultSetFuture executeAsynchronously(String cql, QueryOptions queryOptions) {
        return this.doExecuteAsync((Statement)CqlTemplate.addQueryOptions(new SimpleStatement(this.logCql(cql)), queryOptions));
    }

    @Override
    public Cancellable executeAsynchronously(String cql, Runnable listener) {
        return this.executeAsynchronously(cql, listener, RUN_RUNNABLE_EXECUTOR);
    }

    @Override
    public Cancellable executeAsynchronously(final String cql, final Runnable listener, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session session) {
                SimpleStatement statement = new SimpleStatement(CqlTemplate.this.logCql("async execute CQL [{}]", cql));
                ResultSetFuture resultSetFuture = session.executeAsync((Statement)statement);
                resultSetFuture.addListener(listener, executor);
                return new ResultSetFutureCancellable(resultSetFuture);
            }
        });
    }

    @Override
    public Cancellable executeAsynchronously(String cql, AsynchronousQueryListener listener) {
        return this.executeAsynchronously(cql, listener, RUN_RUNNABLE_EXECUTOR);
    }

    @Override
    public Cancellable executeAsynchronously(final String cql, final AsynchronousQueryListener listener, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session session) {
                SimpleStatement statement = new SimpleStatement(CqlTemplate.this.logCql("async execute CQL [{}]", cql));
                final ResultSetFuture resultSetFuture = session.executeAsync((Statement)statement);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        listener.onQueryComplete(resultSetFuture);
                    }
                };
                resultSetFuture.addListener(runnable, executor);
                return new ResultSetFutureCancellable(resultSetFuture);
            }
        });
    }

    @Override
    public ResultSetFuture executeAsynchronously(Statement statement) {
        return this.doExecuteAsync(statement);
    }

    @Override
    public Cancellable executeAsynchronously(Statement statement, Runnable listener) {
        return this.executeAsynchronously(statement, listener, RUN_RUNNABLE_EXECUTOR);
    }

    @Override
    public Cancellable executeAsynchronously(Statement statement, AsynchronousQueryListener listener) {
        return this.executeAsynchronously(statement, listener, RUN_RUNNABLE_EXECUTOR);
    }

    @Override
    public Cancellable executeAsynchronously(final Statement statement, final Runnable listener, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session session) {
                CqlTemplate.this.logDebug("executing [{}]", new Object[]{statement});
                ResultSetFuture resultSetFuture = session.executeAsync(statement);
                resultSetFuture.addListener(listener, executor);
                return new ResultSetFutureCancellable(resultSetFuture);
            }
        });
    }

    @Override
    public Cancellable executeAsynchronously(final Statement statement, final AsynchronousQueryListener listener, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session session) {
                CqlTemplate.this.logDebug("executing [{}]", new Object[]{statement});
                final ResultSetFuture resultSetFuture = session.executeAsync(statement);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        listener.onQueryComplete(resultSetFuture);
                    }
                };
                resultSetFuture.addListener(runnable, executor);
                return new ResultSetFutureCancellable(resultSetFuture);
            }
        });
    }

    @Override
    public void process(ResultSet resultSet, RowCallbackHandler rowCallbackHandler) {
        try {
            for (Row row : resultSet.all()) {
                rowCallbackHandler.processRow(row);
            }
        }
        catch (DriverException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> List<T> process(ResultSet resultSet, RowMapper<T> rowMapper) {
        try {
            List rows = resultSet.all();
            ArrayList<T> mappedRows = new ArrayList<T>(rows.size());
            int rowIndex = 0;
            for (Row row : rows) {
                mappedRows.add(rowMapper.mapRow(row, rowIndex++));
            }
            return mappedRows;
        }
        catch (DriverException dx) {
            throw this.translateExceptionIfPossible(dx);
        }
    }

    @Override
    public <T> T processOne(ResultSet resultSet, RowMapper<T> rowMapper) {
        Assert.notNull((Object)resultSet, (String)"ResultSet must not be null");
        Assert.notNull(rowMapper, (String)"RowMapper must not be null");
        try {
            Row row = resultSet.one();
            if (row == null) {
                throw new IncorrectResultSizeDataAccessException(1, 0);
            }
            if (!resultSet.isExhausted()) {
                throw new IncorrectResultSizeDataAccessException("ResultSet size exceeds 1", 1);
            }
            return rowMapper.mapRow(row, 0);
        }
        catch (DriverException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> T processOne(ResultSet resultSet, Class<T> requiredType) {
        Assert.notNull((Object)resultSet, (String)"ResultSet must not be null");
        try {
            Row row = resultSet.one();
            if (row == null) {
                throw new IncorrectResultSizeDataAccessException(1, 0);
            }
            if (!resultSet.isExhausted()) {
                throw new IncorrectResultSizeDataAccessException("ResultSet size exceeds 1", 1);
            }
            return requiredType.cast(this.firstColumnToObject(row));
        }
        catch (DriverException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public Map<String, Object> processMap(ResultSet resultSet) {
        return resultSet != null ? this.toMap(resultSet.one()) : null;
    }

    @Override
    public <T> List<T> processList(ResultSet resultSet, Class<T> elementType) {
        List rows = resultSet.all();
        ArrayList<T> list = new ArrayList<T>(rows.size());
        for (Row row : rows) {
            list.add(elementType.cast(this.firstColumnToObject(row)));
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> processListOfMap(ResultSet resultSet) {
        List rows = resultSet.all();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(rows.size());
        for (Row row : rows) {
            list.add(this.toMap(row));
        }
        return list;
    }

    protected RuntimeException translateExceptionIfPossible(Throwable t) {
        return CqlTemplate.translateExceptionIfPossible(t, this.getExceptionTranslator());
    }

    protected static RuntimeException translateExceptionIfPossible(Throwable t, PersistenceExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)t, (String)"Throwble must not be null");
        Assert.notNull((Object)exceptionTranslator, (String)"PersistenceExceptionTranslator must not be null");
        return t instanceof RuntimeException ? CqlTemplate.potentiallyConvertRuntimeException((RuntimeException)t, exceptionTranslator) : new CassandraUncategorizedDataAccessException("Caught Uncategorized Exception", t);
    }

    private static RuntimeException potentiallyConvertRuntimeException(RuntimeException e, PersistenceExceptionTranslator exceptionTranslator) {
        DataAccessException resolved = exceptionTranslator.translateExceptionIfPossible(e);
        return resolved != null ? resolved : e;
    }

    @Override
    public <T> T execute(PreparedStatementCreator preparedStatementCreator, PreparedStatementCallback<T> preparedStatementCallback) {
        try {
            PreparedStatement preparedStatement = preparedStatementCreator.createPreparedStatement(this.getSession());
            this.logDebug("executing [{}]", preparedStatement);
            return preparedStatementCallback.doInPreparedStatement(preparedStatement);
        }
        catch (DriverException dx) {
            throw this.translateExceptionIfPossible(dx);
        }
    }

    @Override
    public <T> T execute(String cql, PreparedStatementCallback<T> callback) {
        return this.execute(new CachedPreparedStatementCreator(this.logCql(cql)), callback);
    }

    @Override
    public <T> T query(PreparedStatementCreator preparedStatementCreator, ResultSetExtractor<T> resultSetExtractor) {
        return this.query(preparedStatementCreator, resultSetExtractor, null);
    }

    @Override
    public <T> T query(PreparedStatementCreator preparedStatementCreator, ResultSetExtractor<T> resultSetExtractor, QueryOptions queryOptions) {
        return this.query(preparedStatementCreator, null, resultSetExtractor, queryOptions);
    }

    @Override
    public void query(PreparedStatementCreator preparedStatementCreator, RowCallbackHandler rowCallbackHandler) {
        this.query(preparedStatementCreator, rowCallbackHandler, null);
    }

    @Override
    public void query(PreparedStatementCreator preparedStatementCreator, RowCallbackHandler rowCallbackHandler, QueryOptions queryOptions) {
        this.query(preparedStatementCreator, null, rowCallbackHandler, queryOptions);
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator preparedStatementCreator, RowMapper<T> rowMapper) {
        return this.query(preparedStatementCreator, rowMapper, null);
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator preparedStatementCreator, RowMapper<T> rowMapper, QueryOptions queryOptions) {
        return this.query(preparedStatementCreator, null, rowMapper, queryOptions);
    }

    @Override
    public <T> T query(String cql, PreparedStatementBinder preparedStatementBinder, ResultSetExtractor<T> resultSetExtractor) {
        return this.query(cql, preparedStatementBinder, resultSetExtractor, null);
    }

    @Override
    public <T> T query(String cql, PreparedStatementBinder preparedStatementBinder, ResultSetExtractor<T> resultSetExtractor, QueryOptions queryOptions) {
        return this.query((PreparedStatementCreator)new CachedPreparedStatementCreator(this.logCql(cql)), preparedStatementBinder, resultSetExtractor, queryOptions);
    }

    @Override
    public void query(String cql, PreparedStatementBinder preparedStatementBinder, RowCallbackHandler rowCallbackHandler) {
        this.query(cql, preparedStatementBinder, rowCallbackHandler, null);
    }

    @Override
    public void query(String cql, PreparedStatementBinder preparedStatementBinder, RowCallbackHandler rowCallbackHandler, QueryOptions queryOptions) {
        this.query((PreparedStatementCreator)new CachedPreparedStatementCreator(this.logCql(cql)), preparedStatementBinder, rowCallbackHandler, queryOptions);
    }

    @Override
    public <T> List<T> query(String cql, PreparedStatementBinder preparedStatementBinder, RowMapper<T> rowMapper) {
        return this.query(cql, preparedStatementBinder, rowMapper, null);
    }

    @Override
    public <T> List<T> query(String cql, PreparedStatementBinder preparedStatementBinder, RowMapper<T> rowMapper, QueryOptions queryOptions) {
        return this.query((PreparedStatementCreator)new CachedPreparedStatementCreator(this.logCql(cql)), preparedStatementBinder, rowMapper, queryOptions);
    }

    @Override
    public void ingest(String cql, RowIterator rowIterator, WriteOptions options) {
        CachedPreparedStatementCreator cachedPreparedStatementCreator = new CachedPreparedStatementCreator(this.logCql(cql));
        PreparedStatement preparedStatement = CqlTemplate.addPreparedStatementOptions(cachedPreparedStatementCreator.createPreparedStatement(this.getSession()), options);
        Session session = this.getSession();
        while (rowIterator.hasNext()) {
            session.executeAsync((Statement)preparedStatement.bind(rowIterator.next()));
        }
    }

    @Override
    public void ingest(String cql, RowIterator rowIterator) {
        this.ingest(cql, rowIterator, null);
    }

    @Override
    public void ingest(String cql, List<List<?>> rows) {
        this.ingest(cql, rows, null);
    }

    @Override
    public void ingest(String cql, final List<List<?>> rows, WriteOptions writeOptions) {
        Assert.notNull(rows, (String)"Rows must not be null");
        Assert.notEmpty(rows, (String)"Rows must not be empty");
        this.ingest(cql, new RowIterator(){
            Iterator<List<?>> rowIterator;
            {
                this.rowIterator = rows.iterator();
            }

            @Override
            public Object[] next() {
                return this.rowIterator.next().toArray();
            }

            @Override
            public boolean hasNext() {
                return this.rowIterator.hasNext();
            }
        }, writeOptions);
    }

    @Override
    public void ingest(String cql, Object[][] rows) {
        this.ingest(cql, rows, null);
    }

    @Override
    public void ingest(String cql, final Object[][] rows, WriteOptions writeOptions) {
        this.ingest(cql, new RowIterator(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < rows.length;
            }

            @Override
            public Object[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements");
                }
                return rows[this.index++];
            }
        }, writeOptions);
    }

    @Override
    public void truncate(String tableName) {
        this.truncate(CqlIdentifier.cqlId(tableName));
    }

    @Override
    public void truncate(CqlIdentifier tableName) {
        this.doExecute((Statement)QueryBuilder.truncate((String)this.logCql(tableName.toCql())));
    }

    @Override
    public <T> T query(PreparedStatementCreator preparedStatementCreator, PreparedStatementBinder preparedStatementBinder, ResultSetExtractor<T> resultSetExtractor) {
        return this.query(preparedStatementCreator, preparedStatementBinder, resultSetExtractor, null);
    }

    @Override
    public <T> T query(PreparedStatementCreator preparedStatementCreator, final PreparedStatementBinder preparedStatementBinder, final ResultSetExtractor<T> resultSetExtractor, final QueryOptions queryOptions) {
        Assert.notNull(resultSetExtractor, (String)"ResultSetExtractor must not be null");
        return this.execute(preparedStatementCreator, new PreparedStatementCallback<T>(){

            @Override
            public T doInPreparedStatement(PreparedStatement preparedStatement) {
                BoundStatement boundStatement = preparedStatementBinder != null ? preparedStatementBinder.bindValues(preparedStatement) : preparedStatement.bind();
                return resultSetExtractor.extractData(CqlTemplate.this.doExecute((Statement)CqlTemplate.addQueryOptions(boundStatement, queryOptions)));
            }
        });
    }

    @Override
    public void query(PreparedStatementCreator preparedStatementCreator, final PreparedStatementBinder preparedStatementBinder, final RowCallbackHandler rowCallbackHandler, final QueryOptions queryOptions) {
        Assert.notNull((Object)rowCallbackHandler, (String)"RowCallbackHandler must not be null");
        this.execute(preparedStatementCreator, new PreparedStatementCallback<Object>(){

            @Override
            public Object doInPreparedStatement(PreparedStatement preparedStatement) {
                BoundStatement boundStatement = preparedStatementBinder != null ? preparedStatementBinder.bindValues(preparedStatement) : preparedStatement.bind();
                CqlTemplate.this.process(CqlTemplate.this.doExecute((Statement)CqlTemplate.addQueryOptions(boundStatement, queryOptions)), rowCallbackHandler);
                return null;
            }
        });
    }

    @Override
    public void query(PreparedStatementCreator preparedStatementCreator, PreparedStatementBinder preparedStatementBinder, RowCallbackHandler rowCallbackHandler) {
        this.query(preparedStatementCreator, preparedStatementBinder, rowCallbackHandler, null);
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator preparedStatementCreator, final PreparedStatementBinder preparedStatementBinder, final RowMapper<T> rowMapper, final QueryOptions queryOptions) {
        Assert.notNull(rowMapper, (String)"RowMapper must not be null");
        return (List)this.execute(preparedStatementCreator, new PreparedStatementCallback<List<T>>(){

            @Override
            public List<T> doInPreparedStatement(PreparedStatement preparedStatement) {
                BoundStatement boundStatement = preparedStatementBinder != null ? preparedStatementBinder.bindValues(preparedStatement) : preparedStatement.bind();
                return CqlTemplate.this.process(CqlTemplate.this.doExecute((Statement)CqlTemplate.addQueryOptions(boundStatement, queryOptions)), rowMapper);
            }
        });
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator preparedStatementCreator, PreparedStatementBinder preparedStatementBinder, RowMapper<T> rowMapper) {
        return this.query(preparedStatementCreator, preparedStatementBinder, rowMapper, null);
    }

    @Override
    public ResultSet execute(final AlterKeyspaceSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) {
                return session.execute(CqlTemplate.this.logCql(AlterKeyspaceCqlGenerator.toCql(specification)));
            }
        });
    }

    @Override
    public ResultSet execute(final CreateKeyspaceSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) {
                return session.execute(CqlTemplate.this.logCql(CreateKeyspaceCqlGenerator.toCql(specification)));
            }
        });
    }

    @Override
    public ResultSet execute(final DropKeyspaceSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) {
                return session.execute(CqlTemplate.this.logCql(DropKeyspaceCqlGenerator.toCql(specification)));
            }
        });
    }

    @Override
    public ResultSet execute(final AlterTableSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) {
                return session.execute(CqlTemplate.this.logCql(AlterTableCqlGenerator.toCql(specification)));
            }
        });
    }

    @Override
    public ResultSet execute(final CreateTableSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) {
                return session.execute(CqlTemplate.this.logCql(CreateTableCqlGenerator.toCql(specification)));
            }
        });
    }

    @Override
    public ResultSet execute(final DropTableSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) {
                return session.execute(CqlTemplate.this.logCql(DropTableCqlGenerator.toCql(specification)));
            }
        });
    }

    @Override
    public ResultSet execute(final CreateIndexSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) {
                return session.execute(CqlTemplate.this.logCql(CreateIndexCqlGenerator.toCql(specification)));
            }
        });
    }

    @Override
    public ResultSet execute(final DropIndexSpecification specification) {
        return this.execute(new SessionCallback<ResultSet>(){

            @Override
            public ResultSet doInSession(Session session) {
                return session.execute(CqlTemplate.this.logCql(DropIndexCqlGenerator.toCql(specification)));
            }
        });
    }

    @Override
    public void execute(Batch batch) {
        this.doExecute((Statement)batch);
    }

    @Override
    public void execute(Delete delete) {
        this.doExecute((Statement)delete);
    }

    @Override
    public void execute(Insert insert) {
        this.doExecute((Statement)insert);
    }

    @Override
    public void execute(Truncate truncate) {
        this.doExecute((Statement)truncate);
    }

    @Override
    public void execute(Update update) {
        this.doExecute((Statement)update);
    }

    @Override
    public long count(String tableName) {
        return this.count(CqlIdentifier.cqlId(tableName));
    }

    @Override
    public long count(CqlIdentifier tableName) {
        return this.selectCount(QueryBuilder.select().countAll().from(tableName.toCql()));
    }

    protected long selectCount(final Select select) {
        return this.query(select, new ResultSetExtractor<Long>(){

            @Override
            public Long extractData(ResultSet resultSet) {
                Row row = resultSet.one();
                if (row == null) {
                    throw new InvalidDataAccessApiUsageException(String.format("count query [%1$s] did not return any results", select));
                }
                return row.getLong(0);
            }
        });
    }

    @Override
    public ResultSetFuture executeAsynchronously(Batch batch) {
        return this.doExecuteAsync((Statement)batch);
    }

    @Override
    public ResultSetFuture executeAsynchronously(Delete delete) {
        return this.doExecuteAsync((Statement)delete);
    }

    @Override
    public ResultSetFuture executeAsynchronously(Insert insert) {
        return this.doExecuteAsync((Statement)insert);
    }

    @Override
    public ResultSetFuture executeAsynchronously(Truncate truncate) {
        return this.doExecuteAsync((Statement)truncate);
    }

    @Override
    public ResultSetFuture executeAsynchronously(Update update) {
        return this.doExecuteAsync((Statement)update);
    }

    @Override
    public Cancellable executeAsynchronously(Batch batch, AsynchronousQueryListener listener) {
        return this.doExecuteAsync((Statement)batch, listener);
    }

    @Override
    public Cancellable executeAsynchronously(Delete delete, AsynchronousQueryListener listener) {
        return this.doExecuteAsync((Statement)delete, listener);
    }

    @Override
    public Cancellable executeAsynchronously(Insert insert, AsynchronousQueryListener listener) {
        return this.doExecuteAsync((Statement)insert, listener);
    }

    @Override
    public Cancellable executeAsynchronously(Truncate truncate, AsynchronousQueryListener listener) {
        return this.doExecuteAsync((Statement)truncate, listener);
    }

    @Override
    public Cancellable executeAsynchronously(Update update, AsynchronousQueryListener listener) {
        return this.doExecuteAsync((Statement)update, listener);
    }

    @Override
    public ResultSetFuture queryAsynchronously(final Select select) {
        return this.execute(new SessionCallback<ResultSetFuture>(){

            @Override
            public ResultSetFuture doInSession(Session session) {
                CqlTemplate.this.logDebug("async query [{}]", new Object[]{select});
                return session.executeAsync((Statement)select);
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(Select select, AsynchronousQueryListener listener) {
        return this.queryAsynchronously(select, listener, RUN_RUNNABLE_EXECUTOR);
    }

    @Override
    public Cancellable queryAsynchronously(final Select select, final AsynchronousQueryListener listener, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session session) {
                CqlTemplate.this.logDebug("async query [{}]", new Object[]{select});
                final ResultSetFuture resultSetFuture = session.executeAsync((Statement)select);
                Runnable wrapper = new Runnable(){

                    @Override
                    public void run() {
                        listener.onQueryComplete(resultSetFuture);
                    }
                };
                resultSetFuture.addListener(wrapper, executor);
                return new ResultSetFutureCancellable(resultSetFuture);
            }
        });
    }

    @Override
    public Cancellable queryAsynchronously(Select select, Runnable listener) {
        return this.queryAsynchronously(select, listener, RUN_RUNNABLE_EXECUTOR);
    }

    @Override
    public Cancellable queryAsynchronously(final Select select, final Runnable listener, final Executor executor) {
        return this.execute(new SessionCallback<Cancellable>(){

            @Override
            public Cancellable doInSession(Session session) {
                CqlTemplate.this.logDebug("async query [{}]", new Object[]{select});
                ResultSetFuture resultSetFuture = session.executeAsync((Statement)select);
                resultSetFuture.addListener(listener, executor);
                return new ResultSetFutureCancellable(resultSetFuture);
            }
        });
    }

    @Override
    public ResultSet query(Select select) {
        return this.query(select, RESULT_SET_RETURNING_EXTRACTOR);
    }

    @Override
    public <T> T query(Select select, ResultSetExtractor<T> resultSetExtractor) {
        Assert.notNull((Object)select);
        return resultSetExtractor.extractData(this.doExecute((Statement)select));
    }

    @Override
    public void query(Select select, RowCallbackHandler rowCallbackHandler) {
        this.process(this.doExecute((Statement)select), rowCallbackHandler);
    }

    @Override
    public <T> List<T> query(Select select, RowMapper<T> rowMapper) {
        return this.process(this.doExecute((Statement)select), rowMapper);
    }

    @Override
    public <T> T queryForObject(Select select, RowMapper<T> rowMapper) {
        return this.processOne(this.doExecute((Statement)select), rowMapper);
    }

    @Override
    public <T> T queryForObject(Select select, Class<T> requiredType) {
        return this.processOne(this.doExecute((Statement)select), requiredType);
    }

    @Override
    public Map<String, Object> queryForMap(Select select) {
        return this.processMap(this.doExecute((Statement)select));
    }

    @Override
    public <T> List<T> queryForList(Select select, Class<T> elementType) {
        return this.processList(this.doExecute((Statement)select), elementType);
    }

    @Override
    public List<Map<String, Object>> queryForListOfMap(Select select) {
        return this.processListOfMap(this.doExecute((Statement)select));
    }

    @Override
    public <T> Cancellable queryForListAsynchronously(Select select, final Class<T> requiredType, final QueryForListListener<T> listener) {
        Assert.notNull((Object)select, (String)"Select must not be null");
        Assert.notNull(requiredType, (String)"Required type must not be null");
        Assert.notNull(listener, (String)"Listener must not be null");
        return this.doExecuteAsync((Statement)select, new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processList(resultSetFuture.getUninterruptibly(), requiredType));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public <T> Cancellable queryForListAsynchronously(String select, final Class<T> requiredType, final QueryForListListener<T> listener) {
        Assert.hasText((String)select, (String)"Select must not be null");
        Assert.notNull(requiredType, (String)"Required type must not be null");
        Assert.notNull(listener, (String)"Listener must not be null");
        return this.doExecuteAsync((Statement)new SimpleStatement(this.logCql(select)), new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processList(resultSetFuture.getUninterruptibly(), requiredType));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public Cancellable queryForListOfMapAsynchronously(Select select, final QueryForListListener<Map<String, Object>> listener) {
        return this.doExecuteAsync((Statement)select, new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processListOfMap(resultSetFuture.getUninterruptibly()));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public Cancellable queryForListOfMapAsynchronously(String cql, QueryForListListener<Map<String, Object>> listener) {
        return this.queryForListOfMapAsynchronously(cql, listener, null);
    }

    @Override
    public Cancellable queryForListOfMapAsynchronously(String cql, final QueryForListListener<Map<String, Object>> listener, QueryOptions queryOptions) {
        return this.doExecuteAsync((Statement)new SimpleStatement(this.logCql(cql)), new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processListOfMap(rsf.getUninterruptibly()));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        }, queryOptions);
    }

    @Override
    public Cancellable queryForMapAsynchronously(String cql, QueryForMapListener listener) {
        return this.queryForMapAsynchronously(cql, listener, null);
    }

    @Override
    public Cancellable queryForMapAsynchronously(String cql, final QueryForMapListener listener, QueryOptions queryOptions) {
        return this.doExecuteAsync((Statement)new SimpleStatement(this.logCql(cql)), new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processMap(resultSetFuture.getUninterruptibly()));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        }, queryOptions);
    }

    @Override
    public Cancellable queryForMapAsynchronously(Select select, final QueryForMapListener listener) {
        return this.doExecuteAsync((Statement)select, new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processMap(resultSetFuture.getUninterruptibly()));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(Select select, final Class<T> requiredType, final QueryForObjectListener<T> listener) {
        return this.doExecuteAsync((Statement)select, new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processOne(resultSetFuture.getUninterruptibly(), requiredType));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(String cql, Class<T> requiredType, QueryForObjectListener<T> listener) {
        return this.queryForObjectAsynchronously(cql, requiredType, listener, null);
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(String cql, final Class<T> requiredType, final QueryForObjectListener<T> listener, QueryOptions options) {
        return this.doExecuteAsync((Statement)new SimpleStatement(this.logCql(cql)), new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processOne(resultSetFuture.getUninterruptibly(), requiredType));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        }, options);
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(String cql, RowMapper<T> rowMapper, QueryForObjectListener<T> listener) {
        return this.queryForObjectAsynchronously(cql, rowMapper, listener, null);
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(String cql, final RowMapper<T> rowMapper, final QueryForObjectListener<T> listener, QueryOptions options) {
        return this.doExecuteAsync((Statement)new SimpleStatement(this.logCql(cql)), new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processOne(resultSetFuture.getUninterruptibly(), rowMapper));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        }, options);
    }

    @Override
    public <T> Cancellable queryForObjectAsynchronously(Select select, final RowMapper<T> rowMapper, final QueryForObjectListener<T> listener) {
        return this.doExecuteAsync((Statement)select, new AsynchronousQueryListener(){

            @Override
            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    listener.onQueryComplete(CqlTemplate.this.processOne(resultSetFuture.getUninterruptibly(), rowMapper));
                }
                catch (Exception e) {
                    listener.onException(CqlTemplate.this.translateExceptionIfPossible(e));
                }
            }
        });
    }

    @Override
    public ResultSet getResultSetUninterruptibly(ResultSetFuture resultSetFuture) {
        return this.getResultSetUninterruptibly(resultSetFuture, 0L, null);
    }

    @Override
    public ResultSet getResultSetUninterruptibly(ResultSetFuture resultSetFuture, long milliseconds) {
        return this.getResultSetUninterruptibly(resultSetFuture, milliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public ResultSet getResultSetUninterruptibly(ResultSetFuture resultSetFuture, long timeout, TimeUnit timeUnit) {
        try {
            timeUnit = timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS;
            return timeout > 0L ? resultSetFuture.getUninterruptibly(timeout, timeUnit) : resultSetFuture.getUninterruptibly();
        }
        catch (Exception e) {
            throw this.translateExceptionIfPossible(e);
        }
    }
}

