/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config.xml;

import java.util.ArrayList;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cassandra.config.CassandraCqlClusterFactoryBean;
import org.springframework.cassandra.config.KeyspaceActionSpecificationFactoryBean;
import org.springframework.cassandra.config.KeyspaceAttributes;
import org.springframework.cassandra.config.MultiLevelSetFlattenerFactoryBean;
import org.springframework.cassandra.config.PoolingOptionsFactoryBean;
import org.springframework.cassandra.config.SocketOptionsFactoryBean;
import org.springframework.cassandra.config.xml.ParsingUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CassandraCqlClusterParser
extends AbstractBeanDefinitionParser {
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "cassandraCluster";
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CassandraCqlClusterFactoryBean.class);
        builder.setLazyInit(parserContext.isDefaultLazyInit());
        builder.getRawBeanDefinition().setDestroyMethodName("destroy");
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        if (parserContext.isNested()) {
            builder.setScope(parserContext.getContainingBeanDefinition().getScope());
        }
        this.doParse(element, parserContext, builder);
        return builder.getBeanDefinition();
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParsingUtils.addOptionalPropertyReference(builder, "addressTranslator", element, "address-translator-ref");
        ParsingUtils.addOptionalPropertyReference(builder, "authProvider", element, "auth-info-provider-ref");
        ParsingUtils.addOptionalPropertyReference(builder, "clusterBuilderConfigurer", element, "cluster-builder-configurer-ref");
        ParsingUtils.addOptionalPropertyReference(builder, "hostStateListener", element, "host-state-listener-ref");
        ParsingUtils.addOptionalPropertyReference(builder, "latencyTracker", element, "latency-tracker-ref");
        ParsingUtils.addOptionalPropertyReference(builder, "loadBalancingPolicy", element, "load-balancing-policy-ref");
        ParsingUtils.addOptionalPropertyReference(builder, "reconnectionPolicy", element, "reconnection-policy-ref");
        ParsingUtils.addOptionalPropertyReference(builder, "retryPolicy", element, "retry-policy-ref");
        ParsingUtils.addOptionalPropertyReference(builder, "speculativeExecutionPolicy", element, "speculative-execution-policy-ref");
        ParsingUtils.addOptionalPropertyReference(builder, "sslOptions", element, "ssl-options-ref");
        ParsingUtils.addOptionalPropertyReference(builder, "timestampGenerator", element, "timestamp-generator-ref");
        ParsingUtils.addOptionalPropertyValue(builder, "clusterName", element, "cluster-name");
        ParsingUtils.addOptionalPropertyValue(builder, "contactPoints", element, "contact-points");
        ParsingUtils.addOptionalPropertyValue(builder, "compressionType", element, "compression");
        ParsingUtils.addOptionalPropertyValue(builder, "jmxReportingEnabled", element, "jmx-reporting-enabled");
        ParsingUtils.addOptionalPropertyValue(builder, "maxSchemaAgreementWaitSeconds", element, "max-schema-agreement-wait-seconds");
        ParsingUtils.addOptionalPropertyValue(builder, "metricsEnabled", element, "metrics-enabled");
        ParsingUtils.addOptionalPropertyValue(builder, "password", element, "password");
        ParsingUtils.addOptionalPropertyValue(builder, "port", element, "port");
        ParsingUtils.addOptionalPropertyValue(builder, "sslEnabled", element, "ssl-enabled");
        ParsingUtils.addOptionalPropertyValue(builder, "username", element, "username");
        this.parseChildElements(element, parserContext, builder);
    }

    protected void parseChildElements(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ManagedSet keyspaceActionSpecificationBeanDefinitions = new ManagedSet();
        ArrayList<String> startupScripts = new ArrayList<String>();
        ArrayList<String> shutdownScripts = new ArrayList<String>();
        BeanDefinitionBuilder poolingOptionsBuilder = BeanDefinitionBuilder.genericBeanDefinition(PoolingOptionsFactoryBean.class);
        ParsingUtils.addOptionalPropertyReference(poolingOptionsBuilder, "initializationExecutor", element, "initialization-executor-ref");
        ParsingUtils.addOptionalPropertyValue(poolingOptionsBuilder, "heartbeatIntervalSeconds", element, "heartbeat-interval-seconds");
        ParsingUtils.addOptionalPropertyValue(poolingOptionsBuilder, "idleTimeoutSeconds", element, "idle-timeout-seconds");
        ParsingUtils.addOptionalPropertyValue(poolingOptionsBuilder, "poolTimeoutMilliseconds", element, "pool-timeout-milliseconds");
        for (Element subElement : DomUtils.getChildElements((Element)element)) {
            String name = subElement.getLocalName();
            if ("keyspace".equals(name)) {
                keyspaceActionSpecificationBeanDefinitions.add((Object)this.newKeyspaceActionSpecificationBeanDefinition(subElement, parserContext));
                continue;
            }
            if ("local-pooling-options".equals(name)) {
                this.parseLocalPoolingOptions(subElement, poolingOptionsBuilder);
                continue;
            }
            if ("remote-pooling-options".equals(name)) {
                this.parseRemotePoolingOptions(subElement, poolingOptionsBuilder);
                continue;
            }
            if ("socket-options".equals(name)) {
                builder.addPropertyValue("socketOptions", (Object)this.newSocketOptionsBeanDefinition(subElement, parserContext));
                continue;
            }
            if ("startup-cql".equals(name)) {
                startupScripts.add(this.parseScript(subElement));
                continue;
            }
            if (!"shutdown-cql".equals(name)) continue;
            shutdownScripts.add(this.parseScript(subElement));
        }
        builder.addPropertyValue("keyspaceSpecifications", this.newKeyspaceSetFlattenerBeanDefinition(element, parserContext, (ManagedSet<BeanDefinition>)keyspaceActionSpecificationBeanDefinitions));
        builder.addPropertyValue("poolingOptions", (Object)ParsingUtils.getSourceBeanDefinition(poolingOptionsBuilder, parserContext, element));
        builder.addPropertyValue("startupScripts", startupScripts);
        builder.addPropertyValue("shutdownScripts", shutdownScripts);
    }

    BeanDefinition newKeyspaceActionSpecificationBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(KeyspaceActionSpecificationFactoryBean.class);
        ParsingUtils.addRequiredPropertyValue(builder, "replicationStrategy", KeyspaceAttributes.DEFAULT_REPLICATION_STRATEGY.name());
        ParsingUtils.addRequiredPropertyValue(builder, "replicationFactor", String.valueOf(1L));
        ParsingUtils.addRequiredPropertyValue(builder, "name", element, "name");
        ParsingUtils.addOptionalPropertyValue(builder, "durableWrites", element, "durable-writes", "false");
        ParsingUtils.addRequiredPropertyValue(builder, "action", element, "action");
        this.parseReplication(DomUtils.getChildElementByTagName((Element)element, (String)"replication"), builder);
        return ParsingUtils.getSourceBeanDefinition(builder, parserContext, element);
    }

    void parseReplication(Element element, BeanDefinitionBuilder builder) {
        ManagedList networkTopologyDataCenters = new ManagedList();
        ManagedList networkTopologyReplicationFactors = new ManagedList();
        if (element != null) {
            ParsingUtils.addOptionalPropertyValue(builder, "replicationStrategy", element, "class", KeyspaceAttributes.DEFAULT_REPLICATION_STRATEGY.name());
            ParsingUtils.addOptionalPropertyValue(builder, "replicationFactor", element, "replication-factor", String.valueOf(1L));
            for (Element dataCenter : DomUtils.getChildElementsByTagName((Element)element, (String)"data-center")) {
                networkTopologyDataCenters.add((Object)dataCenter.getAttribute("name"));
                networkTopologyReplicationFactors.add((Object)dataCenter.getAttribute("replication-factor"));
            }
        }
        builder.addPropertyValue("networkTopologyDataCenters", (Object)networkTopologyDataCenters);
        builder.addPropertyValue("networkTopologyReplicationFactors", (Object)networkTopologyReplicationFactors);
    }

    Object newKeyspaceSetFlattenerBeanDefinition(Element element, ParserContext parserContext, ManagedSet<BeanDefinition> keyspaceActionSpecificationBeanDefinitions) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MultiLevelSetFlattenerFactoryBean.class);
        builder.addPropertyValue("multiLevelSet", keyspaceActionSpecificationBeanDefinitions);
        return ParsingUtils.getSourceBeanDefinition(builder, parserContext, element);
    }

    void parseLocalPoolingOptions(Element element, BeanDefinitionBuilder builder) {
        ParsingUtils.addOptionalPropertyValue(builder, "localCoreConnections", element, "core-connections", null);
        ParsingUtils.addOptionalPropertyValue(builder, "localMaxConnections", element, "max-connections", null);
        ParsingUtils.addOptionalPropertyValue(builder, "localMaxSimultaneousRequests", element, "max-simultaneous-requests", null);
        ParsingUtils.addOptionalPropertyValue(builder, "localMinSimultaneousRequests", element, "min-simultaneous-requests", null);
    }

    void parseRemotePoolingOptions(Element element, BeanDefinitionBuilder builder) {
        ParsingUtils.addOptionalPropertyValue(builder, "remoteCoreConnections", element, "core-connections", null);
        ParsingUtils.addOptionalPropertyValue(builder, "remoteMaxConnections", element, "max-connections", null);
        ParsingUtils.addOptionalPropertyValue(builder, "remoteMaxSimultaneousRequests", element, "max-simultaneous-requests", null);
        ParsingUtils.addOptionalPropertyValue(builder, "remoteMinSimultaneousRequests", element, "min-simultaneous-requests", null);
    }

    String parseScript(Element element) {
        return element.getTextContent();
    }

    BeanDefinition newSocketOptionsBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SocketOptionsFactoryBean.class);
        ParsingUtils.addOptionalPropertyValue(builder, "connectTimeoutMillis", element, "connect-timeout-millis");
        ParsingUtils.addOptionalPropertyValue(builder, "keepAlive", element, "keep-alive");
        ParsingUtils.addOptionalPropertyValue(builder, "readTimeoutMillis", element, "read-timeout-millis");
        ParsingUtils.addOptionalPropertyValue(builder, "receiveBufferSize", element, "receive-buffer-size");
        ParsingUtils.addOptionalPropertyValue(builder, "reuseAddress", element, "reuse-address");
        ParsingUtils.addOptionalPropertyValue(builder, "sendBufferSize", element, "send-buffer-size");
        ParsingUtils.addOptionalPropertyValue(builder, "soLinger", element, "so-linger");
        ParsingUtils.addOptionalPropertyValue(builder, "tcpNoDelay", element, "tcp-no-delay");
        return ParsingUtils.getSourceBeanDefinition(builder, parserContext, element);
    }
}

