/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cassandra.core.CqlOperations;
import org.springframework.cassandra.core.CqlTemplate;
import org.springframework.cassandra.support.CassandraExceptionTranslator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CassandraCqlSessionFactoryBean
implements FactoryBean<Session>,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    private Cluster cluster;
    private List<String> startupScripts = Collections.emptyList();
    private List<String> shutdownScripts = Collections.emptyList();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final PersistenceExceptionTranslator exceptionTranslator = new CassandraExceptionTranslator();
    private Session session;
    private String keyspaceName;

    public Session getObject() {
        return this.session;
    }

    public Class<? extends Session> getObjectType() {
        return this.session != null ? this.session.getClass() : Session.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.session = this.connect(this.getKeyspaceName());
        this.executeScripts(this.getStartupScripts());
    }

    Session connect(String keyspaceName) {
        return StringUtils.hasText((String)keyspaceName) ? this.getCluster().connect(keyspaceName) : this.getCluster().connect();
    }

    public void destroy() throws Exception {
        this.executeScripts(this.getShutdownScripts());
        this.getSession().close();
    }

    protected void executeScripts(List<String> scripts) {
        if (!CollectionUtils.isEmpty(scripts)) {
            CqlOperations template = this.newCqlOperations(this.getSession());
            for (String script : scripts) {
                this.logger.info("executing raw CQL [{}]", (Object)script);
                template.execute(script);
            }
        }
    }

    CqlOperations newCqlOperations(Session session) {
        return new CqlTemplate(session);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException e) {
        return this.exceptionTranslator.translateExceptionIfPossible(e);
    }

    public boolean isConnected() {
        Session session = this.getObject();
        return session != null && !session.isClosed();
    }

    public void setCluster(Cluster cluster) {
        Assert.notNull((Object)cluster, (String)"Cluster must not be null");
        this.cluster = cluster;
    }

    protected Cluster getCluster() {
        Assert.state((this.cluster != null ? 1 : 0) != 0, (String)"Cluster was not properly initialized");
        return this.cluster;
    }

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    protected String getKeyspaceName() {
        return this.keyspaceName;
    }

    protected Session getSession() {
        Session session = this.getObject();
        Assert.state((session != null ? 1 : 0) != 0, (String)"Session was not properly initialized");
        return session;
    }

    public void setStartupScripts(List<String> scripts) {
        this.startupScripts = scripts != null ? new ArrayList<String>(scripts) : Collections.emptyList();
    }

    public List<String> getStartupScripts() {
        return Collections.unmodifiableList(this.startupScripts);
    }

    public void setShutdownScripts(List<String> scripts) {
        this.shutdownScripts = scripts != null ? new ArrayList<String>(scripts) : Collections.emptyList();
    }

    public List<String> getShutdownScripts() {
        return Collections.unmodifiableList(this.shutdownScripts);
    }
}

