/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.zookeeper.KeeperException;
import org.springframework.cloud.zookeeper.config.AbstractZookeeperPropertySource;
import org.springframework.context.Lifecycle;

public class ZookeeperTreeCachePropertySource
extends AbstractZookeeperPropertySource
implements Lifecycle {
    private static final Log log = LogFactory.getLog(ZookeeperTreeCachePropertySource.class);
    private TreeCache cache;
    private boolean running;

    public ZookeeperTreeCachePropertySource(String context, CuratorFramework source) {
        super(context, source);
    }

    public void start() {
        try {
            this.cache = TreeCache.newBuilder((CuratorFramework)((CuratorFramework)this.source), (String)this.getContext()).build();
            this.cache.start();
            this.running = true;
        }
        catch (KeeperException.NoNodeException e) {
        }
        catch (Exception e) {
            log.error((Object)"Error initializing ZookeperPropertySource", (Throwable)e);
        }
    }

    public Object getProperty(String name) {
        String fullPath = this.getContext() + "/" + name.replace(".", "/");
        byte[] bytes = null;
        ChildData data = this.cache.getCurrentData(fullPath);
        if (data != null) {
            bytes = data.getData();
        }
        if (bytes == null) {
            return null;
        }
        return new String(bytes, Charset.forName("UTF-8"));
    }

    public String[] getPropertyNames() {
        ArrayList<String> keys = new ArrayList<String>();
        this.findKeys(keys, this.getContext());
        return keys.toArray(new String[0]);
    }

    protected void findKeys(List<String> keys, String path) {
        log.trace((Object)("enter findKeysCached for path: " + path));
        Map children = this.cache.getCurrentChildren(path);
        if (children == null) {
            return;
        }
        for (Map.Entry entry : children.entrySet()) {
            ChildData child = (ChildData)entry.getValue();
            if (child.getData() == null || child.getData().length == 0) {
                this.findKeys(keys, child.getPath());
                continue;
            }
            keys.add(this.sanitizeKey(child.getPath()));
        }
        log.trace((Object)("leaving findKeysCached for path: " + path));
    }

    public void stop() {
        this.cache.close();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }
}

