/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.BinderErrorChannel;
import org.springframework.cloud.stream.binder.BinderException;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.BindingCreatedEvent;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binder.DefaultPollableMessageSource;
import org.springframework.cloud.stream.binder.EmbeddedHeaderUtils;
import org.springframework.cloud.stream.binder.FinalRethrowingErrorMessageHandler;
import org.springframework.cloud.stream.binder.HeaderMode;
import org.springframework.cloud.stream.binder.LastSubscriberAwareChannel;
import org.springframework.cloud.stream.binder.MessageValues;
import org.springframework.cloud.stream.binder.PollableConsumerBinder;
import org.springframework.cloud.stream.binder.PollableSource;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.Lifecycle;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.integration.handler.advice.ErrorMessageSendingRecoverer;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.util.Assert;

public abstract class AbstractMessageChannelBinder<C extends ConsumerProperties, P extends ProducerProperties, PP extends ProvisioningProvider<C, P>>
extends AbstractBinder<MessageChannel, C, P>
implements PollableConsumerBinder<MessageHandler, C> {
    private final EmbeddedHeadersChannelInterceptor embeddedHeadersChannelInterceptor;
    private final ObjectMapper objectMapper;
    protected final PP provisioningProvider;
    private final String[] headersToEmbed;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public AbstractMessageChannelBinder(String[] headersToEmbed, PP provisioningProvider) {
        this.embeddedHeadersChannelInterceptor = new EmbeddedHeadersChannelInterceptor(this.logger);
        this.objectMapper = new ObjectMapper();
        this.headersToEmbed = headersToEmbed == null ? new String[]{} : headersToEmbed;
        this.provisioningProvider = provisioningProvider;
    }

    @Deprecated
    protected AbstractMessageChannelBinder(boolean supportsHeadersNatively, String[] headersToEmbed, PP provisioningProvider) {
        this(headersToEmbed, provisioningProvider);
    }

    @Override
    public final Binding<MessageChannel> doBindProducer(final String destination, MessageChannel outputChannel, final P producerProperties) throws BinderException {
        MessageHandler producerMessageHandler;
        ProducerDestination producerDestination;
        Assert.isInstanceOf(SubscribableChannel.class, (Object)outputChannel, (String)"Binding is supported only for SubscribableChannel instances");
        try {
            producerDestination = this.provisioningProvider.provisionProducerDestination(destination, producerProperties);
            SubscribableChannel errorChannel = ((ProducerProperties)producerProperties).isErrorChannelEnabled() ? this.registerErrorInfrastructure(producerDestination) : null;
            producerMessageHandler = this.createProducerMessageHandler(producerDestination, producerProperties, (MessageChannel)errorChannel);
            if (producerMessageHandler instanceof InitializingBean) {
                ((InitializingBean)producerMessageHandler).afterPropertiesSet();
            }
        }
        catch (Exception e) {
            if (e instanceof BinderException) {
                throw (BinderException)e;
            }
            if (e instanceof ProvisioningException) {
                throw (ProvisioningException)((Object)e);
            }
            throw new BinderException("Exception thrown while building outbound endpoint", e);
        }
        if (producerMessageHandler instanceof Lifecycle) {
            ((Lifecycle)producerMessageHandler).start();
        }
        this.postProcessOutputChannel(outputChannel, producerProperties);
        ((SubscribableChannel)outputChannel).subscribe((MessageHandler)new SendingHandler(producerMessageHandler, HeaderMode.embeddedHeaders.equals((Object)((ProducerProperties)producerProperties).getHeaderMode()), this.headersToEmbed, ((ProducerProperties)producerProperties).isUseNativeEncoding()));
        DefaultBinding<MessageChannel> binding = new DefaultBinding<MessageChannel>(destination, null, outputChannel, producerMessageHandler instanceof Lifecycle ? (Lifecycle)producerMessageHandler : null){

            @Override
            public Map<String, Object> getExtendedInfo() {
                return AbstractMessageChannelBinder.this.doGetExtendedInfo(destination, producerProperties);
            }

            @Override
            public void afterUnbind() {
                try {
                    AbstractMessageChannelBinder.this.destroyErrorInfrastructure(producerDestination);
                    if (producerMessageHandler instanceof DisposableBean) {
                        ((DisposableBean)producerMessageHandler).destroy();
                    }
                }
                catch (Exception e) {
                    AbstractMessageChannelBinder.this.logger.error((Object)("Exception thrown while unbinding " + this.toString()), (Throwable)e);
                }
                AbstractMessageChannelBinder.this.afterUnbindProducer(producerDestination, producerProperties);
            }
        };
        this.doPublishEvent(new BindingCreatedEvent(binding));
        return binding;
    }

    protected void postProcessOutputChannel(MessageChannel outputChannel, P producerProperties) {
    }

    protected abstract MessageHandler createProducerMessageHandler(ProducerDestination var1, P var2, MessageChannel var3) throws Exception;

    protected void afterUnbindProducer(ProducerDestination destination, P producerProperties) {
    }

    @Override
    public final Binding<MessageChannel> doBindConsumer(String name, String group, MessageChannel inputChannel, final C properties) throws BinderException {
        MessageProducer consumerEndpoint = null;
        try {
            final ConsumerDestination destination = this.provisioningProvider.provisionConsumerDestination(name, group, properties);
            if (HeaderMode.embeddedHeaders.equals((Object)((ConsumerProperties)properties).getHeaderMode())) {
                this.enhanceMessageChannel(inputChannel);
            }
            consumerEndpoint = this.createConsumerEndpoint(destination, group, properties);
            consumerEndpoint.setOutputChannel(inputChannel);
            if (consumerEndpoint instanceof InitializingBean) {
                ((InitializingBean)consumerEndpoint).afterPropertiesSet();
            }
            if (consumerEndpoint instanceof Lifecycle) {
                ((Lifecycle)consumerEndpoint).start();
            }
            DefaultBinding<MessageChannel> binding = new DefaultBinding<MessageChannel>(name, group, inputChannel, consumerEndpoint instanceof Lifecycle ? (Lifecycle)consumerEndpoint : null){

                @Override
                public Map<String, Object> getExtendedInfo() {
                    return AbstractMessageChannelBinder.this.doGetExtendedInfo(destination, properties);
                }

                @Override
                protected void afterUnbind() {
                    try {
                        if (this.getEndpoint() instanceof DisposableBean) {
                            ((DisposableBean)this.getEndpoint()).destroy();
                        }
                    }
                    catch (Exception e) {
                        AbstractMessageChannelBinder.this.logger.error((Object)("Exception thrown while unbinding " + this.toString()), (Throwable)e);
                    }
                    AbstractMessageChannelBinder.this.afterUnbindConsumer(destination, this.group, properties);
                    AbstractMessageChannelBinder.this.destroyErrorInfrastructure(destination, this.group, properties);
                }
            };
            this.doPublishEvent(new BindingCreatedEvent(binding));
            return binding;
        }
        catch (Exception e) {
            if (consumerEndpoint instanceof Lifecycle) {
                ((Lifecycle)consumerEndpoint).stop();
            }
            if (e instanceof BinderException) {
                throw (BinderException)e;
            }
            if (e instanceof ProvisioningException) {
                throw (ProvisioningException)((Object)e);
            }
            throw new BinderException("Exception thrown while starting consumer: ", e);
        }
    }

    @Override
    public Binding<PollableSource<MessageHandler>> bindPollableConsumer(String name, String group, PollableSource<MessageHandler> inboundBindTarget, final C properties) {
        Assert.isInstanceOf(DefaultPollableMessageSource.class, inboundBindTarget);
        DefaultPollableMessageSource bindingTarget = (DefaultPollableMessageSource)inboundBindTarget;
        final ConsumerDestination destination = this.provisioningProvider.provisionConsumerDestination(name, group, properties);
        if (HeaderMode.embeddedHeaders.equals((Object)((ConsumerProperties)properties).getHeaderMode())) {
            bindingTarget.addInterceptor(0, (ChannelInterceptor)this.embeddedHeadersChannelInterceptor);
        }
        PolledConsumerResources resources = this.createPolledConsumerResources(name, group, destination, properties);
        bindingTarget.setSource(resources.getSource());
        if (resources.getErrorInfrastructure() != null) {
            ErrorMessageStrategy ems;
            if (resources.getErrorInfrastructure().getErrorChannel() != null) {
                bindingTarget.setErrorChannel((MessageChannel)resources.getErrorInfrastructure().getErrorChannel());
            }
            if ((ems = this.getErrorMessageStrategy()) != null) {
                bindingTarget.setErrorMessageStrategy(ems);
            }
        }
        if (((ConsumerProperties)properties).getMaxAttempts() > 1) {
            bindingTarget.setRetryTemplate(this.buildRetryTemplate((ConsumerProperties)properties));
            bindingTarget.setRecoveryCallback(this.getPolledConsumerRecoveryCallback(resources.getErrorInfrastructure(), properties));
        }
        this.postProcessPollableSource(bindingTarget);
        if (resources.getSource() instanceof Lifecycle) {
            ((Lifecycle)resources.getSource()).start();
        }
        DefaultBinding<PollableSource<MessageHandler>> binding = new DefaultBinding<PollableSource<MessageHandler>>(name, group, inboundBindTarget, resources.getSource() instanceof Lifecycle ? (Lifecycle)resources.getSource() : null){

            @Override
            public Map<String, Object> getExtendedInfo() {
                return AbstractMessageChannelBinder.this.doGetExtendedInfo(destination, properties);
            }

            @Override
            public void afterUnbind() {
                AbstractMessageChannelBinder.this.afterUnbindConsumer(destination, this.group, properties);
                AbstractMessageChannelBinder.this.destroyErrorInfrastructure(destination, this.group, properties);
            }
        };
        this.doPublishEvent(new BindingCreatedEvent(binding));
        return binding;
    }

    protected void postProcessPollableSource(DefaultPollableMessageSource bindingTarget) {
    }

    protected RecoveryCallback<Object> getPolledConsumerRecoveryCallback(ErrorInfrastructure errorInfrastructure, C properties) {
        return errorInfrastructure.getRecoverer();
    }

    protected PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, C consumerProperties) {
        throw new UnsupportedOperationException("This binder does not support pollable consumers");
    }

    private void enhanceMessageChannel(MessageChannel inputChannel) {
        ((AbstractMessageChannel)inputChannel).addInterceptor(0, (ChannelInterceptor)this.embeddedHeadersChannelInterceptor);
    }

    protected abstract MessageProducer createConsumerEndpoint(ConsumerDestination var1, String var2, C var3) throws Exception;

    protected void afterUnbindConsumer(ConsumerDestination destination, String group, C consumerProperties) {
    }

    private SubscribableChannel registerErrorInfrastructure(ProducerDestination destination) {
        ConfigurableListableBeanFactory beanFactory = this.getApplicationContext().getBeanFactory();
        String errorChannelName = this.errorsBaseName(destination);
        PublishSubscribeChannel errorChannel = null;
        if (this.getApplicationContext().containsBean(errorChannelName)) {
            Object errorChannelObject = this.getApplicationContext().getBean(errorChannelName);
            if (!(errorChannelObject instanceof SubscribableChannel)) {
                throw new IllegalStateException("Error channel '" + errorChannelName + "' must be a SubscribableChannel");
            }
            errorChannel = (SubscribableChannel)errorChannelObject;
        } else {
            errorChannel = new PublishSubscribeChannel();
            beanFactory.registerSingleton(errorChannelName, (Object)errorChannel);
            errorChannel = (PublishSubscribeChannel)beanFactory.initializeBean((Object)errorChannel, errorChannelName);
        }
        MessageChannel defaultErrorChannel = null;
        if (this.getApplicationContext().containsBean("errorChannel")) {
            defaultErrorChannel = (MessageChannel)this.getApplicationContext().getBean("errorChannel", MessageChannel.class);
        }
        if (defaultErrorChannel != null) {
            BridgeHandler errorBridge = new BridgeHandler();
            errorBridge.setOutputChannel(defaultErrorChannel);
            errorChannel.subscribe((MessageHandler)errorBridge);
            String errorBridgeHandlerName = this.getErrorBridgeName(destination);
            beanFactory.registerSingleton(errorBridgeHandlerName, (Object)errorBridge);
            beanFactory.initializeBean((Object)errorBridge, errorBridgeHandlerName);
        }
        return errorChannel;
    }

    protected final ErrorInfrastructure registerErrorInfrastructure(ConsumerDestination destination, String group, C consumerProperties) {
        return this.registerErrorInfrastructure(destination, group, consumerProperties, false);
    }

    protected final ErrorInfrastructure registerErrorInfrastructure(ConsumerDestination destination, String group, C consumerProperties, boolean polled) {
        ErrorMessageStrategy errorMessageStrategy = this.getErrorMessageStrategy();
        ConfigurableListableBeanFactory beanFactory = this.getApplicationContext().getBeanFactory();
        String errorChannelName = this.errorsBaseName(destination, group, consumerProperties);
        LastSubscriberAwareChannel errorChannel = null;
        if (this.getApplicationContext().containsBean(errorChannelName)) {
            Object errorChannelObject = this.getApplicationContext().getBean(errorChannelName);
            if (!(errorChannelObject instanceof SubscribableChannel)) {
                throw new IllegalStateException("Error channel '" + errorChannelName + "' must be a SubscribableChannel");
            }
            errorChannel = (SubscribableChannel)errorChannelObject;
        } else {
            errorChannel = new BinderErrorChannel();
            beanFactory.registerSingleton(errorChannelName, (Object)errorChannel);
            errorChannel = (LastSubscriberAwareChannel)beanFactory.initializeBean((Object)errorChannel, errorChannelName);
        }
        ErrorMessageSendingRecoverer recoverer = errorMessageStrategy == null ? new ErrorMessageSendingRecoverer((MessageChannel)errorChannel) : new ErrorMessageSendingRecoverer((MessageChannel)errorChannel, errorMessageStrategy);
        String recovererBeanName = this.getErrorRecovererName(destination, group, consumerProperties);
        beanFactory.registerSingleton(recovererBeanName, (Object)recoverer);
        beanFactory.initializeBean((Object)recoverer, recovererBeanName);
        MessageHandler handler = polled ? this.getPolledConsumerErrorMessageHandler(destination, group, consumerProperties) : this.getErrorMessageHandler(destination, group, consumerProperties);
        MessageChannel defaultErrorChannel = null;
        if (this.getApplicationContext().containsBean("errorChannel")) {
            defaultErrorChannel = (MessageChannel)this.getApplicationContext().getBean("errorChannel", MessageChannel.class);
        }
        if (handler == null && errorChannel instanceof LastSubscriberAwareChannel) {
            handler = this.getDefaultErrorMessageHandler(errorChannel, defaultErrorChannel != null);
        }
        String errorMessageHandlerName = this.getErrorMessageHandlerName(destination, group, consumerProperties);
        if (handler != null) {
            beanFactory.registerSingleton(errorMessageHandlerName, (Object)handler);
            beanFactory.initializeBean((Object)handler, errorMessageHandlerName);
            errorChannel.subscribe(handler);
        }
        if (defaultErrorChannel != null) {
            BridgeHandler errorBridge = new BridgeHandler();
            errorBridge.setOutputChannel(defaultErrorChannel);
            errorChannel.subscribe((MessageHandler)errorBridge);
            String errorBridgeHandlerName = this.getErrorBridgeName(destination, group, consumerProperties);
            beanFactory.registerSingleton(errorBridgeHandlerName, (Object)errorBridge);
            beanFactory.initializeBean((Object)errorBridge, errorBridgeHandlerName);
        }
        return new ErrorInfrastructure(errorChannel, recoverer, handler);
    }

    private void destroyErrorInfrastructure(ProducerDestination destination) {
        String errorChannelName = this.errorsBaseName(destination);
        String errorBridgeHandlerName = this.getErrorBridgeName(destination);
        MessageHandler bridgeHandler = null;
        if (this.getApplicationContext().containsBean(errorBridgeHandlerName)) {
            bridgeHandler = (MessageHandler)this.getApplicationContext().getBean(errorBridgeHandlerName, MessageHandler.class);
        }
        if (this.getApplicationContext().containsBean(errorChannelName)) {
            SubscribableChannel channel = (SubscribableChannel)this.getApplicationContext().getBean(errorChannelName, SubscribableChannel.class);
            if (bridgeHandler != null) {
                channel.unsubscribe(bridgeHandler);
                ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(errorBridgeHandlerName);
            }
            ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(errorChannelName);
        }
    }

    private void destroyErrorInfrastructure(ConsumerDestination destination, String group, C properties) {
        try {
            String recoverer = this.getErrorRecovererName(destination, group, properties);
            if (this.getApplicationContext().containsBean(recoverer)) {
                ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(recoverer);
            }
            String errorChannelName = this.errorsBaseName(destination, group, properties);
            String errorMessageHandlerName = this.getErrorMessageHandlerName(destination, group, properties);
            String errorBridgeHandlerName = this.getErrorBridgeName(destination, group, properties);
            MessageHandler bridgeHandler = null;
            if (this.getApplicationContext().containsBean(errorBridgeHandlerName)) {
                bridgeHandler = (MessageHandler)this.getApplicationContext().getBean(errorBridgeHandlerName, MessageHandler.class);
            }
            MessageHandler handler = null;
            if (this.getApplicationContext().containsBean(errorMessageHandlerName)) {
                handler = (MessageHandler)this.getApplicationContext().getBean(errorMessageHandlerName, MessageHandler.class);
            }
            if (this.getApplicationContext().containsBean(errorChannelName)) {
                SubscribableChannel channel = (SubscribableChannel)this.getApplicationContext().getBean(errorChannelName, SubscribableChannel.class);
                if (bridgeHandler != null) {
                    channel.unsubscribe(bridgeHandler);
                    ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(errorBridgeHandlerName);
                }
                if (handler != null) {
                    channel.unsubscribe(handler);
                    ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(errorMessageHandlerName);
                }
                ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(errorChannelName);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected MessageHandler getErrorMessageHandler(ConsumerDestination destination, String group, C consumerProperties) {
        return null;
    }

    protected MessageHandler getPolledConsumerErrorMessageHandler(ConsumerDestination destination, String group, C consumerProperties) {
        return null;
    }

    protected MessageHandler getDefaultErrorMessageHandler(LastSubscriberAwareChannel errorChannel, boolean defaultErrorChannelPresent) {
        return new FinalRethrowingErrorMessageHandler(errorChannel, defaultErrorChannelPresent);
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return null;
    }

    protected String getErrorRecovererName(ConsumerDestination destination, String group, C consumerProperties) {
        return this.errorsBaseName(destination, group, consumerProperties) + ".recoverer";
    }

    protected String getErrorMessageHandlerName(ConsumerDestination destination, String group, C consumerProperties) {
        return this.errorsBaseName(destination, group, consumerProperties) + ".handler";
    }

    protected String getErrorBridgeName(ConsumerDestination destination, String group, C consumerProperties) {
        return this.errorsBaseName(destination, group, consumerProperties) + ".bridge";
    }

    protected String errorsBaseName(ConsumerDestination destination, String group, C consumerProperties) {
        return destination.getName() + "." + group + ".errors";
    }

    protected String getErrorBridgeName(ProducerDestination destination) {
        return this.errorsBaseName(destination) + ".bridge";
    }

    protected String errorsBaseName(ProducerDestination destination) {
        return destination.getName() + ".errors";
    }

    private Map<String, Object> doGetExtendedInfo(Object destination, Object properties) {
        LinkedHashMap<String, Object> extendedInfo = new LinkedHashMap<String, Object>();
        extendedInfo.put("bindingDestination", destination.toString());
        extendedInfo.put(properties.getClass().getSimpleName(), this.objectMapper.convertValue(properties, Map.class));
        return extendedInfo;
    }

    private void doPublishEvent(ApplicationEvent event) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent(event);
        }
    }

    protected static class PolledConsumerResources {
        private final MessageSource<?> source;
        private final ErrorInfrastructure errorInfrastructure;

        public PolledConsumerResources(MessageSource<?> source, ErrorInfrastructure errorInfrastructure) {
            this.source = source;
            this.errorInfrastructure = errorInfrastructure;
        }

        MessageSource<?> getSource() {
            return this.source;
        }

        ErrorInfrastructure getErrorInfrastructure() {
            return this.errorInfrastructure;
        }
    }

    private static final class EmbeddedHeadersChannelInterceptor
    extends ChannelInterceptorAdapter {
        protected final Log logger;

        EmbeddedHeadersChannelInterceptor(Log logger) {
            this.logger = logger;
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            if (message.getPayload() instanceof byte[] && !message.getHeaders().containsKey((Object)"scst_nativeHeadersPresent") && EmbeddedHeaderUtils.mayHaveEmbeddedHeaders((byte[])message.getPayload())) {
                MessageValues messageValues;
                try {
                    messageValues = EmbeddedHeaderUtils.extractHeaders(message, true);
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)EmbeddedHeaderUtils.decodeExceptionMessage(message), (Throwable)e);
                    }
                    messageValues = new MessageValues(message);
                }
                return messageValues.toMessage();
            }
            return message;
        }
    }

    protected static class ErrorInfrastructure {
        private final SubscribableChannel errorChannel;
        private final ErrorMessageSendingRecoverer recoverer;
        private final MessageHandler handler;

        ErrorInfrastructure(SubscribableChannel errorChannel, ErrorMessageSendingRecoverer recoverer, MessageHandler handler) {
            this.errorChannel = errorChannel;
            this.recoverer = recoverer;
            this.handler = handler;
        }

        public SubscribableChannel getErrorChannel() {
            return this.errorChannel;
        }

        public ErrorMessageSendingRecoverer getRecoverer() {
            return this.recoverer;
        }

        public MessageHandler getHandler() {
            return this.handler;
        }
    }

    private final class SendingHandler
    extends AbstractMessageHandler
    implements Lifecycle {
        private final boolean embedHeaders;
        private final String[] embeddedHeaders;
        private final MessageHandler delegate;
        private final boolean useNativeEncoding;

        private SendingHandler(MessageHandler delegate, boolean embedHeaders, String[] headersToEmbed, boolean useNativeEncoding) {
            this.delegate = delegate;
            this.setBeanFactory((BeanFactory)AbstractMessageChannelBinder.this.getBeanFactory());
            this.embedHeaders = embedHeaders;
            this.embeddedHeaders = headersToEmbed;
            this.useNativeEncoding = useNativeEncoding;
        }

        protected void handleMessageInternal(Message<?> message) throws Exception {
            Message<?> messageToSend = this.useNativeEncoding ? message : this.serializeAndEmbedHeadersIfApplicable(message);
            this.delegate.handleMessage(messageToSend);
        }

        private Message<?> serializeAndEmbedHeadersIfApplicable(Message<?> message) throws Exception {
            byte[] payload;
            MessageValues transformed = AbstractMessageChannelBinder.this.serializePayloadIfNecessary(message);
            if (this.embedHeaders) {
                Object originalContentType;
                Object contentType = transformed.get("contentType");
                if (contentType != null) {
                    transformed.put("contentType", (Object)contentType.toString());
                }
                if ((originalContentType = transformed.get("originalContentType")) != null) {
                    transformed.put("originalContentType", (Object)originalContentType.toString());
                }
                payload = EmbeddedHeaderUtils.embedHeaders(transformed, this.embeddedHeaders);
            } else {
                payload = (byte[])transformed.getPayload();
            }
            return this.getMessageBuilderFactory().withPayload((Object)payload).copyHeaders(transformed.getHeaders()).build();
        }

        public void start() {
            if (this.delegate instanceof Lifecycle) {
                ((Lifecycle)this.delegate).start();
            }
        }

        public void stop() {
            if (this.delegate instanceof Lifecycle) {
                ((Lifecycle)this.delegate).stop();
            }
        }

        public boolean isRunning() {
            return this.delegate instanceof Lifecycle && ((Lifecycle)this.delegate).isRunning();
        }
    }
}

