/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.cloud.stream.binding.DispatchingStreamListenerMessageHandler;
import org.springframework.cloud.stream.binding.MessageChannelStreamListenerResultAdapter;
import org.springframework.cloud.stream.binding.StreamListenerMessageHandler;
import org.springframework.cloud.stream.binding.StreamListenerMethodUtils;
import org.springframework.cloud.stream.binding.StreamListenerParameterAdapter;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class StreamListenerAnnotationBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
BeanFactoryAware,
SmartInitializingSingleton,
InitializingBean {
    private static final SpelExpressionParser SPEL_EXPRESSION_PARSER = new SpelExpressionParser();
    @Autowired
    @Lazy
    private DestinationResolver<MessageChannel> binderAwareChannelResolver;
    @Autowired
    @Lazy
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private final MultiValueMap<String, StreamListenerHandlerMethodMapping> mappedListenerMethods = new LinkedMultiValueMap();
    private ConfigurableApplicationContext applicationContext;
    private final List<StreamListenerParameterAdapter<?, Object>> streamListenerParameterAdapters = new ArrayList();
    private final List<StreamListenerResultAdapter<?, ?>> streamListenerResultAdapters = new ArrayList();
    private EvaluationContext evaluationContext;
    private BeanFactory beanFactory;
    private BeanExpressionResolver resolver;
    private BeanExpressionContext expressionContext;

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Map parameterAdapterMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, StreamListenerParameterAdapter.class);
        for (StreamListenerParameterAdapter parameterAdapter : parameterAdapterMap.values()) {
            this.streamListenerParameterAdapters.add(parameterAdapter);
        }
        Map resultAdapterMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, StreamListenerResultAdapter.class);
        this.streamListenerResultAdapters.add(new MessageChannelStreamListenerResultAdapter());
        for (StreamListenerResultAdapter resultAdapter : resultAdapterMap.values()) {
            this.streamListenerResultAdapters.add(resultAdapter);
        }
    }

    public final Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public final Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        Class<?> targetClass = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean) : bean.getClass();
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                StreamListener streamListener = (StreamListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, StreamListener.class);
                if (streamListener != null && !method.isBridge()) {
                    streamListener = StreamListenerAnnotationBeanPostProcessor.this.postProcessAnnotation(streamListener, method);
                    Assert.isTrue((method.getAnnotation(Input.class) == null ? 1 : 0) != 0, (String)"A method annotated with @StreamListener may never be annotated with @Input. If it should listen to a specific input, use the value of @StreamListener instead");
                    String methodAnnotatedInboundName = streamListener.value();
                    String methodAnnotatedOutboundName = StreamListenerMethodUtils.getOutboundBindingTargetName(method);
                    int inputAnnotationCount = StreamListenerMethodUtils.inputAnnotationCount(method);
                    int outputAnnotationCount = StreamListenerMethodUtils.outputAnnotationCount(method);
                    boolean isDeclarative = StreamListenerAnnotationBeanPostProcessor.this.checkDeclarativeMethod(method, methodAnnotatedInboundName, methodAnnotatedOutboundName);
                    StreamListenerMethodUtils.validateStreamListenerMethod(method, inputAnnotationCount, outputAnnotationCount, methodAnnotatedInboundName, methodAnnotatedOutboundName, isDeclarative, streamListener.condition());
                    if (!method.getReturnType().equals(Void.TYPE) && !StringUtils.hasText((String)methodAnnotatedOutboundName)) {
                        if (outputAnnotationCount == 0) {
                            throw new IllegalArgumentException("A method annotated with @StreamListener having a return type should also have an outbound target specified");
                        }
                        Assert.isTrue((outputAnnotationCount == 1 ? 1 : 0) != 0, (String)"A method annotated with @StreamListener having a return type should have only one outbound target specified");
                    }
                    if (isDeclarative) {
                        StreamListenerAnnotationBeanPostProcessor.this.invokeSetupMethodOnListenedChannel(method, bean, methodAnnotatedInboundName, methodAnnotatedOutboundName);
                    } else {
                        StreamListenerAnnotationBeanPostProcessor.this.registerHandlerMethodOnListenedChannel(method, streamListener, bean);
                    }
                }
            }
        });
        return bean;
    }

    protected StreamListener postProcessAnnotation(StreamListener originalAnnotation, Method annotatedMethod) {
        return originalAnnotation;
    }

    private boolean checkDeclarativeMethod(Method method, String methodAnnotatedInboundName, String methodAnnotatedOutboundName) {
        int methodArgumentsLength = method.getParameterTypes().length;
        for (int parameterIndex = 0; parameterIndex < methodArgumentsLength; ++parameterIndex) {
            MethodParameter methodParameter = MethodParameter.forMethodOrConstructor((Object)method, (int)parameterIndex);
            if (methodParameter.hasParameterAnnotation(Input.class)) {
                String inboundName = (String)AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Input.class));
                Assert.isTrue((boolean)StringUtils.hasText((String)inboundName), (String)"The @Input annotation must have the name of an input as value");
                Assert.isTrue((boolean)this.isDeclarativeMethodParameter(this.applicationContext.getBean(inboundName), methodParameter), (String)"A method annotated with @StreamListener may use @Input or @Output annotations only in declarative mode and for parameters that are binding targets or convertible from binding targets.");
                return true;
            }
            if (methodParameter.hasParameterAnnotation(Output.class)) {
                String outboundName = (String)AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Output.class));
                Assert.isTrue((boolean)StringUtils.hasText((String)outboundName), (String)"The @Output annotation must have the name of an input as value");
                Assert.isTrue((boolean)this.isDeclarativeMethodParameter(this.applicationContext.getBean(outboundName), methodParameter), (String)"A method annotated with @StreamListener may use @Input or @Output annotations only in declarative mode and for parameters that are binding targets or convertible from binding targets.");
                return true;
            }
            if (StringUtils.hasText((String)methodAnnotatedOutboundName)) {
                return this.isDeclarativeMethodParameter(this.applicationContext.getBean(methodAnnotatedOutboundName), methodParameter);
            }
            if (!StringUtils.hasText((String)methodAnnotatedInboundName)) continue;
            return this.isDeclarativeMethodParameter(this.applicationContext.getBean(methodAnnotatedInboundName), methodParameter);
        }
        return false;
    }

    private boolean isDeclarativeMethodParameter(Object targetBean, MethodParameter methodParameter) {
        if (targetBean != null) {
            if (!methodParameter.getParameterType().equals(Object.class) && methodParameter.getParameterType().isAssignableFrom(targetBean.getClass())) {
                return true;
            }
            for (StreamListenerParameterAdapter<?, Object> streamListenerParameterAdapter : this.streamListenerParameterAdapters) {
                if (!streamListenerParameterAdapter.supports(targetBean.getClass(), methodParameter)) continue;
                return true;
            }
        }
        return false;
    }

    private void invokeSetupMethodOnListenedChannel(Method method, Object bean, String inboundName, String outboundName) {
        block17: {
            Object[] arguments = new Object[method.getParameterTypes().length];
            for (int parameterIndex = 0; parameterIndex < arguments.length; ++parameterIndex) {
                Object targetBean;
                MethodParameter methodParameter = MethodParameter.forMethodOrConstructor((Object)method, (int)parameterIndex);
                Class parameterType = methodParameter.getParameterType();
                Object targetReferenceValue = null;
                if (methodParameter.hasParameterAnnotation(Input.class)) {
                    targetReferenceValue = AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Input.class));
                } else if (methodParameter.hasParameterAnnotation(Output.class)) {
                    targetReferenceValue = AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Output.class));
                } else if (arguments.length == 1 && StringUtils.hasText((String)inboundName)) {
                    targetReferenceValue = inboundName;
                }
                if (targetReferenceValue != null) {
                    Assert.isInstanceOf(String.class, (Object)targetReferenceValue, (String)"Annotation value must be a String");
                    targetBean = this.applicationContext.getBean((String)targetReferenceValue);
                    if (parameterType.isAssignableFrom(targetBean.getClass())) {
                        arguments[parameterIndex] = targetBean;
                    } else {
                        for (StreamListenerParameterAdapter<?, Object> streamListenerParameterAdapter : this.streamListenerParameterAdapters) {
                            if (!streamListenerParameterAdapter.supports(targetBean.getClass(), methodParameter)) continue;
                            arguments[parameterIndex] = streamListenerParameterAdapter.adapt(targetBean, methodParameter);
                            break;
                        }
                    }
                } else {
                    throw new IllegalStateException("A method annotated with @StreamListener may use @Input or @Output annotations only in declarative mode and for parameters that are binding targets or convertible from binding targets.");
                }
                Assert.notNull((Object)arguments[parameterIndex], (String)("Cannot convert argument " + parameterIndex + " of " + method + "from " + targetBean.getClass() + " to " + parameterType));
            }
            try {
                if (Void.TYPE.equals(method.getReturnType())) {
                    method.invoke(bean, arguments);
                    break block17;
                }
                Object result = method.invoke(bean, arguments);
                if (!StringUtils.hasText((String)outboundName)) {
                    for (int parameterIndex = 0; parameterIndex < method.getParameterTypes().length; ++parameterIndex) {
                        MethodParameter methodParameter = MethodParameter.forMethodOrConstructor((Object)method, (int)parameterIndex);
                        if (!methodParameter.hasParameterAnnotation(Output.class)) continue;
                        outboundName = ((Output)methodParameter.getParameterAnnotation(Output.class)).value();
                    }
                }
                Object targetBean = this.applicationContext.getBean(outboundName);
                for (StreamListenerResultAdapter<?, ?> streamListenerResultAdapter : this.streamListenerResultAdapters) {
                    if (!streamListenerResultAdapter.supports(result.getClass(), targetBean.getClass())) continue;
                    streamListenerResultAdapter.adapt(result, targetBean);
                    break;
                }
            }
            catch (Exception e) {
                throw new BeanInitializationException("Cannot setup StreamListener for " + method, (Throwable)e);
            }
        }
    }

    protected final void registerHandlerMethodOnListenedChannel(Method method, StreamListener streamListener, Object bean) {
        Assert.hasText((String)streamListener.value(), (String)"The binding name cannot be null");
        if (!StringUtils.hasText((String)streamListener.value())) {
            throw new BeanInitializationException("A bound component name must be specified");
        }
        String defaultOutputChannel = StreamListenerMethodUtils.getOutboundBindingTargetName(method);
        if (Void.TYPE.equals(method.getReturnType())) {
            Assert.isTrue((boolean)StringUtils.isEmpty((Object)defaultOutputChannel), (String)"An output channel cannot be specified for a method that does not return a value");
        } else {
            Assert.isTrue((!StringUtils.isEmpty((Object)defaultOutputChannel) ? 1 : 0) != 0, (String)"An output channel must be specified for a method that can return a value");
        }
        StreamListenerMethodUtils.validateStreamListenerMessageHandler(method);
        this.mappedListenerMethods.add((Object)streamListener.value(), (Object)new StreamListenerHandlerMethodMapping(bean, method, streamListener.condition(), defaultOutputChannel));
    }

    public final void afterSingletonsInstantiated() {
        this.evaluationContext = IntegrationContextUtils.getEvaluationContext((BeanFactory)this.applicationContext.getBeanFactory());
        for (Map.Entry mappedBindingEntry : this.mappedListenerMethods.entrySet()) {
            ArrayList<DispatchingStreamListenerMessageHandler.ConditionalStreamListenerHandler> handlers = new ArrayList<DispatchingStreamListenerMessageHandler.ConditionalStreamListenerHandler>();
            for (StreamListenerHandlerMethodMapping mapping : (List)mappedBindingEntry.getValue()) {
                InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(mapping.getTargetBean(), this.checkProxy(mapping.getMethod(), mapping.getTargetBean()));
                StreamListenerMessageHandler streamListenerMessageHandler = new StreamListenerMessageHandler(invocableHandlerMethod);
                streamListenerMessageHandler.setApplicationContext((ApplicationContext)this.applicationContext);
                streamListenerMessageHandler.setBeanFactory((BeanFactory)this.applicationContext.getBeanFactory());
                if (StringUtils.hasText((String)mapping.getDefaultOutputChannel())) {
                    streamListenerMessageHandler.setOutputChannelName(mapping.getDefaultOutputChannel());
                }
                streamListenerMessageHandler.afterPropertiesSet();
                if (StringUtils.hasText((String)mapping.getCondition())) {
                    String conditionAsString = this.resolveExpressionAsString(mapping.getCondition());
                    Expression condition = SPEL_EXPRESSION_PARSER.parseExpression(conditionAsString);
                    handlers.add(new DispatchingStreamListenerMessageHandler.ConditionalStreamListenerHandler(condition, streamListenerMessageHandler));
                    continue;
                }
                handlers.add(new DispatchingStreamListenerMessageHandler.ConditionalStreamListenerHandler(null, streamListenerMessageHandler));
            }
            if (handlers.size() > 1) {
                for (DispatchingStreamListenerMessageHandler.ConditionalStreamListenerHandler handler : handlers) {
                    Assert.isTrue((boolean)handler.isVoid(), (String)"If multiple @StreamListener methods are listening to the same binding target, none of them may return a value");
                }
            }
            DispatchingStreamListenerMessageHandler handler = new DispatchingStreamListenerMessageHandler(handlers, this.evaluationContext);
            handler.setApplicationContext((ApplicationContext)this.applicationContext);
            handler.setChannelResolver(this.binderAwareChannelResolver);
            handler.afterPropertiesSet();
            ((SubscribableChannel)this.applicationContext.getBean((String)mappedBindingEntry.getKey(), SubscribableChannel.class)).subscribe((MessageHandler)handler);
        }
        this.mappedListenerMethods.clear();
    }

    private Method checkProxy(Method methodArg, Object bean) {
        Method method = methodArg;
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class iface : proxiedInterfaces = ((Advised)bean).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@StreamListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()), ex);
            }
        }
        return method;
    }

    private String resolveExpressionAsString(String value) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof String) {
            return (String)resolved;
        }
        throw new IllegalStateException("Resolved to [" + resolved.getClass() + "] for [" + value + "]");
    }

    private Object resolveExpression(String value) {
        String resolvedValue = this.resolve(value);
        if (!resolvedValue.startsWith("#{") || !value.endsWith("}")) {
            return resolvedValue;
        }
        return this.resolver.evaluate(resolvedValue, this.expressionContext);
    }

    private String resolve(String value) {
        if (this.beanFactory != null && this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }

    private class StreamListenerHandlerMethodMapping {
        private Object targetBean;
        private Method method;
        private String condition;
        private String defaultOutputChannel;

        StreamListenerHandlerMethodMapping(Object targetBean, Method method, String condition, String defaultOutputChannel) {
            this.targetBean = targetBean;
            this.method = method;
            this.condition = condition;
            this.defaultOutputChannel = defaultOutputChannel;
        }

        Object getTargetBean() {
            return this.targetBean;
        }

        Method getMethod() {
            return this.method;
        }

        String getCondition() {
            return this.condition;
        }

        String getDefaultOutputChannel() {
            return this.defaultOutputChannel;
        }
    }
}

