/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.config;

import com.rabbitmq.client.ConnectionFactory;
import java.time.Duration;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.support.postprocessor.DelegatingDecompressingPostProcessor;
import org.springframework.amqp.support.postprocessor.GZipPostProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitMessageChannelBinder;
import org.springframework.cloud.stream.binder.rabbit.config.RabbitServiceAutoConfiguration;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.provisioning.RabbitExchangeQueueProvisioner;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={PropertyPlaceholderAutoConfiguration.class})
@EnableConfigurationProperties(value={RabbitBinderConfigurationProperties.class, RabbitExtendedBindingProperties.class})
public class RabbitMessageChannelBinderConfiguration {
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private org.springframework.amqp.rabbit.connection.ConnectionFactory rabbitConnectionFactory;
    @Autowired
    private RabbitProperties rabbitProperties;
    @Autowired
    private RabbitBinderConfigurationProperties rabbitBinderConfigurationProperties;
    @Autowired
    private RabbitExtendedBindingProperties rabbitExtendedBindingProperties;

    @Bean
    RabbitMessageChannelBinder rabbitMessageChannelBinder() throws Exception {
        RabbitMessageChannelBinder binder = new RabbitMessageChannelBinder(this.rabbitConnectionFactory, this.rabbitProperties, this.provisioningProvider());
        binder.setProducerConnectionFactory((org.springframework.amqp.rabbit.connection.ConnectionFactory)this.buildProducerConnectionFactory());
        binder.setAdminAddresses(this.rabbitBinderConfigurationProperties.getAdminAddresses());
        binder.setCompressingPostProcessor(this.gZipPostProcessor());
        binder.setDecompressingPostProcessor(this.deCompressingPostProcessor());
        binder.setNodes(this.rabbitBinderConfigurationProperties.getNodes());
        binder.setExtendedBindingProperties(this.rabbitExtendedBindingProperties);
        return binder;
    }

    private CachingConnectionFactory buildProducerConnectionFactory() throws Exception {
        ConnectionFactory rabbitConnectionFactory;
        if (this.rabbitConnectionFactory instanceof CachingConnectionFactory) {
            rabbitConnectionFactory = ((CachingConnectionFactory)this.rabbitConnectionFactory).getRabbitConnectionFactory();
        } else {
            Duration connectionTimeoutDuration;
            RabbitProperties.Ssl ssl;
            Duration requestedHeartbeatDuration;
            String vHost;
            String password;
            RabbitConnectionFactoryBean factory = new RabbitConnectionFactoryBean();
            String host = this.rabbitProperties.determineHost();
            if (host != null) {
                factory.setHost(host);
            }
            factory.setPort(this.rabbitProperties.determinePort());
            String user = this.rabbitProperties.determineUsername();
            if (user != null) {
                factory.setUsername(user);
            }
            if ((password = this.rabbitProperties.determinePassword()) != null) {
                factory.setPassword(password);
            }
            if ((vHost = this.rabbitProperties.determineVirtualHost()) != null) {
                factory.setVirtualHost(vHost);
            }
            if ((requestedHeartbeatDuration = this.rabbitProperties.getRequestedHeartbeat()) != null) {
                factory.setRequestedHeartbeat((int)requestedHeartbeatDuration.getSeconds());
            }
            if ((ssl = this.rabbitProperties.getSsl()).isEnabled()) {
                factory.setUseSSL(true);
                if (ssl.getAlgorithm() != null) {
                    factory.setSslAlgorithm(ssl.getAlgorithm());
                }
                factory.setKeyStore(ssl.getKeyStore());
                factory.setKeyStorePassphrase(ssl.getKeyStorePassword());
                factory.setTrustStore(ssl.getTrustStore());
                factory.setTrustStorePassphrase(ssl.getTrustStorePassword());
            }
            if ((connectionTimeoutDuration = this.rabbitProperties.getConnectionTimeout()) != null) {
                factory.setConnectionTimeout((int)connectionTimeoutDuration.getSeconds());
            }
            factory.afterPropertiesSet();
            rabbitConnectionFactory = (ConnectionFactory)factory.getObject();
        }
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(rabbitConnectionFactory);
        RabbitServiceAutoConfiguration.configureCachingConnectionFactory(connectionFactory, this.applicationContext, this.rabbitProperties);
        return connectionFactory;
    }

    @Bean
    MessagePostProcessor deCompressingPostProcessor() {
        return new DelegatingDecompressingPostProcessor();
    }

    @Bean
    MessagePostProcessor gZipPostProcessor() {
        GZipPostProcessor gZipPostProcessor = new GZipPostProcessor();
        gZipPostProcessor.setLevel(this.rabbitBinderConfigurationProperties.getCompressionLevel());
        return gZipPostProcessor;
    }

    @Bean
    RabbitExchangeQueueProvisioner provisioningProvider() {
        return new RabbitExchangeQueueProvisioner(this.rabbitConnectionFactory);
    }
}

