/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server.event;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.eureka.PeerAwareInstanceRegistryImpl;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.netflix.eureka.server.advice.LeaseManagerLite;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceCanceledEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRegisteredEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRenewedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class LeaseManagerMessageBroker
implements LeaseManagerLite<InstanceInfo> {
    private static final Log log = LogFactory.getLog(LeaseManagerMessageBroker.class);
    @Autowired
    private ApplicationContext ctxt;

    @Override
    public void register(InstanceInfo info, boolean isReplication) {
        this.register(info, 90, isReplication);
    }

    public void register(InstanceInfo info, int leaseDuration, boolean isReplication) {
        log.debug((Object)("register " + info.getAppName() + ", vip " + info.getVIPAddress() + ", leaseDuration " + leaseDuration + ", isReplication " + isReplication));
        this.ctxt.publishEvent((ApplicationEvent)new EurekaInstanceRegisteredEvent(this, info, leaseDuration, isReplication));
    }

    public boolean cancel(String appName, String serverId, boolean isReplication) {
        log.debug((Object)("cancel " + appName + " serverId " + serverId + ", isReplication {}" + isReplication));
        this.ctxt.publishEvent((ApplicationEvent)new EurekaInstanceCanceledEvent(this, appName, serverId, isReplication));
        return false;
    }

    public boolean renew(String appName, String serverId, boolean isReplication) {
        log.debug((Object)("renew " + appName + " serverId " + serverId + ", isReplication {}" + isReplication));
        List applications = PeerAwareInstanceRegistryImpl.getInstance().getSortedApplications();
        for (Application input : applications) {
            if (!input.getName().equals(appName)) continue;
            InstanceInfo instance = null;
            for (InstanceInfo info : input.getInstances()) {
                if (!info.getHostName().equals(serverId)) continue;
                instance = info;
                break;
            }
            this.ctxt.publishEvent((ApplicationEvent)new EurekaInstanceRenewedEvent(this, appName, serverId, instance, isReplication));
            break;
        }
        return false;
    }

    public void evict() {
    }
}

