/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server.advice;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.ReflectionUtils;

public class PiggybackMethodInterceptor
implements MethodInterceptor {
    private Object delegate;
    private Class<?>[] types;

    public PiggybackMethodInterceptor(Object delegate, Class<?> ... types) {
        this.delegate = delegate;
        this.types = types;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = invocation.proceed();
        this.invokeAfter(invocation.getMethod(), invocation.getArguments());
        return result;
    }

    private void invokeAfter(Method method, Object[] arguments) throws Exception {
        for (Class<?> type : this.types) {
            Method target = this.getTarget(type, method);
            if (target == null) continue;
            target.invoke(this.delegate, arguments);
            return;
        }
    }

    private Method getTarget(Class<?> type, Method method) {
        Method target = ReflectionUtils.findMethod(type, (String)method.getName(), (Class[])method.getParameterTypes());
        return target;
    }
}

