/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceBootstrapConfiguration;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.cloud.endpoint.event.RefreshEventListener;
import org.springframework.cloud.health.RefreshScopeHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.monitor.IntegrationMBeanExporter;

@Configuration
@ConditionalOnClass(value={Endpoint.class})
@AutoConfigureAfter(value={EndpointAutoConfiguration.class})
public class RefreshEndpointAutoConfiguration {
    @ConditionalOnMissingBean
    @ConditionalOnEnabledHealthIndicator(value="refresh")
    @Bean
    RefreshScopeHealthIndicator refreshScopeHealthIndicator(RefreshScope scope, ConfigurationPropertiesRebinder rebinder) {
        return new RefreshScopeHealthIndicator(scope, rebinder);
    }

    @Bean
    @ConfigurationProperties(value="endpoints.pause")
    public RestartEndpoint.PauseEndpoint pauseEndpoint(RestartEndpoint restartEndpoint) {
        return restartEndpoint.getPauseEndpoint();
    }

    @Bean
    @ConfigurationProperties(value="endpoints.resume")
    public RestartEndpoint.ResumeEndpoint resumeEndpoint(RestartEndpoint restartEndpoint) {
        return restartEndpoint.getResumeEndpoint();
    }

    @Configuration
    @ConditionalOnProperty(value={"endpoints.refresh.enabled"}, matchIfMissing=true)
    @ConditionalOnBean(value={PropertySourceBootstrapConfiguration.class})
    protected static class RefreshEndpointConfiguration {
        protected RefreshEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RefreshEndpoint refreshEndpoint(ContextRefresher contextRefresher) {
            RefreshEndpoint endpoint = new RefreshEndpoint(contextRefresher);
            return endpoint;
        }

        @Bean
        public RefreshEventListener refreshEventListener(RefreshEndpoint refreshEndpoint) {
            return new RefreshEventListener(refreshEndpoint);
        }
    }

    @ConditionalOnMissingClass(value={"org.springframework.integration.monitor.IntegrationMBeanExporter"})
    protected static class RestartEndpointWithoutIntegration {
        protected RestartEndpointWithoutIntegration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RestartEndpoint restartEndpoint() {
            return new RestartEndpoint();
        }
    }

    @ConditionalOnClass(value={IntegrationMBeanExporter.class})
    protected static class RestartEndpointWithIntegration {
        @Autowired(required=false)
        private IntegrationMBeanExporter exporter;

        protected RestartEndpointWithIntegration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RestartEndpoint restartEndpoint() {
            RestartEndpoint endpoint = new RestartEndpoint();
            if (this.exporter != null) {
                endpoint.setIntegrationMBeanExporter(this.exporter);
            }
            return endpoint;
        }
    }
}

