/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.properties;

import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.properties.ConfigurationPropertiesBeans;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource
public class ConfigurationPropertiesRebinder
implements ApplicationContextAware,
ApplicationListener<EnvironmentChangeEvent> {
    private ConfigurationPropertiesBeans beans;
    private ConfigurationPropertiesBindingPostProcessor binder;
    private ApplicationContext applicationContext;

    public ConfigurationPropertiesRebinder(ConfigurationPropertiesBindingPostProcessor binder, ConfigurationPropertiesBeans beans) {
        this.binder = binder;
        this.beans = beans;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @ManagedOperation
    public void rebind() {
        for (String name : this.beans.getBeanNames()) {
            this.rebind(name);
        }
    }

    @ManagedOperation
    public boolean rebind(String name) {
        if (!this.beans.getBeanNames().contains(name)) {
            return false;
        }
        if (this.applicationContext != null) {
            Object bean = this.applicationContext.getBean(name);
            this.binder.postProcessBeforeInitialization(bean, name);
            this.applicationContext.getAutowireCapableBeanFactory().initializeBean(bean, name);
            return true;
        }
        return false;
    }

    @ManagedAttribute
    public Set<String> getBeanNames() {
        return new HashSet<String>(this.beans.getBeanNames());
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        this.rebind();
    }
}

