/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.ParentContextApplicationContextInitializer;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.cloud.bootstrap.BootstrapConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BootstrapApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrap";
    public static final int DEFAULT_ORDER = -2147483643;
    private int order = -2147483643;

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (!((Boolean)environment.getProperty("spring.cloud.bootstrap.enabled", Boolean.class, (Object)true)).booleanValue()) {
            return;
        }
        if (environment.getPropertySources().contains("bootstrapInProgress")) {
            return;
        }
        ConfigurableApplicationContext context = this.bootstrapServiceContext(environment, event.getSpringApplication());
        this.apply(context, event.getSpringApplication(), environment);
    }

    private ConfigurableApplicationContext bootstrapServiceContext(ConfigurableEnvironment environment, SpringApplication application) {
        StandardEnvironment bootstrapEnvironment = new StandardEnvironment();
        MutablePropertySources bootstrapProperties = bootstrapEnvironment.getPropertySources();
        for (PropertySource source : bootstrapProperties) {
            bootstrapProperties.remove(source.getName());
        }
        String configName = environment.resolvePlaceholders("${spring.cloud.bootstrap.name:bootstrap}");
        String configLocation = environment.resolvePlaceholders("${spring.cloud.bootstrap.location:}");
        HashMap<String, String> bootstrapMap = new HashMap<String, String>();
        bootstrapMap.put("spring.config.name", configName);
        if (StringUtils.hasText((String)configLocation)) {
            bootstrapMap.put("spring.config.location", configLocation);
        }
        bootstrapProperties.addFirst((PropertySource)new MapPropertySource(BOOTSTRAP_PROPERTY_SOURCE_NAME, bootstrapMap));
        bootstrapProperties.addFirst((PropertySource)new MapPropertySource("bootstrapInProgress", Collections.emptyMap()));
        for (PropertySource source : environment.getPropertySources()) {
            bootstrapProperties.addLast(source);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        List names = SpringFactoriesLoader.loadFactoryNames(BootstrapConfiguration.class, (ClassLoader)classLoader);
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[0]).profiles(environment.getActiveProfiles()).showBanner(false).environment((ConfigurableEnvironment)bootstrapEnvironment).properties(new String[]{"spring.application.name:" + configName}).web(false);
        ArrayList<Class> sources = new ArrayList<Class>();
        for (String name : names) {
            Class cls = ClassUtils.resolveClassName((String)name, null);
            try {
                cls.getDeclaredAnnotations();
            }
            catch (Exception e) {
                continue;
            }
            sources.add(cls);
        }
        builder.sources(sources.toArray(new Class[sources.size()]));
        AnnotationAwareOrderComparator.sort(sources);
        ConfigurableApplicationContext context = builder.run(new String[0]);
        this.addAncestorInitializer(application, context);
        bootstrapProperties.remove("bootstrapInProgress");
        return context;
    }

    private void addAncestorInitializer(SpringApplication application, ConfigurableApplicationContext context) {
        boolean installed = false;
        for (ApplicationContextInitializer initializer : application.getInitializers()) {
            if (!(initializer instanceof AncestorInitializer)) continue;
            installed = true;
            ((AncestorInitializer)initializer).setParent(context);
        }
        if (!installed) {
            application.setRegisterShutdownHook(false);
            application.addInitializers(new ApplicationContextInitializer[]{new AncestorInitializer(context)});
        }
    }

    private void apply(ConfigurableApplicationContext context, SpringApplication application, ConfigurableEnvironment environment) {
        List<ApplicationContextInitializer> initializers = this.getOrderedBeansOfType((ListableBeanFactory)context, ApplicationContextInitializer.class);
        application.addInitializers(initializers.toArray(new ApplicationContextInitializer[initializers.size()]));
    }

    private <T> List<T> getOrderedBeansOfType(ListableBeanFactory context, Class<T> type) {
        ArrayList<Object> result = new ArrayList<Object>();
        String[] stringArray = context.getBeanNamesForType(type);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result.add(context.getBean(name, type));
            ++n2;
        }
        AnnotationAwareOrderComparator.sort(result);
        return result;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    private static class AncestorInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext>,
    Ordered {
        private ConfigurableApplicationContext parent;

        public AncestorInitializer(ConfigurableApplicationContext parent) {
            this.parent = parent;
        }

        public void setParent(ConfigurableApplicationContext parent) {
            this.parent = parent;
        }

        public int getOrder() {
            return -2147483638;
        }

        public void initialize(ConfigurableApplicationContext context) {
            this.preemptMerge(context.getEnvironment().getPropertySources(), (PropertySource<?>)new MapPropertySource(BootstrapApplicationListener.BOOTSTRAP_PROPERTY_SOURCE_NAME, Collections.emptyMap()));
            while (context.getParent() != null && context.getParent() != context) {
                context = (ConfigurableApplicationContext)context.getParent();
            }
            new ParentContextApplicationContextInitializer((ApplicationContext)this.parent).initialize(context);
        }

        private void preemptMerge(MutablePropertySources propertySources, PropertySource<?> propertySource) {
            if (propertySource != null && !propertySources.contains(propertySource.getName())) {
                propertySources.addFirst(propertySource);
            }
        }
    }
}

