/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import java.util.Optional;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepositoryFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@ConditionalOnMissingBean(value={EnvironmentRepository.class})
class DefaultRepositoryConfiguration {
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private ConfigServerProperties server;
    @Autowired(required=false)
    private TransportConfigCallback transportConfigCallback;

    DefaultRepositoryConfiguration() {
    }

    @Bean
    public MultipleJGitEnvironmentRepository defaultEnvironmentRepository(MultipleJGitEnvironmentProperties environmentProperties) {
        MultipleJGitEnvironmentRepositoryFactory gitEnvironmentRepositoryFactory = new MultipleJGitEnvironmentRepositoryFactory(this.environment, this.server, Optional.ofNullable(this.transportConfigCallback));
        return gitEnvironmentRepositoryFactory.build(environmentProperties);
    }
}

