/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FileUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.config.server.environment.AbstractScmEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NoSuchLabelException;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.support.PassphraseCredentialsProvider;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JGitEnvironmentRepository
extends AbstractScmEnvironmentRepository
implements EnvironmentRepository,
SearchPathLocator,
InitializingBean {
    private static final String DEFAULT_LABEL = "master";
    private static final String FILE_URI_PREFIX = "file:";
    private int timeout = 5;
    private boolean initialized;
    private boolean cloneOnStart = false;
    private JGitFactory gitFactory = new JGitFactory();
    private String defaultLabel = "master";
    private CredentialsProvider gitCredentialsProvider;
    private boolean forcePull;

    public JGitEnvironmentRepository(ConfigurableEnvironment environment) {
        super(environment);
    }

    public boolean isCloneOnStart() {
        return this.cloneOnStart;
    }

    public void setCloneOnStart(boolean cloneOnStart) {
        this.cloneOnStart = cloneOnStart;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public JGitFactory getGitFactory() {
        return this.gitFactory;
    }

    public void setGitFactory(JGitFactory gitFactory) {
        this.gitFactory = gitFactory;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public boolean isForcePull() {
        return this.forcePull;
    }

    public void setForcePull(boolean forcePull) {
        this.forcePull = forcePull;
    }

    @Override
    public synchronized SearchPathLocator.Locations getLocations(String application, String profile, String label) {
        if (label == null) {
            label = this.defaultLabel;
        }
        String version = this.refresh(label);
        return new SearchPathLocator.Locations(application, profile, label, version, this.getSearchLocations(this.getWorkingDirectory(), application, profile, label));
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.getUri() != null ? 1 : 0) != 0, (String)"You need to configure a uri for the git repository");
        this.initialize();
        if (this.cloneOnStart) {
            this.initClonedRepository();
        }
    }

    private String refresh(String label) {
        this.initialize();
        Git git = null;
        try {
            git = this.createGitClient();
            if (this.shouldPull(git)) {
                this.fetch(git, label);
                this.checkout(git, label);
                if (this.isBranch(git, label)) {
                    this.merge(git, label);
                    if (!this.isClean(git)) {
                        this.logger.warn((Object)("The local repository is dirty. Resetting it to origin/" + label + "."));
                        this.resetHard(git, label, "refs/remotes/origin/" + label);
                    }
                }
            } else {
                this.checkout(git, label);
            }
            String string = git.getRepository().getRef("HEAD").getObjectId().getName();
            return string;
        }
        catch (RefNotFoundException e) {
            throw new NoSuchLabelException("No such label: " + label);
        }
        catch (GitAPIException e) {
            throw new IllegalStateException("Cannot clone or checkout repository", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load environment", e);
        }
        finally {
            try {
                if (git != null) {
                    git.close();
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Could not close git repository", (Throwable)e);
            }
        }
    }

    private void initClonedRepository() throws GitAPIException, IOException {
        if (!this.getUri().startsWith(FILE_URI_PREFIX)) {
            this.deleteBaseDirIfExists();
            Git git = this.cloneToBasedir();
            if (git != null) {
                git.close();
            }
            if ((git = this.openGitRepository()) != null) {
                git.close();
            }
        }
    }

    private Ref checkout(Git git, String label) throws GitAPIException {
        CheckoutCommand checkout = git.checkout();
        if (this.shouldTrack(git, label)) {
            this.trackBranch(git, checkout, label);
        } else {
            checkout.setName(label);
        }
        return checkout.call();
    }

    public boolean shouldPull(Git git) throws GitAPIException {
        boolean shouldPull;
        Status gitStatus = git.status().call();
        boolean isWorkingTreeClean = gitStatus.isClean();
        String originUrl = git.getRepository().getConfig().getString("remote", "origin", "url");
        if (this.forcePull && !isWorkingTreeClean) {
            shouldPull = true;
            this.logDirty(gitStatus);
        } else {
            boolean bl = shouldPull = isWorkingTreeClean && originUrl != null;
        }
        if (!isWorkingTreeClean && !this.forcePull) {
            this.logger.info((Object)("Cannot pull from remote " + originUrl + ", the working tree is not clean."));
        }
        return shouldPull;
    }

    private void logDirty(Status status) {
        Set<String> dirties = this.dirties(status.getAdded(), status.getChanged(), status.getRemoved(), status.getMissing(), status.getModified(), status.getConflicting(), status.getUntracked());
        this.logger.warn((Object)String.format("Dirty files found: %s", dirties));
    }

    private Set<String> dirties(Set<String> ... changes) {
        HashSet<String> dirties = new HashSet<String>();
        for (Set<String> files : changes) {
            dirties.addAll(files);
        }
        return dirties;
    }

    private boolean shouldTrack(Git git, String label) throws GitAPIException {
        return this.isBranch(git, label) && !this.isLocalBranch(git, label);
    }

    private FetchResult fetch(Git git, String label) {
        FetchCommand fetch = git.fetch();
        fetch.setRemote("origin");
        fetch.setTagOpt(TagOpt.FETCH_TAGS);
        this.setTimeout((TransportCommand<?, ?>)fetch);
        try {
            this.setCredentialsProvider((TransportCommand<?, ?>)fetch);
            FetchResult result = fetch.call();
            if (result.getTrackingRefUpdates() != null && result.getTrackingRefUpdates().size() > 0) {
                this.logger.info((Object)("Fetched for remote " + label + " and found " + result.getTrackingRefUpdates().size() + " updates"));
            }
            return result;
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Could not fetch remote for " + label + " remote: " + git.getRepository().getConfig().getString("remote", "origin", "url")));
            return null;
        }
    }

    private MergeResult merge(Git git, String label) {
        try {
            MergeCommand merge = git.merge();
            merge.include(git.getRepository().getRef("origin/" + label));
            MergeResult result = merge.call();
            if (!result.getMergeStatus().isSuccessful()) {
                this.logger.warn((Object)("Merged from remote " + label + " with result " + result.getMergeStatus()));
            }
            return result;
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Could not merge remote for " + label + " remote: " + git.getRepository().getConfig().getString("remote", "origin", "url")));
            return null;
        }
    }

    private Ref resetHard(Git git, String label, String ref) {
        ResetCommand reset = git.reset();
        reset.setRef(ref);
        reset.setMode(ResetCommand.ResetType.HARD);
        try {
            Ref resetRef = reset.call();
            if (resetRef != null) {
                this.logger.info((Object)("Reset label " + label + " to version " + resetRef.getObjectId()));
            }
            return resetRef;
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Could not reset to remote for " + label + " (current ref=" + ref + "), remote: " + git.getRepository().getConfig().getString("remote", "origin", "url")));
            return null;
        }
    }

    private Git createGitClient() throws IOException, GitAPIException {
        if (new File(this.getBasedir(), ".git").exists()) {
            return this.openGitRepository();
        }
        return this.copyRepository();
    }

    private synchronized Git copyRepository() throws IOException, GitAPIException {
        this.deleteBaseDirIfExists();
        this.getBasedir().mkdirs();
        Assert.state((boolean)this.getBasedir().exists(), (String)("Could not create basedir: " + this.getBasedir()));
        if (this.getUri().startsWith(FILE_URI_PREFIX)) {
            return this.copyFromLocalRepository();
        }
        return this.cloneToBasedir();
    }

    private Git openGitRepository() throws IOException {
        Git git = this.gitFactory.getGitByOpen(this.getWorkingDirectory());
        return git;
    }

    private Git copyFromLocalRepository() throws IOException {
        File remote = new UrlResource(StringUtils.cleanPath((String)this.getUri())).getFile();
        Assert.state((boolean)remote.isDirectory(), (String)("No directory at " + this.getUri()));
        File gitDir = new File(remote, ".git");
        Assert.state((boolean)gitDir.exists(), (String)("No .git at " + this.getUri()));
        Assert.state((boolean)gitDir.isDirectory(), (String)("No .git directory at " + this.getUri()));
        Git git = this.gitFactory.getGitByOpen(remote);
        return git;
    }

    private Git cloneToBasedir() throws GitAPIException {
        CloneCommand clone = this.gitFactory.getCloneCommandByCloneRepository().setURI(this.getUri()).setDirectory(this.getBasedir());
        this.setTimeout((TransportCommand<?, ?>)clone);
        this.setCredentialsProvider((TransportCommand<?, ?>)clone);
        try {
            return clone.call();
        }
        catch (GitAPIException e) {
            this.deleteBaseDirIfExists();
            throw e;
        }
    }

    private void deleteBaseDirIfExists() {
        if (this.getBasedir().exists()) {
            try {
                FileUtils.delete((File)this.getBasedir(), (int)1);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to initialize base directory", e);
            }
        }
    }

    private void initialize() {
        if (!this.initialized) {
            SshSessionFactory.setInstance((SshSessionFactory)new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host hc, Session session) {
                    session.setConfig("StrictHostKeyChecking", JGitEnvironmentRepository.this.isStrictHostKeyChecking() ? "yes" : "no");
                }
            });
            this.initialized = true;
        }
    }

    private void setCredentialsProvider(TransportCommand<?, ?> cmd) {
        if (this.gitCredentialsProvider != null) {
            cmd.setCredentialsProvider(this.gitCredentialsProvider);
        } else if (StringUtils.hasText((String)this.getUsername())) {
            cmd.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.getUsername(), this.getPassword()));
        } else if (StringUtils.hasText((String)this.getPassphrase())) {
            cmd.setCredentialsProvider((CredentialsProvider)new PassphraseCredentialsProvider(this.getPassphrase()));
        }
    }

    private void setTimeout(TransportCommand<?, ?> pull) {
        pull.setTimeout(this.timeout);
    }

    private boolean isClean(Git git) {
        StatusCommand status = git.status();
        try {
            return status.call().isClean();
        }
        catch (Exception e) {
            this.logger.warn((Object)("Could not execute status command on local repository. Cause: (" + e.getClass().getSimpleName() + ") " + e.getMessage()));
            return false;
        }
    }

    private void trackBranch(Git git, CheckoutCommand checkout, String label) {
        checkout.setCreateBranch(true).setName(label).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + label);
    }

    private boolean isBranch(Git git, String label) throws GitAPIException {
        return this.containsBranch(git, label, ListBranchCommand.ListMode.ALL);
    }

    private boolean isLocalBranch(Git git, String label) throws GitAPIException {
        return this.containsBranch(git, label, null);
    }

    private boolean containsBranch(Git git, String label, ListBranchCommand.ListMode listMode) throws GitAPIException {
        ListBranchCommand command = git.branchList();
        if (listMode != null) {
            command.setListMode(listMode);
        }
        List branches = command.call();
        for (Ref ref : branches) {
            if (!ref.getName().endsWith("/" + label)) continue;
            return true;
        }
        return false;
    }

    public CredentialsProvider getGitCredentialsProvider() {
        return this.gitCredentialsProvider;
    }

    public void setGitCredentialsProvider(CredentialsProvider gitCredentialsProvider) {
        this.gitCredentialsProvider = gitCredentialsProvider;
    }

    static class JGitFactory {
        JGitFactory() {
        }

        public Git getGitByOpen(File file) throws IOException {
            Git git = Git.open((File)file);
            return git;
        }

        public CloneCommand getCloneCommandByCloneRepository() {
            CloneCommand command = Git.cloneRepository();
            return command;
        }
    }
}

