/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

public class IdUtils {
    private static final String SEPARATOR = ":";

    public static String getDefaultInstanceId(PropertyResolver resolver) {
        String vcapInstanceId = resolver.getProperty("vcap.application.instance_id");
        if (StringUtils.hasText((String)vcapInstanceId)) {
            return vcapInstanceId;
        }
        String hostname = resolver.getProperty("spring.cloud.client.hostname");
        String appName = resolver.getProperty("spring.application.name");
        String namePart = IdUtils.combineParts(hostname, SEPARATOR, appName);
        String indexPart = resolver.getProperty("spring.application.instance_id", resolver.getProperty("server.port"));
        return IdUtils.combineParts(namePart, SEPARATOR, indexPart);
    }

    public static String combineParts(String firstPart, String separator, String secondPart) {
        String combined = null;
        if (firstPart != null && secondPart != null) {
            combined = firstPart + separator + secondPart;
        } else if (firstPart != null) {
            combined = firstPart;
        } else if (secondPart != null) {
            combined = secondPart;
        }
        return combined;
    }
}

