/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.composite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class CompositeDiscoveryClient
implements DiscoveryClient {
    private final List<DiscoveryClient> discoveryClients;

    public CompositeDiscoveryClient(List<DiscoveryClient> discoveryClients) {
        this.discoveryClients = discoveryClients;
    }

    @Override
    public String description() {
        return "Composite Discovery Client";
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceId) {
        if (this.discoveryClients != null) {
            for (DiscoveryClient discoveryClient : this.discoveryClients) {
                List<ServiceInstance> instances = discoveryClient.getInstances(serviceId);
                if (instances == null || instances.size() <= 0) continue;
                return instances;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getServices() {
        LinkedHashSet<String> services = new LinkedHashSet<String>();
        if (this.discoveryClients != null) {
            for (DiscoveryClient discoveryClient : this.discoveryClients) {
                List<String> serviceForClient = discoveryClient.getServices();
                if (serviceForClient == null) continue;
                services.addAll(serviceForClient);
            }
        }
        return new ArrayList<String>(services);
    }

    public List<DiscoveryClient> getDiscoveryClients() {
        return this.discoveryClients;
    }
}

