/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.util.LinkedHashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.util.InetUtils;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class HostInfoEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private int order = -2147483639;

    public int getOrder() {
        return this.order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        InetUtils.HostInfo hostInfo = InetUtils.getFirstNonLoopbackHostInfo();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("spring.cloud.client.hostname", hostInfo.getHostname());
        map.put("spring.cloud.client.ipAddress", hostInfo.getIpAddress());
        MapPropertySource propertySource = new MapPropertySource("springCloudClientHostInfo", map);
        environment.getPropertySources().addLast((PropertySource)propertySource);
    }
}

