/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.endpoint;

import java.util.Collections;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.cloud.bus.endpoint.AbstractBusEndpoint;
import org.springframework.cloud.bus.event.EnvironmentChangeRemoteApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@Endpoint(id="bus-env")
public class EnvironmentBusEndpoint
extends AbstractBusEndpoint {
    public EnvironmentBusEndpoint(ApplicationEventPublisher context, String id) {
        super(context, id);
    }

    @WriteOperation
    public void busEnvWithDestination(String name, String value, @Selector String destination) {
        Map<String, String> params = Collections.singletonMap(name, value);
        this.publish(new EnvironmentChangeRemoteApplicationEvent(this, this.getInstanceId(), destination, params));
    }

    @WriteOperation
    public void busEnv(String name, String value) {
        Map<String, String> params = Collections.singletonMap(name, value);
        this.publish(new EnvironmentChangeRemoteApplicationEvent(this, this.getInstanceId(), null, params));
    }
}

