/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinder;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.Jsr303ConfigurationPropertiesValidator;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Validator;

class ConfigurationPropertiesBinderBuilder {
    static final String VALIDATOR_BEAN_NAME = "configurationPropertiesValidator";
    static final String CONVERSION_SERVICE_BEAN_NAME = "conversionService";
    private static final String[] VALIDATOR_CLASSES = new String[]{"javax.validation.Validator", "javax.validation.ValidatorFactory", "javax.validation.bootstrap.GenericBootstrap"};
    private final ApplicationContext applicationContext;
    private ConversionService conversionService;
    private Validator validator;
    private Iterable<PropertySource<?>> propertySources;

    ConfigurationPropertiesBinderBuilder(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
        this.applicationContext = applicationContext;
    }

    ConfigurationPropertiesBinderBuilder withPropertySources(Iterable<PropertySource<?>> propertySources) {
        this.propertySources = propertySources;
        return this;
    }

    ConfigurationPropertiesBinder build() {
        return new ConfigurationPropertiesBinder(this.propertySources, this.determineConversionService(), this.determineValidator());
    }

    private Validator determineValidator() {
        if (this.validator != null) {
            return this.validator;
        }
        Validator defaultValidator = this.getOptionalBean(VALIDATOR_BEAN_NAME, Validator.class);
        if (defaultValidator != null) {
            return defaultValidator;
        }
        if (this.isJsr303Present()) {
            return new Jsr303ConfigurationPropertiesValidator(this.applicationContext);
        }
        return null;
    }

    private ConversionService determineConversionService() {
        if (this.conversionService != null) {
            return this.conversionService;
        }
        ConversionService conversionServiceByName = this.getOptionalBean(CONVERSION_SERVICE_BEAN_NAME, ConversionService.class);
        if (conversionServiceByName != null) {
            return conversionServiceByName;
        }
        return this.createDefaultConversionService();
    }

    private ConversionService createDefaultConversionService() {
        ConversionServiceFactory conversionServiceFactory = (ConversionServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(ConversionServiceFactory.class);
        return conversionServiceFactory.createConversionService();
    }

    private boolean isJsr303Present() {
        for (String validatorClass : VALIDATOR_CLASSES) {
            if (ClassUtils.isPresent((String)validatorClass, (ClassLoader)this.applicationContext.getClassLoader())) continue;
            return false;
        }
        return true;
    }

    private <T> T getOptionalBean(String name, Class<T> type) {
        try {
            return (T)this.applicationContext.getBean(name, type);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    private static class ConversionServiceFactory {
        private List<Converter<?, ?>> converters = Collections.emptyList();
        private List<GenericConverter> genericConverters = Collections.emptyList();

        private ConversionServiceFactory() {
        }

        @Autowired(required=false)
        @ConfigurationPropertiesBinding
        public void setConverters(List<Converter<?, ?>> converters) {
            this.converters = converters;
        }

        @Autowired(required=false)
        @ConfigurationPropertiesBinding
        public void setGenericConverters(List<GenericConverter> converters) {
            this.genericConverters = converters;
        }

        public ConversionService createConversionService() {
            DefaultConversionService conversionService = new DefaultConversionService();
            for (Converter<?, ?> converter : this.converters) {
                conversionService.addConverter(converter);
            }
            for (GenericConverter genericConverter : this.genericConverters) {
                conversionService.addConverter(genericConverter);
            }
            return conversionService;
        }
    }
}

