/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.bind.AggregateBinder;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.ResolvableTypeDescriptor;
import org.springframework.boot.context.properties.bind.UnboundConfigurationPropertiesException;
import org.springframework.boot.context.properties.bind.convert.BinderConversionService;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.core.ResolvableType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

abstract class IndexedElementsBinder<T>
extends AggregateBinder<T> {
    private static final String INDEX_ZERO = "[0]";

    IndexedElementsBinder(BindContext context) {
        super(context);
    }

    protected final void bindIndexed(ConfigurationPropertyName name, Bindable<?> target, AggregateElementBinder elementBinder, IndexedCollectionSupplier collection, ResolvableType aggregateType, ResolvableType elementType) {
        for (ConfigurationPropertySource source : this.getContext().getSources()) {
            this.bindIndexed(source, name, elementBinder, collection, aggregateType, elementType);
            if (!collection.wasSupplied() || collection.get() == null) continue;
            return;
        }
    }

    private void bindIndexed(ConfigurationPropertySource source, ConfigurationPropertyName root, AggregateElementBinder elementBinder, IndexedCollectionSupplier collection, ResolvableType aggregateType, ResolvableType elementType) {
        ConfigurationProperty property = source.getConfigurationProperty(root);
        if (property != null) {
            Object aggregate = this.convert(property.getValue(), aggregateType);
            ResolvableType collectionType = ResolvableType.forClassWithGenerics(((Collection)collection.get()).getClass(), (ResolvableType[])new ResolvableType[]{elementType});
            Collection elements = (Collection)this.convert(aggregate, collectionType);
            ((Collection)collection.get()).addAll(elements);
        } else {
            this.bindIndexed(source, root, elementBinder, collection, elementType);
        }
    }

    private void bindIndexed(ConfigurationPropertySource source, ConfigurationPropertyName root, AggregateElementBinder elementBinder, IndexedCollectionSupplier collection, ResolvableType elementType) {
        ConfigurationPropertyName name;
        Object value;
        MultiValueMap<String, ConfigurationProperty> knownIndexedChildren = this.getKnownIndexedChildren(source, root);
        for (int i = 0; i < Integer.MAX_VALUE && (value = elementBinder.bind(name = root.append(i == 0 ? INDEX_ZERO : "[" + i + "]"), Bindable.of(elementType), source)) != null; ++i) {
            knownIndexedChildren.remove((Object)name.getLastElement(ConfigurationPropertyName.Form.UNIFORM));
            ((Collection)collection.get()).add(value);
        }
        this.assertNoUnboundChildren(knownIndexedChildren);
    }

    private MultiValueMap<String, ConfigurationProperty> getKnownIndexedChildren(ConfigurationPropertySource source, ConfigurationPropertyName root) {
        LinkedMultiValueMap children = new LinkedMultiValueMap();
        if (!(source instanceof IterableConfigurationPropertySource)) {
            return children;
        }
        for (ConfigurationPropertyName name : (IterableConfigurationPropertySource)source.filter(root::isAncestorOf)) {
            if (!(name = name.chop(root.getNumberOfElements() + 1)).isLastElementIndexed()) continue;
            String key = name.getLastElement(ConfigurationPropertyName.Form.UNIFORM);
            ConfigurationProperty value = source.getConfigurationProperty(name);
            children.add((Object)key, (Object)value);
        }
        return children;
    }

    private void assertNoUnboundChildren(MultiValueMap<String, ConfigurationProperty> children) {
        if (!children.isEmpty()) {
            throw new UnboundConfigurationPropertiesException(children.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(TreeSet::new)));
        }
    }

    private <C> C convert(Object value, ResolvableType type) {
        value = this.getContext().getPlaceholdersResolver().resolvePlaceholders(value);
        BinderConversionService conversionService = this.getContext().getConversionService();
        return (C)ResolvableTypeDescriptor.forType(type, new Annotation[0]).convert(conversionService, value);
    }

    protected static class IndexedCollectionSupplier
    extends AggregateBinder.AggregateSupplier<Collection<Object>> {
        public IndexedCollectionSupplier(Supplier<Collection<Object>> supplier) {
            super(supplier);
        }
    }
}

