/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.server;

import java.io.File;
import org.springframework.boot.ApplicationHome;
import org.springframework.boot.ApplicationTemp;
import org.springframework.util.Assert;

class SessionStoreDirectory {
    private File directory;

    SessionStoreDirectory() {
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getValidDirectory(boolean mkdirs) {
        File dir = this.getDirectory();
        if (dir == null) {
            return new ApplicationTemp().getDir("servlet-sessions");
        }
        if (!dir.isAbsolute()) {
            dir = new File(new ApplicationHome().getDir(), dir.getPath());
        }
        if (!dir.exists() && mkdirs) {
            dir.mkdirs();
        }
        Assert.state((!mkdirs || dir.exists() ? 1 : 0) != 0, (String)("Session dir " + dir + " does not exist"));
        Assert.state((!dir.isFile() ? 1 : 0) != 0, (String)("Session dir " + dir + " points to a file"));
        return dir;
    }
}

