/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.io.IOException;
import java.security.KeyStore;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;
import org.apache.tomcat.util.net.jsse.JSSESocketFactory;
import org.springframework.boot.context.embedded.SslStoreProvider;

public class TomcatEmbeddedJSSEImplementation
extends JSSEImplementation {
    public ServerSocketFactory getServerSocketFactory(AbstractEndpoint<?> endpoint) {
        return new SocketFactory(endpoint);
    }

    public SSLUtil getSSLUtil(AbstractEndpoint<?> endpoint) {
        return new SocketFactory(endpoint);
    }

    static class SocketFactory
    extends JSSESocketFactory {
        private final SslStoreProvider sslStoreProvider;

        SocketFactory(AbstractEndpoint<?> endpoint) {
            super(endpoint);
            this.sslStoreProvider = (SslStoreProvider)endpoint.getAttribute("sslStoreProvider");
        }

        protected KeyStore getKeystore(String type, String provider, String pass) throws IOException {
            if (this.sslStoreProvider != null) {
                try {
                    KeyStore store = this.sslStoreProvider.getKeyStore();
                    if (store != null) {
                        return store;
                    }
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
            return super.getKeystore(type, provider, pass);
        }

        protected KeyStore getTrustStore(String keystoreType, String keystoreProvider) throws IOException {
            if (this.sslStoreProvider != null) {
                try {
                    KeyStore store = this.sslStoreProvider.getTrustStore();
                    if (store != null) {
                        return store;
                    }
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
            return super.getTrustStore(keystoreType, keystoreProvider);
        }
    }
}

