/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyValue;
import org.springframework.boot.bind.InetAddressEditor;
import org.springframework.boot.bind.OriginCapablePropertyValue;
import org.springframework.boot.bind.PropertyOrigin;
import org.springframework.boot.bind.RelaxedBindingNotWritablePropertyException;
import org.springframework.boot.bind.RelaxedConversionService;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.AbstractPropertyBindingResult;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.DataBinder;

public class RelaxedDataBinder
extends DataBinder {
    private static final Object BLANK = new Object();
    private String namePrefix;
    private boolean ignoreNestedProperties;
    private MultiValueMap<String, String> nameAliases = new LinkedMultiValueMap();

    public RelaxedDataBinder(Object target) {
        super(RelaxedDataBinder.wrapTarget(target));
    }

    public RelaxedDataBinder(Object target, String namePrefix) {
        super(RelaxedDataBinder.wrapTarget(target), StringUtils.hasLength((String)namePrefix) ? namePrefix : "target");
        this.namePrefix = this.cleanNamePrefix(namePrefix);
    }

    private String cleanNamePrefix(String namePrefix) {
        if (!StringUtils.hasLength((String)namePrefix)) {
            return null;
        }
        return namePrefix.endsWith(".") ? namePrefix : namePrefix + ".";
    }

    public void setIgnoreNestedProperties(boolean ignoreNestedProperties) {
        this.ignoreNestedProperties = ignoreNestedProperties;
    }

    public void setNameAliases(Map<String, List<String>> aliases) {
        this.nameAliases = new LinkedMultiValueMap(aliases);
    }

    public RelaxedDataBinder withAlias(String name, String ... alias) {
        for (String value : alias) {
            this.nameAliases.add((Object)name, (Object)value);
        }
        return this;
    }

    protected void doBind(MutablePropertyValues propertyValues) {
        super.doBind(this.modifyProperties(propertyValues, this.getTarget()));
    }

    private MutablePropertyValues modifyProperties(MutablePropertyValues propertyValues, Object target) {
        propertyValues = this.getPropertyValuesForNamePrefix(propertyValues);
        if (target instanceof MapHolder) {
            propertyValues = this.addMapPrefix(propertyValues);
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(target);
        wrapper.setConversionService((ConversionService)new RelaxedConversionService(this.getConversionService()));
        wrapper.setAutoGrowNestedPaths(true);
        ArrayList<PropertyValue> sortedValues = new ArrayList<PropertyValue>();
        HashSet<String> modifiedNames = new HashSet<String>();
        List<String> sortedNames = this.getSortedPropertyNames(propertyValues);
        for (String name : sortedNames) {
            PropertyValue propertyValue = propertyValues.getPropertyValue(name);
            PropertyValue modifiedProperty = this.modifyProperty((BeanWrapper)wrapper, propertyValue);
            if (!modifiedNames.add(modifiedProperty.getName())) continue;
            sortedValues.add(modifiedProperty);
        }
        return new MutablePropertyValues(sortedValues);
    }

    private List<String> getSortedPropertyNames(MutablePropertyValues propertyValues) {
        LinkedList<String> names = new LinkedList<String>();
        for (PropertyValue propertyValue : propertyValues.getPropertyValueList()) {
            names.add(propertyValue.getName());
        }
        this.sortPropertyNames(names);
        return names;
    }

    private void sortPropertyNames(List<String> names) {
        for (String name : new ArrayList<String>(names)) {
            int propertyIndex = names.indexOf(name);
            BeanPath path = new BeanPath(name);
            for (String prefix : path.prefixes()) {
                int prefixIndex = names.indexOf(prefix);
                if (prefixIndex < propertyIndex) continue;
                names.remove(name);
                names.add(prefixIndex, name);
            }
        }
    }

    private MutablePropertyValues addMapPrefix(MutablePropertyValues propertyValues) {
        MutablePropertyValues rtn = new MutablePropertyValues();
        for (PropertyValue pv : propertyValues.getPropertyValues()) {
            rtn.add("map." + pv.getName(), pv.getValue());
        }
        return rtn;
    }

    private MutablePropertyValues getPropertyValuesForNamePrefix(MutablePropertyValues propertyValues) {
        if (!StringUtils.hasText((String)this.namePrefix) && !this.ignoreNestedProperties) {
            return propertyValues;
        }
        MutablePropertyValues rtn = new MutablePropertyValues();
        for (PropertyValue value : propertyValues.getPropertyValues()) {
            String name = value.getName();
            for (String candidate : new RelaxedNames(this.namePrefix)) {
                if (!name.startsWith(candidate)) continue;
                name = name.substring(candidate.length());
                if (this.ignoreNestedProperties && name.contains(".")) continue;
                PropertyOrigin propertyOrigin = OriginCapablePropertyValue.getOrigin(value);
                rtn.addPropertyValue((PropertyValue)new OriginCapablePropertyValue(name, value.getValue(), propertyOrigin));
            }
        }
        return rtn;
    }

    private PropertyValue modifyProperty(BeanWrapper target, PropertyValue propertyValue) {
        String name = propertyValue.getName();
        String normalizedName = this.normalizePath(target, name);
        if (!normalizedName.equals(name)) {
            return new PropertyValue(normalizedName, propertyValue.getValue());
        }
        return propertyValue;
    }

    protected String normalizePath(BeanWrapper wrapper, String path) {
        return this.initializePath(wrapper, new BeanPath(path), 0);
    }

    protected AbstractPropertyBindingResult createBeanPropertyBindingResult() {
        return new RelaxedBeanPropertyBindingResult(this.getTarget(), this.getObjectName(), this.isAutoGrowNestedPaths(), this.getAutoGrowCollectionLimit(), this.getConversionService());
    }

    private String initializePath(BeanWrapper wrapper, BeanPath path, int index) {
        String prefix = path.prefix(index);
        String key = path.name(index);
        if (path.isProperty(index)) {
            key = this.getActualPropertyName(wrapper, prefix, key);
            path.rename(index, key);
        }
        if (path.name(++index) == null) {
            return path.toString();
        }
        String name = path.prefix(index);
        TypeDescriptor descriptor = wrapper.getPropertyTypeDescriptor(name);
        if (descriptor == null || descriptor.isMap()) {
            if (this.isMapValueStringType(descriptor) || this.isBlanked(wrapper, name, path.name(index))) {
                path.collapseKeys(index);
            }
            path.mapIndex(index);
            this.extendMapIfNecessary(wrapper, path, index);
        } else if (descriptor.isCollection()) {
            this.extendCollectionIfNecessary(wrapper, path, index);
        } else if (descriptor.getType().equals(Object.class)) {
            if (this.isBlanked(wrapper, name, path.name(index))) {
                path.collapseKeys(index);
            }
            path.mapIndex(index);
            if (path.isLastNode(index)) {
                wrapper.setPropertyValue(path.toString(), BLANK);
            } else {
                String next = path.prefix(index + 1);
                if (wrapper.getPropertyValue(next) == null) {
                    wrapper.setPropertyValue(next, new LinkedHashMap());
                }
            }
        }
        return this.initializePath(wrapper, path, index);
    }

    private boolean isMapValueStringType(TypeDescriptor descriptor) {
        if (descriptor == null || descriptor.getMapValueTypeDescriptor() == null) {
            return false;
        }
        Class valueType = descriptor.getMapValueTypeDescriptor().getObjectType();
        return valueType != null && CharSequence.class.isAssignableFrom(valueType);
    }

    private boolean isBlanked(BeanWrapper wrapper, String propertyName, String key) {
        Object value;
        Object object = value = wrapper.isReadableProperty(propertyName) ? wrapper.getPropertyValue(propertyName) : null;
        return value instanceof Map && ((Map)value).get(key) == BLANK;
    }

    private void extendCollectionIfNecessary(BeanWrapper wrapper, BeanPath path, int index) {
        String name = path.prefix(index);
        TypeDescriptor elementDescriptor = wrapper.getPropertyTypeDescriptor(name).getElementTypeDescriptor();
        if (!(elementDescriptor.isMap() || elementDescriptor.isCollection() || elementDescriptor.getType().equals(Object.class))) {
            return;
        }
        Cloneable extend = new LinkedHashMap();
        if (!elementDescriptor.isMap() && path.isArrayIndex(index + 1)) {
            extend = new ArrayList();
        }
        wrapper.setPropertyValue(path.prefix(index + 1), extend);
    }

    private void extendMapIfNecessary(BeanWrapper wrapper, BeanPath path, int index) {
        String name = path.prefix(index);
        TypeDescriptor parent = wrapper.getPropertyTypeDescriptor(name);
        if (parent == null) {
            return;
        }
        TypeDescriptor descriptor = parent.getMapValueTypeDescriptor();
        if (descriptor == null) {
            descriptor = TypeDescriptor.valueOf(Object.class);
        }
        if (!(descriptor.isMap() || descriptor.isCollection() || descriptor.getType().equals(Object.class))) {
            return;
        }
        String extensionName = path.prefix(index + 1);
        if (wrapper.isReadableProperty(extensionName)) {
            Object currentValue = wrapper.getPropertyValue(extensionName);
            if (descriptor.isCollection() && currentValue instanceof Collection || !descriptor.isCollection() && currentValue instanceof Map) {
                return;
            }
        }
        Object extend = new LinkedHashMap();
        if (descriptor.isCollection()) {
            extend = new ArrayList();
        }
        if (descriptor.getType().equals(Object.class) && path.isLastNode(index)) {
            extend = BLANK;
        }
        wrapper.setPropertyValue(extensionName, extend);
    }

    private String getActualPropertyName(BeanWrapper target, String prefix, String name) {
        String propertyName = this.resolvePropertyName(target, prefix, name);
        if (propertyName == null) {
            propertyName = this.resolveNestedPropertyName(target, prefix, name);
        }
        return propertyName == null ? name : propertyName;
    }

    private String resolveNestedPropertyName(BeanWrapper target, String prefix, String name) {
        StringBuilder candidate = new StringBuilder();
        for (String field : name.split("[_\\-\\.]")) {
            candidate.append(candidate.length() > 0 ? "." : "");
            candidate.append(field);
            String nested = this.resolvePropertyName(target, prefix, candidate.toString());
            if (nested == null) continue;
            Class type = target.getPropertyType(nested);
            if (type != null && Map.class.isAssignableFrom(type)) {
                return nested + "[" + name.substring(candidate.length() + 1) + "]";
            }
            String propertyName = this.resolvePropertyName(target, this.joinString(prefix, nested), name.substring(candidate.length() + 1));
            if (propertyName == null) continue;
            return this.joinString(nested, propertyName);
        }
        return null;
    }

    private String resolvePropertyName(BeanWrapper target, String prefix, String name) {
        Iterable<String> names = this.getNameAndAliases(name);
        for (String nameOrAlias : names) {
            for (String candidate : new RelaxedNames(nameOrAlias)) {
                try {
                    if (target.getPropertyType(this.joinString(prefix, candidate)) == null) continue;
                    return candidate;
                }
                catch (InvalidPropertyException invalidPropertyException) {
                }
            }
        }
        return null;
    }

    private String joinString(String prefix, String name) {
        return StringUtils.hasLength((String)prefix) ? prefix + "." + name : name;
    }

    private Iterable<String> getNameAndAliases(String name) {
        List aliases = (List)this.nameAliases.get((Object)name);
        if (aliases == null) {
            return Collections.singleton(name);
        }
        ArrayList<String> nameAndAliases = new ArrayList<String>(aliases.size() + 1);
        nameAndAliases.add(name);
        nameAndAliases.addAll(aliases);
        return nameAndAliases;
    }

    private static Object wrapTarget(Object target) {
        if (target instanceof Map) {
            Map map = (Map)target;
            target = new MapHolder(map);
        }
        return target;
    }

    private static class RelaxedBeanWrapper
    extends BeanWrapperImpl {
        private static final Set<String> BENIGN_PROPERTY_SOURCE_NAMES;

        public RelaxedBeanWrapper(Object target) {
            super(target);
        }

        public void setPropertyValue(PropertyValue pv) throws BeansException {
            try {
                super.setPropertyValue(pv);
            }
            catch (NotWritablePropertyException ex) {
                PropertyOrigin origin = OriginCapablePropertyValue.getOrigin(pv);
                if (this.isBenign(origin)) {
                    logger.debug((Object)"Ignoring benign property binding failure", (Throwable)ex);
                    return;
                }
                if (origin == null) {
                    throw ex;
                }
                throw new RelaxedBindingNotWritablePropertyException(ex, origin);
            }
        }

        private boolean isBenign(PropertyOrigin origin) {
            String name = origin == null ? null : origin.getSource().getName();
            return BENIGN_PROPERTY_SOURCE_NAMES.contains(name);
        }

        static {
            HashSet<String> names = new HashSet<String>();
            names.add("systemEnvironment");
            names.add("systemProperties");
            BENIGN_PROPERTY_SOURCE_NAMES = Collections.unmodifiableSet(names);
        }
    }

    private static class RelaxedBeanPropertyBindingResult
    extends BeanPropertyBindingResult {
        private RelaxedConversionService conversionService;

        public RelaxedBeanPropertyBindingResult(Object target, String objectName, boolean autoGrowNestedPaths, int autoGrowCollectionLimit, ConversionService conversionService) {
            super(target, objectName, autoGrowNestedPaths, autoGrowCollectionLimit);
            this.conversionService = new RelaxedConversionService(conversionService);
        }

        protected BeanWrapper createBeanWrapper() {
            RelaxedBeanWrapper beanWrapper = new RelaxedBeanWrapper(this.getTarget());
            beanWrapper.setConversionService(this.conversionService);
            beanWrapper.registerCustomEditor(InetAddress.class, new InetAddressEditor());
            return beanWrapper;
        }
    }

    private static class BeanPath {
        private List<PathNode> nodes;

        public BeanPath(String path) {
            this.nodes = this.splitPath(path);
        }

        public List<String> prefixes() {
            ArrayList<String> prefixes = new ArrayList<String>();
            for (int index = 1; index < this.nodes.size(); ++index) {
                prefixes.add(this.prefix(index));
            }
            return prefixes;
        }

        public boolean isLastNode(int index) {
            return index >= this.nodes.size() - 1;
        }

        private List<PathNode> splitPath(String path) {
            ArrayList<PathNode> nodes = new ArrayList<PathNode>();
            String current = this.extractIndexedPaths(path, nodes);
            for (String name : StringUtils.delimitedListToStringArray((String)current, (String)".")) {
                if (!StringUtils.hasText((String)name)) continue;
                nodes.add(new PropertyNode(name));
            }
            return nodes;
        }

        private String extractIndexedPaths(String path, List<PathNode> nodes) {
            int startRef = path.indexOf("[");
            String current = path;
            while (startRef >= 0) {
                int endRef;
                if (startRef > 0) {
                    nodes.addAll(this.splitPath(current.substring(0, startRef)));
                }
                if ((endRef = current.indexOf("]", startRef)) > 0) {
                    String sub = current.substring(startRef + 1, endRef);
                    if (sub.matches("[0-9]+")) {
                        nodes.add(new ArrayIndexNode(sub));
                    } else {
                        nodes.add(new MapIndexNode(sub));
                    }
                }
                current = current.substring(endRef + 1);
                startRef = current.indexOf("[");
            }
            return current;
        }

        public void collapseKeys(int index) {
            ArrayList<PathNode> revised = new ArrayList<PathNode>();
            for (int i = 0; i < index; ++i) {
                revised.add(this.nodes.get(i));
            }
            StringBuilder builder = new StringBuilder();
            for (int i = index; i < this.nodes.size(); ++i) {
                if (i > index) {
                    builder.append(".");
                }
                builder.append(this.nodes.get((int)i).name);
            }
            revised.add(new PropertyNode(builder.toString()));
            this.nodes = revised;
        }

        public void mapIndex(int index) {
            PathNode node = this.nodes.get(index);
            if (node instanceof PropertyNode) {
                node = ((PropertyNode)node).mapIndex();
            }
            this.nodes.set(index, node);
        }

        public String prefix(int index) {
            return this.range(0, index);
        }

        public void rename(int index, String name) {
            this.nodes.get((int)index).name = name;
        }

        public String name(int index) {
            if (index < this.nodes.size()) {
                return this.nodes.get((int)index).name;
            }
            return null;
        }

        private String range(int start, int end) {
            StringBuilder builder = new StringBuilder();
            for (int i = start; i < end; ++i) {
                PathNode node = this.nodes.get(i);
                builder.append(node);
            }
            if (builder.toString().startsWith(".")) {
                builder.replace(0, 1, "");
            }
            return builder.toString();
        }

        public boolean isArrayIndex(int index) {
            return this.nodes.get(index) instanceof ArrayIndexNode;
        }

        public boolean isProperty(int index) {
            return this.nodes.get(index) instanceof PropertyNode;
        }

        public String toString() {
            return this.prefix(this.nodes.size());
        }

        private static class PropertyNode
        extends PathNode {
            public PropertyNode(String name) {
                super(name);
            }

            public MapIndexNode mapIndex() {
                return new MapIndexNode(this.name);
            }

            public String toString() {
                return "." + this.name;
            }
        }

        private static class MapIndexNode
        extends PathNode {
            public MapIndexNode(String name) {
                super(name);
            }

            public String toString() {
                return "[" + this.name + "]";
            }
        }

        private static class ArrayIndexNode
        extends PathNode {
            public ArrayIndexNode(String name) {
                super(name);
            }

            public String toString() {
                return "[" + this.name + "]";
            }
        }

        private static class PathNode {
            protected String name;

            public PathNode(String name) {
                this.name = name;
            }
        }
    }

    static class MapHolder {
        private Map<String, Object> map;

        public MapHolder(Map<String, Object> map) {
            this.map = map;
        }

        public void setMap(Map<String, Object> map) {
            this.map = map;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }
    }
}

