/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.bind.OriginCapablePropertyValue;
import org.springframework.boot.bind.PatternPropertyNamePatternsMatcher;
import org.springframework.boot.bind.PropertyNamePatternsMatcher;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.Assert;

public class PropertySourcesPropertyValues
implements PropertyValues {
    private final Map<String, PropertyValue> propertyValues = new LinkedHashMap<String, PropertyValue>();
    private final PropertySources propertySources;
    private final Collection<String> propertyNames;
    private final PropertyNamePatternsMatcher includes;

    public PropertySourcesPropertyValues(PropertySources propertySources) {
        this(propertySources, (Collection<String>)null, PropertyNamePatternsMatcher.ALL);
    }

    public PropertySourcesPropertyValues(PropertySources propertySources, Collection<String> includePatterns, Collection<String> propertyNames) {
        this(propertySources, propertyNames, new PatternPropertyNamePatternsMatcher(includePatterns));
    }

    PropertySourcesPropertyValues(PropertySources propertySources, Collection<String> propertyNames, PropertyNamePatternsMatcher includes) {
        Assert.notNull((Object)propertySources, (String)"PropertySources must not be null");
        Assert.notNull((Object)includes, (String)"Includes must not be null");
        this.propertySources = propertySources;
        this.propertyNames = propertyNames == null ? Collections.emptySet() : propertyNames;
        this.includes = includes;
        PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver(propertySources);
        for (PropertySource source : propertySources) {
            this.processPropertySource(source, resolver);
        }
    }

    private void processPropertySource(PropertySource<?> source, PropertySourcesPropertyResolver resolver) {
        if (source instanceof CompositePropertySource) {
            this.processCompositePropertySource((CompositePropertySource)source, resolver);
        } else if (source instanceof EnumerablePropertySource) {
            this.processEnumerablePropertySource((EnumerablePropertySource)source, resolver, this.includes);
        } else {
            this.processNonEnumerablePropertySource(source, resolver);
        }
    }

    private void processCompositePropertySource(CompositePropertySource source, PropertySourcesPropertyResolver resolver) {
        for (PropertySource nested : source.getPropertySources()) {
            this.processPropertySource(nested, resolver);
        }
    }

    private void processEnumerablePropertySource(EnumerablePropertySource<?> source, PropertySourcesPropertyResolver resolver, PropertyNamePatternsMatcher includes) {
        if (source.getPropertyNames().length > 0) {
            for (String propertyName : source.getPropertyNames()) {
                if (!includes.matches(propertyName)) continue;
                Object value = this.getEnumerableProperty(source, resolver, propertyName);
                this.putIfAbsent(propertyName, value, (PropertySource<?>)source);
            }
        }
    }

    private Object getEnumerableProperty(EnumerablePropertySource<?> source, PropertySourcesPropertyResolver resolver, String propertyName) {
        try {
            return resolver.getProperty(propertyName, Object.class);
        }
        catch (RuntimeException ex) {
            return source.getProperty(propertyName);
        }
    }

    private void processNonEnumerablePropertySource(PropertySource<?> source, PropertySourcesPropertyResolver resolver) {
        for (String propertyName : this.propertyNames) {
            if (!source.containsProperty(propertyName)) continue;
            Object value = null;
            try {
                value = resolver.getProperty(propertyName, Object.class);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (value == null) {
                value = source.getProperty(propertyName.toUpperCase());
            }
            this.putIfAbsent(propertyName, value, source);
        }
    }

    private void putIfAbsent(String propertyName, Object value, PropertySource<?> source) {
        if (value != null && !this.propertyValues.containsKey(propertyName)) {
            this.propertyValues.put(propertyName, new OriginCapablePropertyValue(propertyName, value, propertyName, source));
        }
    }

    public PropertyValue[] getPropertyValues() {
        Collection<PropertyValue> values = this.propertyValues.values();
        return values.toArray(new PropertyValue[values.size()]);
    }

    public PropertyValue getPropertyValue(String propertyName) {
        PropertyValue propertyValue = this.propertyValues.get(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        for (PropertySource source : this.propertySources) {
            Object value = source.getProperty(propertyName);
            if (value == null) continue;
            propertyValue = new OriginCapablePropertyValue(propertyName, value, propertyName, source);
            this.propertyValues.put(propertyName, propertyValue);
            return propertyValue;
        }
        return null;
    }

    public PropertyValues changesSince(PropertyValues old) {
        MutablePropertyValues changes = new MutablePropertyValues();
        for (PropertyValue newValue : this.getPropertyValues()) {
            PropertyValue oldValue = old.getPropertyValue(newValue.getName());
            if (oldValue != null && oldValue.equals((Object)newValue)) continue;
            changes.addPropertyValue(newValue);
        }
        return changes;
    }

    public boolean contains(String propertyName) {
        return this.getPropertyValue(propertyName) != null;
    }

    public boolean isEmpty() {
        return this.propertyValues.isEmpty();
    }
}

