/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.boot.context.config.RandomValuePropertySource;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnumerableCompositePropertySource;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertySourcesLoader;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;

public class ConfigFileEnvironmentPostProcessor
implements EnvironmentPostProcessor,
ApplicationListener<ApplicationPreparedEvent>,
Ordered {
    private static final String DEFAULT_PROPERTIES = "defaultProperties";
    private static final String DEFAULT_SEARCH_LOCATIONS = "classpath:/,classpath:/config/,file:./,file:./config/";
    private static final String DEFAULT_NAMES = "application";
    public static final String ACTIVE_PROFILES_PROPERTY = "spring.profiles.active";
    public static final String INCLUDE_PROFILES_PROPERTY = "spring.profiles.include";
    public static final String CONFIG_NAME_PROPERTY = "spring.config.name";
    public static final String CONFIG_LOCATION_PROPERTY = "spring.config.location";
    public static final int DEFAULT_ORDER = -2147483638;
    private final DeferredLog logger = new DeferredLog();
    private String searchLocations;
    private String names;
    private int order = -2147483638;
    private final ConversionService conversionService = new DefaultConversionService();

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.addPropertySources(environment, application.getResourceLoader());
        this.bindToSpringApplication(environment, application);
    }

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        this.logger.replayTo(ConfigFileEnvironmentPostProcessor.class);
        this.addPostProcessors(event.getApplicationContext());
    }

    protected void addPropertySources(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
        RandomValuePropertySource.addToEnvironment(environment);
        try {
            new Loader(environment, resourceLoader).load();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load configuration files", ex);
        }
    }

    protected void bindToSpringApplication(ConfigurableEnvironment environment, SpringApplication application) {
        PropertiesConfigurationFactory<SpringApplication> binder = new PropertiesConfigurationFactory<SpringApplication>(application);
        binder.setTargetName("spring.main");
        binder.setConversionService(this.conversionService);
        binder.setPropertySources((PropertySources)environment.getPropertySources());
        try {
            binder.bindPropertiesToTarget();
        }
        catch (BindException ex) {
            throw new IllegalStateException("Cannot bind to SpringApplication", ex);
        }
    }

    protected void addPostProcessors(ConfigurableApplicationContext context) {
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PropertySourceOrderingPostProcessor(context));
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setSearchLocations(String locations) {
        Assert.hasLength((String)locations, (String)"Locations must not be empty");
        this.searchLocations = locations;
    }

    public void setSearchNames(String names) {
        Assert.hasLength((String)names, (String)"Names must not be empty");
        this.names = names;
    }

    static class ConfigurationPropertySources
    extends EnumerablePropertySource<Collection<PropertySource<?>>> {
        private static final String NAME = "applicationConfigurationProperties";
        private final Collection<PropertySource<?>> sources;
        private final String[] names;

        public ConfigurationPropertySources(Collection<PropertySource<?>> sources) {
            super(NAME, sources);
            this.sources = sources;
            ArrayList<String> names = new ArrayList<String>();
            for (PropertySource<?> source : sources) {
                if (!(source instanceof EnumerablePropertySource)) continue;
                names.addAll(Arrays.asList(((EnumerablePropertySource)source).getPropertyNames()));
            }
            this.names = names.toArray(new String[names.size()]);
        }

        public Object getProperty(String name) {
            for (PropertySource<?> propertySource : this.sources) {
                Object value = propertySource.getProperty(name);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        public static void finishAndRelocate(MutablePropertySources propertySources) {
            ConfigurationPropertySources removed = (ConfigurationPropertySources)propertySources.get(NAME);
            String name = NAME;
            if (removed != null) {
                for (PropertySource<?> propertySource : removed.sources) {
                    if (propertySource instanceof EnumerableCompositePropertySource) {
                        EnumerableCompositePropertySource composite = (EnumerableCompositePropertySource)propertySource;
                        for (PropertySource nested : (Collection)composite.getSource()) {
                            propertySources.addAfter(name, nested);
                            name = nested.getName();
                        }
                        continue;
                    }
                    propertySources.addAfter(name, propertySource);
                }
                propertySources.remove(NAME);
            }
        }

        public String[] getPropertyNames() {
            return this.names;
        }
    }

    private class Loader {
        private final Log logger;
        private final ConfigurableEnvironment environment;
        private final ResourceLoader resourceLoader;
        private PropertySourcesLoader propertiesLoader;
        private Queue<String> profiles;
        private boolean activatedProfiles;

        public Loader(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
            this.logger = ConfigFileEnvironmentPostProcessor.this.logger;
            this.environment = environment;
            this.resourceLoader = resourceLoader == null ? new DefaultResourceLoader() : resourceLoader;
        }

        public void load() throws IOException {
            this.propertiesLoader = new PropertySourcesLoader();
            this.profiles = Collections.asLifoQueue(new LinkedList());
            this.activatedProfiles = false;
            if (this.environment.containsProperty(ConfigFileEnvironmentPostProcessor.ACTIVE_PROFILES_PROPERTY)) {
                this.maybeActivateProfiles(this.environment.getProperty(ConfigFileEnvironmentPostProcessor.ACTIVE_PROFILES_PROPERTY));
            } else {
                String[] list = new ArrayList(Arrays.asList(this.environment.getActiveProfiles()));
                Collections.reverse(list);
                this.profiles.addAll((Collection<String>)list);
            }
            if (this.profiles.isEmpty()) {
                for (String defaultProfile : this.environment.getDefaultProfiles()) {
                    if (this.profiles.contains(defaultProfile)) continue;
                    this.profiles.add(defaultProfile);
                }
            }
            this.profiles.add(null);
            while (!this.profiles.isEmpty()) {
                String profile = this.profiles.poll();
                for (String location : this.getSearchLocations()) {
                    if (!location.endsWith("/")) {
                        this.load(location, null, profile);
                        continue;
                    }
                    for (String name : this.getSearchNames()) {
                        this.load(location, name, profile);
                    }
                }
            }
            this.addConfigurationProperties(this.propertiesLoader.getPropertySources());
        }

        private void load(String location, String name, String profile) throws IOException {
            String group = "profile=" + (profile == null ? "" : profile);
            if (!StringUtils.hasText((String)name)) {
                this.loadIntoGroup(group, location, profile);
            } else {
                for (String ext : this.propertiesLoader.getAllFileExtensions()) {
                    if (profile != null) {
                        this.loadIntoGroup(group, location + name + "-" + profile + "." + ext, null);
                        this.loadIntoGroup(group, location + name + "-" + profile + "." + ext, profile);
                    }
                    this.loadIntoGroup(group, location + name + "." + ext, profile);
                }
            }
        }

        private PropertySource<?> loadIntoGroup(String identifier, String location, String profile) throws IOException {
            Resource resource = this.resourceLoader.getResource(location);
            PropertySource<?> propertySource = null;
            StringBuilder msg = new StringBuilder();
            if (resource != null && resource.exists()) {
                String name = "applicationConfig: [" + location + "]";
                String group = "applicationConfig: [" + identifier + "]";
                propertySource = this.propertiesLoader.load(resource, group, name, profile);
                if (propertySource != null) {
                    msg.append("Loaded ");
                    this.maybeActivateProfiles(propertySource.getProperty(ConfigFileEnvironmentPostProcessor.ACTIVE_PROFILES_PROPERTY));
                    this.addIncludeProfiles(propertySource.getProperty(ConfigFileEnvironmentPostProcessor.INCLUDE_PROFILES_PROPERTY));
                } else {
                    msg.append("Skipped (empty) ");
                }
            } else {
                msg.append("Skipped ");
            }
            msg.append("config file ");
            msg.append("'").append(location).append("'");
            if (StringUtils.hasLength((String)profile)) {
                msg.append(" for profile ").append(profile);
            }
            if (resource == null || !resource.exists()) {
                msg.append(" resource not found");
                this.logger.trace((Object)msg);
            } else {
                this.logger.debug((Object)msg);
            }
            return propertySource;
        }

        private void maybeActivateProfiles(Object value) {
            if (this.activatedProfiles) {
                if (value != null) {
                    this.logger.debug((Object)("Profiles already activated, '" + value + "' will not be applied"));
                }
                return;
            }
            Set<String> profiles = this.getProfilesForValue(value);
            this.activateProfiles(profiles);
            if (profiles.size() > 0) {
                this.logger.debug((Object)("Activated profiles " + StringUtils.collectionToCommaDelimitedString(profiles)));
                this.activatedProfiles = true;
            }
        }

        private void addIncludeProfiles(Object value) {
            Set<String> profiles = this.getProfilesForValue(value);
            this.activateProfiles(profiles);
        }

        private Set<String> getProfilesForValue(Object property) {
            return this.asResolvedSet(property == null ? null : property.toString(), null);
        }

        private void activateProfiles(Set<String> profiles) {
            for (String profile : profiles) {
                this.profiles.add(profile);
                if (this.environment.acceptsProfiles(new String[]{profile})) continue;
                this.prependProfile(this.environment, profile);
            }
        }

        private void prependProfile(ConfigurableEnvironment environment, String profile) {
            LinkedHashSet<String> profiles = new LinkedHashSet<String>();
            environment.getActiveProfiles();
            profiles.add(profile);
            profiles.addAll(Arrays.asList(environment.getActiveProfiles()));
            environment.setActiveProfiles(profiles.toArray(new String[profiles.size()]));
        }

        private Set<String> getSearchLocations() {
            LinkedHashSet<String> locations = new LinkedHashSet<String>();
            if (this.environment.containsProperty(ConfigFileEnvironmentPostProcessor.CONFIG_LOCATION_PROPERTY)) {
                for (String path : this.asResolvedSet(this.environment.getProperty(ConfigFileEnvironmentPostProcessor.CONFIG_LOCATION_PROPERTY), null)) {
                    if (!path.contains("$") && !ResourceUtils.isUrl((String)(path = StringUtils.cleanPath((String)path)))) {
                        path = "file:" + path;
                    }
                    locations.add(path);
                }
            }
            locations.addAll(this.asResolvedSet(ConfigFileEnvironmentPostProcessor.this.searchLocations, ConfigFileEnvironmentPostProcessor.DEFAULT_SEARCH_LOCATIONS));
            return locations;
        }

        private Set<String> getSearchNames() {
            if (this.environment.containsProperty(ConfigFileEnvironmentPostProcessor.CONFIG_NAME_PROPERTY)) {
                return this.asResolvedSet(this.environment.getProperty(ConfigFileEnvironmentPostProcessor.CONFIG_NAME_PROPERTY), null);
            }
            return this.asResolvedSet(ConfigFileEnvironmentPostProcessor.this.names, ConfigFileEnvironmentPostProcessor.DEFAULT_NAMES);
        }

        private Set<String> asResolvedSet(String value, String fallback) {
            List<String> list = Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)(value != null ? this.environment.resolvePlaceholders(value) : fallback)));
            Collections.reverse(list);
            return new LinkedHashSet<String>(list);
        }

        private void addConfigurationProperties(MutablePropertySources sources) {
            ArrayList reorderedSources = new ArrayList();
            for (PropertySource item : sources) {
                reorderedSources.add(item);
            }
            this.environment.getPropertySources().addLast((PropertySource)new ConfigurationPropertySources(reorderedSources));
        }
    }

    private class PropertySourceOrderingPostProcessor
    implements BeanFactoryPostProcessor,
    Ordered {
        private ConfigurableApplicationContext context;

        public PropertySourceOrderingPostProcessor(ConfigurableApplicationContext context) {
            this.context = context;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            this.reorderSources(this.context.getEnvironment());
        }

        private void reorderSources(ConfigurableEnvironment environment) {
            ConfigurationPropertySources.finishAndRelocate(environment.getPropertySources());
            PropertySource defaultProperties = environment.getPropertySources().remove(ConfigFileEnvironmentPostProcessor.DEFAULT_PROPERTIES);
            if (defaultProperties != null) {
                environment.getPropertySources().addLast(defaultProperties);
            }
        }
    }
}

